/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.controller.ControllerRequestContext;
import org.apache.kafka.metadata.authorizer.AclMutator;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.Authorizer;

public interface ClusterMetadataAuthorizer
extends Authorizer {
    public void setAclMutator(AclMutator var1);

    public AclMutator aclMutatorOrException();

    public void completeInitialLoad();

    public void completeInitialLoad(Exception var1);

    public void loadAclSnapshot(Map<Uuid, ConfluentStandardAcl> var1);

    public void applyAclChanges(Map<Uuid, Optional<ConfluentStandardAcl>> var1);

    default public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings) {
        return this.createAcls(requestContext, aclBindings, AclState.ACTIVE);
    }

    default public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings, AclState aclState) {
        this.validateCreateAclState(aclState);
        ArrayList futures = new ArrayList(aclBindings.size());
        AclMutator aclMutator = this.aclMutatorOrException();
        aclBindings.forEach(b -> futures.add(new CompletableFuture()));
        ControllerRequestContext context = new ControllerRequestContext(requestContext, OptionalLong.empty());
        aclMutator.createAcls(context, aclBindings, aclState).whenComplete((results, throwable) -> {
            if (throwable == null && results.size() != futures.size()) {
                throwable = new UnknownServerException("Invalid size of result set from controller. Expected " + futures.size() + "; got " + results.size());
            }
            if (throwable == null) {
                for (int i = 0; i < futures.size(); ++i) {
                    ((CompletableFuture)futures.get(i)).complete(results.get(i));
                }
            } else {
                for (CompletableFuture future : futures) {
                    ApiException e = throwable instanceof ApiException ? (ApiException)throwable : ApiError.fromThrowable((Throwable)throwable).exception();
                    future.complete(new AclCreateResult(e));
                }
            }
        });
        return futures;
    }

    default public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, List<AclBindingFilter> filters) {
        return this.deleteAcls(requestContext, filters, Optional.empty(), AclState.ANY);
    }

    default public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, List<AclBindingFilter> filters, Optional<String> clusterId, AclState aclState) {
        this.validateDeleteAclState(aclState);
        ArrayList<CompletableFuture<AclDeleteResult>> futures = new ArrayList<CompletableFuture<AclDeleteResult>>(filters.size());
        filters.forEach(b -> futures.add(new CompletableFuture()));
        ControllerRequestContext context = new ControllerRequestContext(requestContext, OptionalLong.empty());
        if (aclState == AclState.ACTIVE) {
            for (int i = 0; i < filters.size(); ++i) {
                AclBindingFilter filter = filters.get(i);
                try {
                    AclCreateResult result = this.createInactiveAcls(requestContext, filter);
                    if (result.exception().isPresent()) {
                        ((CompletableFuture)futures.get(i)).complete(new AclDeleteResult((ApiException)result.exception().get()));
                        continue;
                    }
                    futures.set(i, this.hardDeleteAcls(context, Collections.singletonList(filter), aclState).get(0).toCompletableFuture());
                    continue;
                }
                catch (Throwable e) {
                    ((CompletableFuture)futures.get(i)).complete(new AclDeleteResult(ApiError.fromThrowable((Throwable)e).exception()));
                }
            }
            return futures;
        }
        return this.hardDeleteAcls(context, filters, aclState);
    }

    default public List<? extends CompletionStage<AclDeleteResult>> hardDeleteAcls(ControllerRequestContext context, List<AclBindingFilter> filters, AclState aclState) {
        ArrayList futures = new ArrayList(filters.size());
        AclMutator aclMutator = this.aclMutatorOrException();
        filters.forEach(b -> futures.add(new CompletableFuture()));
        aclMutator.deleteAcls(context, filters, aclState).whenComplete((results, throwable) -> {
            if (throwable == null && results.size() != futures.size()) {
                throwable = new UnknownServerException("Invalid size of result set from controller. Expected " + futures.size() + "; got " + results.size());
            }
            if (throwable == null) {
                for (int i = 0; i < futures.size(); ++i) {
                    ((CompletableFuture)futures.get(i)).complete(results.get(i));
                }
            } else {
                for (CompletableFuture future : futures) {
                    ApiException e = throwable instanceof ApiException ? (ApiException)throwable : ApiError.fromThrowable((Throwable)throwable).exception();
                    future.complete(new AclDeleteResult(e));
                }
            }
        });
        return futures;
    }

    default public AclCreateResult createInactiveAcls(AuthorizableRequestContext context, AclBindingFilter filter) throws RuntimeException, ExecutionException, InterruptedException {
        return AclCreateResult.SUCCESS;
    }

    default public void validateCreateAclState(AclState aclState) {
    }

    default public void validateDeleteAclState(AclState aclState) {
    }
}

