/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.Objects;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;

public final class StandardAclWithId {
    private final Uuid id;
    private final ConfluentStandardAcl acl;

    public static StandardAclWithId fromRecord(AccessControlEntryRecord record) {
        return new StandardAclWithId(record.id(), ConfluentStandardAcl.fromRecord(record));
    }

    public StandardAclWithId(Uuid id, ConfluentStandardAcl acl) {
        this.id = id;
        this.acl = acl;
    }

    public Uuid id() {
        return this.id;
    }

    public ConfluentStandardAcl acl() {
        return this.acl;
    }

    public AccessControlEntryRecord toRecord() {
        AccessControlEntryRecord record = new AccessControlEntryRecord().setId(this.id).setResourceType(this.acl.standardAcl().resourceType().code()).setResourceName(this.acl.standardAcl().resourceName()).setPatternType(this.acl.standardAcl().patternType().code()).setPrincipal(this.acl.standardAcl().principal()).setHost(this.acl.standardAcl().host()).setOperation(this.acl.standardAcl().operation().code()).setPermissionType(this.acl.standardAcl().permissionType().code()).setAclState(this.acl.aclState().code());
        this.acl.clusterLinkId().ifPresent(record::setClusterLinkId);
        return record;
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(StandardAclWithId.class)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        StandardAclWithId other = (StandardAclWithId)o;
        return this.id.equals((Object)other.id) && this.acl.equals(other.acl);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.acl);
    }

    public String toString() {
        return "StandardAclWithId(id=" + this.id + ", acl=" + this.acl + ")";
    }
}

