/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.config;

import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.config.ConfigMonitorKey;
import org.slf4j.Logger;

public final class ConfigMonitorKeyAndDefinition {
    private final ConfigMonitorKey key;
    private final ConfigDef.ConfigKey definition;

    public static ConfigMonitorKeyAndDefinition fromSchema(ConfigResource.Type resourceType, String keyName, KafkaConfigSchema schema, ConfigDef.Type expectedValueType) {
        ConfigMonitorKey key = new ConfigMonitorKey(resourceType, keyName);
        ConfigDef.ConfigKey definition = schema.configKey(resourceType, keyName);
        if (definition == null) {
            throw new RuntimeException("No config schema entry found for resource type " + resourceType + ", config keyName " + keyName);
        }
        if (!definition.type.equals((Object)expectedValueType)) {
            throw new RuntimeException("Unexpected value type for resource type " + resourceType + ", config keyName " + definition.name + "; needed " + expectedValueType + ", got " + definition.type);
        }
        return new ConfigMonitorKeyAndDefinition(key, definition);
    }

    public ConfigMonitorKeyAndDefinition(ConfigMonitorKey key, ConfigDef.ConfigKey definition) {
        this.key = key;
        this.definition = definition;
    }

    public ConfigMonitorKey key() {
        return this.key;
    }

    public ConfigDef.ConfigKey definition() {
        return this.definition;
    }

    boolean isSensitive() {
        return this.definition.type.isSensitive();
    }

    Object loadStaticValue(Logger log, Map<String, Object> configMap) {
        if (!configMap.containsKey(this.definition.name)) {
            if (log.isTraceEnabled()) {
                log.trace("Loaded initial value of {} from hard-coded node configuration as {}", (Object)this.definition.name, this.isSensitive() ? "[redacted]" : this.definition.defaultValue);
            }
            return this.definition.defaultValue;
        }
        try {
            Object result = ConfigDef.parseType((String)this.definition.name, (Object)configMap.get(this.definition.name), (ConfigDef.Type)this.definition.type);
            if (log.isTraceEnabled()) {
                log.trace("Loaded initial value of {} from static node configuration as {}", (Object)this.definition.name, this.isSensitive() ? "[redacted]" : result);
            }
            return result;
        }
        catch (ConfigException e) {
            log.error("Unable to parse statically configured value for {}. Falling back on hard-coded value of {}.", new Object[]{this.key.keyName(), this.isSensitive() ? "[redacted]" : this.definition.defaultValue, e});
            return this.definition.defaultValue;
        }
    }
}

