/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.metadata.ClusterLinkRecord;
import org.apache.kafka.common.protocol.MessageUtil;

public class ClusterLinkRecordJsonConverter {
    public static ClusterLinkRecord read(JsonNode _node, short _version) {
        ClusterLinkRecord _object = new ClusterLinkRecord();
        JsonNode _clusterLinkNameNode = _node.get("clusterLinkName");
        if (_clusterLinkNameNode == null) {
            throw new RuntimeException("ClusterLinkRecord: unable to locate field 'clusterLinkName', which is mandatory in version " + _version);
        }
        if (!_clusterLinkNameNode.isTextual()) {
            throw new RuntimeException("ClusterLinkRecord expected a string type, but got " + String.valueOf(_node.getNodeType()));
        }
        _object.clusterLinkName = _clusterLinkNameNode.asText();
        JsonNode _clusterLinkIdNode = _node.get("clusterLinkId");
        if (_clusterLinkIdNode == null) {
            throw new RuntimeException("ClusterLinkRecord: unable to locate field 'clusterLinkId', which is mandatory in version " + _version);
        }
        if (!_clusterLinkIdNode.isTextual()) {
            throw new RuntimeException("ClusterLinkRecord expected a JSON string type, but got " + String.valueOf(_node.getNodeType()));
        }
        _object.clusterLinkId = Uuid.fromString((String)_clusterLinkIdNode.asText());
        JsonNode _remoteClusterIdNode = _node.get("remoteClusterId");
        if (_remoteClusterIdNode == null) {
            throw new RuntimeException("ClusterLinkRecord: unable to locate field 'remoteClusterId', which is mandatory in version " + _version);
        }
        if (!_remoteClusterIdNode.isTextual()) {
            throw new RuntimeException("ClusterLinkRecord expected a string type, but got " + String.valueOf(_node.getNodeType()));
        }
        _object.remoteClusterId = _remoteClusterIdNode.asText();
        JsonNode _tenantPrefixNode = _node.get("tenantPrefix");
        if (_tenantPrefixNode == null) {
            _object.tenantPrefix = null;
        } else if (_tenantPrefixNode.isNull()) {
            _object.tenantPrefix = null;
        } else {
            if (!_tenantPrefixNode.isTextual()) {
                throw new RuntimeException("ClusterLinkRecord expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.tenantPrefix = _tenantPrefixNode.asText();
        }
        JsonNode _linkModeNode = _node.get("linkMode");
        if (_linkModeNode == null) {
            if (_version >= 1) {
                throw new RuntimeException("ClusterLinkRecord: unable to locate field 'linkMode', which is mandatory in version " + _version);
            }
            _object.linkMode = "DESTINATION";
        } else {
            if (!_linkModeNode.isTextual()) {
                throw new RuntimeException("ClusterLinkRecord expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.linkMode = _linkModeNode.asText();
        }
        JsonNode _switchoverMetadataNode = _node.get("switchoverMetadata");
        _object.switchoverMetadata = _switchoverMetadataNode == null ? null : (_switchoverMetadataNode.isNull() ? null : ClusterLinkSwitchoverMetadataRecordJsonConverter.read(_switchoverMetadataNode, _version));
        return _object;
    }

    public static JsonNode write(ClusterLinkRecord _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("clusterLinkName", (JsonNode)new TextNode(_object.clusterLinkName));
        _node.set("clusterLinkId", (JsonNode)new TextNode(_object.clusterLinkId.toString()));
        _node.set("remoteClusterId", (JsonNode)new TextNode(_object.remoteClusterId));
        if (_object.tenantPrefix != null) {
            _node.set("tenantPrefix", (JsonNode)new TextNode(_object.tenantPrefix));
        }
        if (_version >= 1) {
            _node.set("linkMode", (JsonNode)new TextNode(_object.linkMode));
        } else if (!_object.linkMode.equals("DESTINATION")) {
            throw new UnsupportedVersionException("Attempted to write a non-default linkMode at version " + _version);
        }
        if (_version >= 1) {
            if (_object.switchoverMetadata != null) {
                _node.set("switchoverMetadata", ClusterLinkSwitchoverMetadataRecordJsonConverter.write(_object.switchoverMetadata, _version, _serializeRecords));
            }
        } else if (_object.switchoverMetadata != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default switchoverMetadata at version " + _version);
        }
        return _node;
    }

    public static JsonNode write(ClusterLinkRecord _object, short _version) {
        return ClusterLinkRecordJsonConverter.write(_object, _version, true);
    }

    public static class ClusterLinkSwitchoverMetadataRecordJsonConverter {
        public static ClusterLinkRecord.ClusterLinkSwitchoverMetadataRecord read(JsonNode _node, short _version) {
            ClusterLinkRecord.ClusterLinkSwitchoverMetadataRecord _object = new ClusterLinkRecord.ClusterLinkSwitchoverMetadataRecord();
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ClusterLinkSwitchoverMetadataRecord");
            }
            JsonNode _switchoverTypeNode = _node.get("switchoverType");
            if (_switchoverTypeNode == null) {
                throw new RuntimeException("ClusterLinkSwitchoverMetadataRecord: unable to locate field 'switchoverType', which is mandatory in version " + _version);
            }
            _object.switchoverType = MessageUtil.jsonNodeToByte((JsonNode)_switchoverTypeNode, (String)"ClusterLinkSwitchoverMetadataRecord");
            JsonNode _switchoverTimestampNode = _node.get("switchoverTimestamp");
            if (_switchoverTimestampNode == null) {
                throw new RuntimeException("ClusterLinkSwitchoverMetadataRecord: unable to locate field 'switchoverTimestamp', which is mandatory in version " + _version);
            }
            _object.switchoverTimestamp = MessageUtil.jsonNodeToLong((JsonNode)_switchoverTimestampNode, (String)"ClusterLinkSwitchoverMetadataRecord");
            JsonNode _switchoverStateNode = _node.get("switchoverState");
            if (_switchoverStateNode == null) {
                throw new RuntimeException("ClusterLinkSwitchoverMetadataRecord: unable to locate field 'switchoverState', which is mandatory in version " + _version);
            }
            _object.switchoverState = MessageUtil.jsonNodeToByte((JsonNode)_switchoverStateNode, (String)"ClusterLinkSwitchoverMetadataRecord");
            JsonNode _errorCodeNode = _node.get("errorCode");
            if (_errorCodeNode == null) {
                throw new RuntimeException("ClusterLinkSwitchoverMetadataRecord: unable to locate field 'errorCode', which is mandatory in version " + _version);
            }
            _object.errorCode = MessageUtil.jsonNodeToShort((JsonNode)_errorCodeNode, (String)"ClusterLinkSwitchoverMetadataRecord");
            JsonNode _errorMessageNode = _node.get("errorMessage");
            if (_errorMessageNode == null) {
                throw new RuntimeException("ClusterLinkSwitchoverMetadataRecord: unable to locate field 'errorMessage', which is mandatory in version " + _version);
            }
            if (!_errorMessageNode.isTextual()) {
                throw new RuntimeException("ClusterLinkSwitchoverMetadataRecord expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.errorMessage = _errorMessageNode.asText();
            return _object;
        }

        public static JsonNode write(ClusterLinkRecord.ClusterLinkSwitchoverMetadataRecord _object, short _version, boolean _serializeRecords) {
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ClusterLinkSwitchoverMetadataRecord");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("switchoverType", (JsonNode)new ShortNode((short)_object.switchoverType));
            _node.set("switchoverTimestamp", (JsonNode)new LongNode(_object.switchoverTimestamp));
            _node.set("switchoverState", (JsonNode)new ShortNode((short)_object.switchoverState));
            _node.set("errorCode", (JsonNode)new ShortNode(_object.errorCode));
            _node.set("errorMessage", (JsonNode)new TextNode(_object.errorMessage));
            return _node;
        }

        public static JsonNode write(ClusterLinkRecord.ClusterLinkSwitchoverMetadataRecord _object, short _version) {
            return ClusterLinkSwitchoverMetadataRecordJsonConverter.write(_object, _version, true);
        }
    }
}

