/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.ClusterLinkChangeRecord;
import org.apache.kafka.common.metadata.ClusterLinkRecord;
import org.apache.kafka.image.ClusterLinkSwitchoverMetadataDelta;
import org.apache.kafka.metadata.ClusterLink;
import org.apache.kafka.metadata.ClusterLinkSwitchoverMetadata;

public final class ClusterLinkDelta {
    private final ClusterLink link;
    private ClusterLinkSwitchoverMetadataDelta switchoverMetadataDelta = ClusterLinkSwitchoverMetadataDelta.Unchanged.INSTANCE;

    public ClusterLinkDelta(ClusterLink link) {
        this.link = link;
    }

    public ClusterLink link() {
        return this.link;
    }

    public ClusterLinkSwitchoverMetadataDelta switchoverMetadataDelta() {
        return this.switchoverMetadataDelta;
    }

    public String linkName() {
        return this.link.linkName();
    }

    public Uuid linkId() {
        return this.link.linkId();
    }

    void replay(ClusterLinkChangeRecord record) {
        if (record.switchoverMetadata() != null) {
            ClusterLinkSwitchoverMetadata newValue = new ClusterLinkSwitchoverMetadata(record.switchoverMetadata());
            this.switchoverMetadataDelta = new ClusterLinkSwitchoverMetadataDelta.Changed(newValue);
        } else {
            this.switchoverMetadataDelta = ClusterLinkSwitchoverMetadataDelta.Unchanged.INSTANCE;
        }
    }

    void replay(ClusterLinkRecord record) {
        if (record.switchoverMetadata() != null) {
            ClusterLinkSwitchoverMetadata newValue = new ClusterLinkSwitchoverMetadata(record.switchoverMetadata());
            this.switchoverMetadataDelta = new ClusterLinkSwitchoverMetadataDelta.Changed(newValue);
        } else {
            this.switchoverMetadataDelta = ClusterLinkSwitchoverMetadataDelta.Unchanged.INSTANCE;
        }
    }

    public ClusterLink apply() {
        if (!this.switchoverMetadataDelta().changed()) {
            return this.link;
        }
        return new ClusterLink(this.link.linkName(), this.link.linkId(), this.link.tenantPrefix().orElse(""), this.link.remoteClusterId(), this.link.linkMode().toString(), ((ClusterLinkSwitchoverMetadataDelta.Changed)this.switchoverMetadataDelta).newValue().get());
    }

    public String toString() {
        return "ClusterLinkDelta(switchoverMetadataChanges=" + String.valueOf(this.switchoverMetadataDelta) + ", clusterLink=" + String.valueOf(this.link) + ")";
    }
}

