/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.metadata.ConfluentKeyValueStreamChangeRecord;
import org.apache.kafka.common.metadata.ConfluentKeyValueStreamEntryRecord;
import org.apache.kafka.common.metadata.ConfluentKeyValueStreamTopicRecord;
import org.apache.kafka.image.ConfluentKeyValueStreamsImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfluentKeyValueStreamsDelta {
    private final ConfluentKeyValueStreamsImage image;
    private final Map<Short, Map<String, String>> keyValueStreamsChanges = new LinkedHashMap<Short, Map<String, String>>();
    private final Map<Short, Map<Short, Long>> topicOffsetChanges = new LinkedHashMap<Short, Map<Short, Long>>();
    private Logger log = LoggerFactory.getLogger(ConfluentKeyValueStreamsDelta.class);

    public ConfluentKeyValueStreamsDelta(ConfluentKeyValueStreamsImage image) {
        this.image = image;
    }

    public Map<Short, Map<String, String>> keyValueStreamsChanges() {
        return this.keyValueStreamsChanges;
    }

    public Map<Short, Map<Short, Long>> topicOffsetChanges() {
        return this.topicOffsetChanges;
    }

    private void checkExistingTopicType(short type) {
        if (!this.keyValueStreamsChanges.containsKey(type)) {
            this.keyValueStreamsChanges.put(type, new LinkedHashMap());
            this.topicOffsetChanges.put(type, new LinkedHashMap());
        }
    }

    public void replay(ConfluentKeyValueStreamChangeRecord record) {
        this.checkExistingTopicType(record.type());
        if (record.entryValue().isEmpty() && this.keyValueStreamsChanges.get(record.type()).containsKey(record.entryKey())) {
            this.keyValueStreamsChanges.get(record.type()).remove(record.entryKey());
        } else {
            this.keyValueStreamsChanges.get(record.type()).put(record.entryKey(), record.entryValue());
        }
        this.topicOffsetChanges.get(record.type()).put(record.partition(), record.offset());
    }

    public void replay(ConfluentKeyValueStreamTopicRecord record) {
        this.checkExistingTopicType(record.type());
        for (ConfluentKeyValueStreamTopicRecord.Partition partition : record.partitions()) {
            this.topicOffsetChanges.get(record.type()).put(partition.id(), partition.offset());
        }
    }

    public void replay(ConfluentKeyValueStreamEntryRecord record) {
        this.checkExistingTopicType(record.type());
        if (record.entryValue().isEmpty() && this.keyValueStreamsChanges.get(record.type()).containsKey(record.entryKey())) {
            this.keyValueStreamsChanges.get(record.type()).remove(record.entryKey());
        } else {
            this.keyValueStreamsChanges.get(record.type()).put(record.entryKey(), record.entryValue());
        }
    }

    public ConfluentKeyValueStreamsImage apply() {
        short topicType;
        LinkedHashMap<Short, Map<String, String>> newTopicKv = new LinkedHashMap<Short, Map<String, String>>(this.image.topicTypeKv());
        LinkedHashMap<Short, Map<Short, Long>> newTopicOffset = new LinkedHashMap<Short, Map<Short, Long>>(this.image.topicTypeOffset());
        for (Map.Entry<Short, Map<String, String>> entry : this.keyValueStreamsChanges.entrySet()) {
            topicType = entry.getKey();
            LinkedHashMap<String, String> newKvRecords = new LinkedHashMap<String, String>(this.image.topicTypeKv().getOrDefault(topicType, new LinkedHashMap()));
            for (Map.Entry<String, String> kvEntry : entry.getValue().entrySet()) {
                if (kvEntry.getValue().isEmpty()) {
                    newKvRecords.remove(kvEntry.getKey());
                    continue;
                }
                newKvRecords.put(kvEntry.getKey(), kvEntry.getValue());
            }
            newTopicKv.put(topicType, newKvRecords);
        }
        for (Map.Entry<Short, Map<Object, Object>> entry : this.topicOffsetChanges.entrySet()) {
            topicType = entry.getKey();
            LinkedHashMap<Object, Object> newInternalTopicOffsets = new LinkedHashMap<Object, Object>(this.image.topicTypeOffset().getOrDefault(topicType, new LinkedHashMap()));
            newInternalTopicOffsets.putAll(entry.getValue());
            newTopicOffset.put(topicType, newInternalTopicOffsets);
        }
        return new ConfluentKeyValueStreamsImage(newTopicKv, newTopicOffset);
    }

    public void finishSnapshot() {
    }

    public String toString() {
        return "ConfluentKeyValueStreamsDelta(KeyValueStreamsChanges=" + this.keyValueStreamsChanges.entrySet().stream().map(e -> String.valueOf(e.getKey()) + "=" + String.valueOf(e.getValue())).collect(Collectors.joining(", ")) + ", TopicOffsetChanges=" + this.topicOffsetChanges.entrySet().stream().map(e -> String.valueOf(e.getKey()) + "=" + String.valueOf(e.getValue())).collect(Collectors.joining(", ")) + ")";
    }
}

