/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.server.quota.ClientQuotaClusterDescriber;

public class KRaftClientQuotaClusterDescriber
implements ClientQuotaClusterDescriber {
    private final TopicsImage image;

    public KRaftClientQuotaClusterDescriber(TopicsImage image) {
        this.image = image;
    }

    public Iterator<String> topicNames() {
        return this.image.topicsByName().keySet().iterator();
    }

    public Iterator<ClientQuotaClusterDescriber.Partition> partitionsForTopic(String topicName) {
        TopicImage topicImage = (TopicImage)this.image.topicsByName().get((Object)topicName);
        if (topicImage == null) {
            return Collections.emptyIterator();
        }
        return new PartitionIterator(topicImage.partitions().entrySet().iterator());
    }

    public static class PartitionIterator
    implements Iterator<ClientQuotaClusterDescriber.Partition> {
        private final Iterator<Map.Entry<Integer, PartitionRegistration>> iterator;

        public PartitionIterator(Iterator<Map.Entry<Integer, PartitionRegistration>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public ClientQuotaClusterDescriber.Partition next() {
            Map.Entry<Integer, PartitionRegistration> entry = this.iterator.next();
            return new ClientQuotaClusterDescriber.Partition(entry.getKey().intValue(), entry.getValue().leader);
        }
    }
}

