/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.Arrays;
import java.util.Collection;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.image.node.TopicsImageByIdNode;
import org.apache.kafka.image.node.TopicsImageByLinkIdNode;
import org.apache.kafka.image.node.TopicsImageByNameNode;
import org.apache.kafka.image.node.TopicsImageByTenantNode;

public class TopicsImageNode
implements MetadataNode {
    public static final String NAME = "topics";
    private final TopicsImage image;

    public TopicsImageNode(TopicsImage image) {
        this.image = image;
    }

    @Override
    public Collection<String> childNames() {
        return Arrays.asList("byName", "byId", "byTenant", "byLinkId");
    }

    @Override
    public MetadataNode child(String name) {
        if (name.equals("byName")) {
            return new TopicsImageByNameNode(this.image);
        }
        if (name.equals("byId")) {
            return new TopicsImageByIdNode(this.image);
        }
        if (name.equals("byTenant")) {
            return new TopicsImageByTenantNode(this.image);
        }
        if (name.equals("byLinkId")) {
            return new TopicsImageByLinkIdNode(this.image);
        }
        return null;
    }
}

