/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node.printer;

import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.metadata.KafkaConfigSchema;

public interface MetadataNodeRedactionCriteria {
    public boolean shouldRedactScram();

    default public boolean shouldRedactEncryptorSecret() {
        return this.shouldRedactScram();
    }

    public boolean shouldRedactDelegationToken();

    public boolean shouldRedactConfig(ConfigResource.Type var1, String var2);

    public static class Disabled
    implements MetadataNodeRedactionCriteria {
        public static final Disabled INSTANCE = new Disabled();

        @Override
        public boolean shouldRedactScram() {
            return false;
        }

        @Override
        public boolean shouldRedactDelegationToken() {
            return false;
        }

        @Override
        public boolean shouldRedactConfig(ConfigResource.Type type, String key) {
            return false;
        }
    }

    public static class Normal
    implements MetadataNodeRedactionCriteria {
        private final KafkaConfigSchema configSchema;

        public Normal(KafkaConfigSchema configSchema) {
            this.configSchema = configSchema;
        }

        @Override
        public boolean shouldRedactScram() {
            return true;
        }

        @Override
        public boolean shouldRedactDelegationToken() {
            return true;
        }

        @Override
        public boolean shouldRedactConfig(ConfigResource.Type type, String key) {
            return this.configSchema.isSensitive(type, key);
        }
    }

    public static class Strict
    implements MetadataNodeRedactionCriteria {
        public static final Strict INSTANCE = new Strict();

        @Override
        public boolean shouldRedactScram() {
            return true;
        }

        @Override
        public boolean shouldRedactDelegationToken() {
            return true;
        }

        @Override
        public boolean shouldRedactConfig(ConfigResource.Type type, String key) {
            return true;
        }
    }
}

