/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.metadata.BrokerReplicaExclusionRecord;

public class BrokerReplicaExclusion {
    private final int brokerId;
    private final String reason;

    public static BrokerReplicaExclusionRecord toBrokerReplicaExclusionRecord(Set<BrokerReplicaExclusion> replicaExclusions) {
        return new BrokerReplicaExclusionRecord().setBrokerExclusions(replicaExclusions.stream().map(replicaExclusion -> new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(replicaExclusion.getBrokerId()).setReason(replicaExclusion.getReason())).collect(Collectors.toList()));
    }

    public BrokerReplicaExclusion(int brokerId, String reason) {
        this.brokerId = brokerId;
        this.reason = reason;
    }

    public int getBrokerId() {
        return this.brokerId;
    }

    public String getReason() {
        return this.reason;
    }

    public String toString() {
        return "BrokerReplicaExclusion(, brokerId=" + this.brokerId + ", reason=" + this.reason + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrokerReplicaExclusion that = (BrokerReplicaExclusion)o;
        return this.brokerId == that.brokerId && this.reason == that.reason;
    }

    public int hashCode() {
        return Objects.hash(this.brokerId, this.reason);
    }
}

