/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionLinkState;

public class LeaderAndIsr {
    public static final int INITIAL_LEADER_EPOCH = 0;
    public static final int INITIAL_PARTITION_EPOCH = 0;
    public static final int NO_LEADER = -1;
    public static final int NO_EPOCH = -1;
    public static final int LEADER_DURING_DELETE = -2;
    public static final int EPOCH_DURING_DELETE = -2;
    private final int leader;
    private final int leaderEpoch;
    private final LeaderRecoveryState leaderRecoveryState;
    private final List<AlterPartitionRequestData.BrokerState> isrWithBrokerEpoch;
    private final int partitionEpoch;
    private final Optional<PartitionLinkState> clusterLinkState;

    public LeaderAndIsr(int leader, List<Integer> isr) {
        this(leader, 0, isr, LeaderRecoveryState.RECOVERED, 0, Optional.empty());
    }

    public LeaderAndIsr(int leader, int leaderEpoch, List<Integer> isr, LeaderRecoveryState leaderRecoveryState, int partitionEpoch, Optional<PartitionLinkState> clusterLinkState) {
        this(leader, leaderEpoch, leaderRecoveryState, isr.stream().map(brokerId -> new AlterPartitionRequestData.BrokerState().setBrokerId(brokerId.intValue())).collect(Collectors.toList()), partitionEpoch, clusterLinkState);
    }

    public LeaderAndIsr(int leader, int leaderEpoch, LeaderRecoveryState leaderRecoveryState, List<AlterPartitionRequestData.BrokerState> isrWithBrokerEpoch, int partitionEpoch, Optional<PartitionLinkState> clusterLinkState) {
        this.leader = leader;
        this.leaderEpoch = leaderEpoch;
        this.leaderRecoveryState = leaderRecoveryState;
        this.isrWithBrokerEpoch = isrWithBrokerEpoch;
        this.partitionEpoch = partitionEpoch;
        this.clusterLinkState = clusterLinkState;
    }

    public static LeaderAndIsr duringDelete(List<Integer> isr) {
        return new LeaderAndIsr(-2, isr);
    }

    public int leader() {
        return this.leader;
    }

    public int leaderEpoch() {
        return this.leaderEpoch;
    }

    public List<AlterPartitionRequestData.BrokerState> isrWithBrokerEpoch() {
        return this.isrWithBrokerEpoch;
    }

    public LeaderRecoveryState leaderRecoveryState() {
        return this.leaderRecoveryState;
    }

    public int partitionEpoch() {
        return this.partitionEpoch;
    }

    public Optional<PartitionLinkState> clusterLinkState() {
        return this.clusterLinkState;
    }

    public LeaderAndIsr withPartitionEpoch(int partitionEpoch) {
        return new LeaderAndIsr(this.leader, this.leaderEpoch, this.leaderRecoveryState, this.isrWithBrokerEpoch, partitionEpoch, this.clusterLinkState);
    }

    public LeaderAndIsr newLeader(int leader) {
        return this.newLeaderAndIsrWithBrokerEpoch(leader, this.isrWithBrokerEpoch);
    }

    public LeaderAndIsr newLeaderAndIsr(int leader, List<Integer> isr) {
        return new LeaderAndIsr(leader, this.nextEpoch(), isr, this.leaderRecoveryState, this.partitionEpoch, this.clusterLinkState);
    }

    private LeaderAndIsr newLeaderAndIsrWithBrokerEpoch(int leader, List<AlterPartitionRequestData.BrokerState> isrWithBrokerEpoch) {
        return new LeaderAndIsr(leader, this.nextEpoch(), this.leaderRecoveryState, isrWithBrokerEpoch, this.partitionEpoch, this.clusterLinkState);
    }

    public LeaderAndIsr newRecoveringLeaderAndIsr(int leader, List<Integer> isr) {
        return new LeaderAndIsr(leader, this.nextEpoch(), isr, LeaderRecoveryState.RECOVERING, this.partitionEpoch, this.clusterLinkState);
    }

    public LeaderAndIsr newEpoch() {
        return this.newLeaderAndIsrWithBrokerEpoch(this.leader, this.isrWithBrokerEpoch);
    }

    public LeaderAndIsr newEpochWithoutLinkLeader() {
        return this.newEpoch().withoutLinkLeader();
    }

    public LeaderAndIsr withoutLinkLeader() {
        return new LeaderAndIsr(this.leader, this.leaderEpoch, this.isr(), this.leaderRecoveryState, this.partitionEpoch, Optional.empty());
    }

    public LeaderAndIsr withoutLinkFailure() {
        PartitionLinkState state;
        if (this.clusterLinkState.isPresent() && (state = this.clusterLinkState.get()).linkFailed()) {
            return new LeaderAndIsr(this.leader, this.leaderEpoch, this.isr(), this.leaderRecoveryState, this.partitionEpoch, Optional.of(new PartitionLinkState(state.linkedLeaderEpoch(), false, MirrorTopicError.NO_ERROR)));
        }
        return this;
    }

    public Optional<Integer> leaderOpt() {
        return this.leader == -1 ? Optional.empty() : Optional.of(this.leader);
    }

    private int nextEpoch() {
        return Math.max(this.leaderEpoch + 1, this.clusterLinkState.map(PartitionLinkState::linkedLeaderEpoch).orElse(-1));
    }

    public List<Integer> isr() {
        return this.isrWithBrokerEpoch.stream().map(AlterPartitionRequestData.BrokerState::brokerId).collect(Collectors.toList());
    }

    public boolean equalsAllowStalePartitionEpoch(LeaderAndIsr other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.leader == other.leader && this.leaderEpoch == other.leaderEpoch && this.isrWithBrokerEpoch.equals(other.isrWithBrokerEpoch) && this.leaderRecoveryState == other.leaderRecoveryState && this.partitionEpoch <= other.partitionEpoch && this.clusterLinkState.equals(other.clusterLinkState);
    }

    public String toString() {
        return "LeaderAndIsr(leader=" + this.leader + ", leaderEpoch=" + this.leaderEpoch + ", isrWithBrokerEpoch=" + String.valueOf(this.isrWithBrokerEpoch) + ", leaderRecoveryState=" + String.valueOf((Object)this.leaderRecoveryState) + ", partitionEpoch=" + this.partitionEpoch + ", clusterLinkState=" + String.valueOf(this.clusterLinkState) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeaderAndIsr that = (LeaderAndIsr)o;
        return this.leader == that.leader && this.leaderEpoch == that.leaderEpoch && this.partitionEpoch == that.partitionEpoch && this.leaderRecoveryState == that.leaderRecoveryState && Objects.equals(this.isrWithBrokerEpoch, that.isrWithBrokerEpoch) && this.clusterLinkState.equals(that.clusterLinkState);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.leader, this.leaderEpoch, this.leaderRecoveryState, this.isrWithBrokerEpoch, this.partitionEpoch, this.clusterLinkState});
    }
}

