/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidReplicaDirectoriesException;
import org.apache.kafka.common.metadata.MirrorTopicChangeRecord;
import org.apache.kafka.common.metadata.MirrorTopicRecord;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.slf4j.Logger;

public class PartitionRegistration {
    public final int[] replicas;
    public final int[] observers;
    public final Uuid[] directories;
    public final int[] isr;
    public final int[] removingReplicas;
    public final int[] addingReplicas;
    public final int[] elr;
    public final int[] lastKnownElr;
    public final int leader;
    public final LeaderRecoveryState leaderRecoveryState;
    public final int leaderEpoch;
    public final int partitionEpoch;
    public final int linkedLeaderEpoch;
    public final LinkState linkState;
    public final int[] removingObservers;
    public final int[] addingObservers;

    public static boolean electionWasClean(int newLeader, int[] isr, int[] elr) {
        return newLeader == -1 || Replicas.contains(isr, newLeader) || Replicas.contains(elr, newLeader);
    }

    public static boolean electionFromElr(int newLeader, int[] elr) {
        return Replicas.contains(elr, newLeader);
    }

    private static List<Uuid> checkDirectories(PartitionRecord record) {
        if (record.directories() != null && !record.directories().isEmpty() && record.replicas().size() != record.directories().size()) {
            throw new InvalidReplicaDirectoriesException(record);
        }
        return record.directories();
    }

    private static List<Uuid> checkDirectories(PartitionChangeRecord record) {
        if (record.replicas() != null && record.directories() != null && !record.directories().isEmpty() && record.replicas().size() != record.directories().size()) {
            throw new InvalidReplicaDirectoriesException(record);
        }
        return record.directories();
    }

    private static boolean migratingDirectories(Uuid[] directories) {
        if (directories == null) {
            return true;
        }
        for (Uuid directory : directories) {
            if (DirectoryId.MIGRATING.equals((Object)directory)) continue;
            return false;
        }
        return true;
    }

    private static Uuid[] defaultToMigrating(Uuid[] directories, int numReplicas) {
        if (PartitionRegistration.migratingDirectories(directories)) {
            return DirectoryId.migratingArray((int)numReplicas);
        }
        return directories;
    }

    public PartitionRegistration(PartitionRecord record) {
        this(Replicas.toArray(record.replicas()), Replicas.toArray(record.observers()), PartitionRegistration.defaultToMigrating(Uuid.toArray(PartitionRegistration.checkDirectories(record)), record.replicas().size()), Replicas.toArray(record.isr()), Replicas.toArray(record.removingReplicas()), Replicas.toArray(record.addingReplicas()), Replicas.toArray(record.removingObservers()), Replicas.toArray(record.addingObservers()), record.leader(), LeaderRecoveryState.of(record.leaderRecoveryState()), record.leaderEpoch(), record.partitionEpoch(), record.linkedLeaderEpoch(), LinkState.fromCode(record.linkState()), Replicas.toArray(record.eligibleLeaderReplicas()), Replicas.toArray(record.lastKnownElr()));
    }

    private PartitionRegistration(int[] replicas, int[] observers, Uuid[] directories, int[] isr, int[] removingReplicas, int[] addingReplicas, int[] removingObservers, int[] addingObservers, int leader, LeaderRecoveryState leaderRecoveryState, int leaderEpoch, int partitionEpoch, int linkedLeaderEpoch, LinkState linkState, int[] elr, int[] lastKnownElr) {
        Objects.requireNonNull(directories);
        if (directories.length > 0 && directories.length != replicas.length) {
            throw new IllegalArgumentException("The lengths for replicas and directories do not match.");
        }
        this.replicas = replicas;
        this.observers = observers;
        this.directories = directories;
        this.isr = isr;
        this.removingReplicas = removingReplicas;
        this.addingReplicas = addingReplicas;
        this.leader = leader;
        this.leaderRecoveryState = leaderRecoveryState;
        this.leaderEpoch = leaderEpoch;
        this.partitionEpoch = partitionEpoch;
        this.linkedLeaderEpoch = linkedLeaderEpoch;
        this.linkState = linkState;
        this.removingObservers = removingObservers;
        this.addingObservers = addingObservers;
        this.elr = elr == null ? new int[]{} : elr;
        this.lastKnownElr = lastKnownElr == null ? new int[]{} : lastKnownElr;
    }

    public PartitionRegistration merge(PartitionChangeRecord record) {
        int newLinkedLeaderEpoch;
        LinkState newLinkState;
        int newLeaderEpoch;
        int newLeader;
        int[] newReplicas = record.replicas() == null ? this.replicas : Replicas.toArray(record.replicas());
        int[] newObservers = record.observers() == null ? this.observers : Replicas.toArray(record.observers());
        Uuid[] newDirectories = PartitionRegistration.defaultToMigrating(record.directories() == null ? this.directories : Uuid.toArray(PartitionRegistration.checkDirectories(record)), newReplicas.length);
        int[] newIsr = record.isr() == null ? this.isr : Replicas.toArray(record.isr());
        MergedReassignmentMetadata mergedReassignmentMetadata = MergedReassignmentMetadata.build(this, record);
        int[] newRemovingReplicas = mergedReassignmentMetadata.newRemovingReplicas;
        int[] newAddingReplicas = mergedReassignmentMetadata.newAddingReplicas;
        int[] newRemovingObservers = mergedReassignmentMetadata.newRemovingObservers;
        int[] newAddingObservers = mergedReassignmentMetadata.newAddingObservers;
        LinkState recordLinkState = LinkState.fromCode(record.linkState());
        if (this.linkState == LinkState.NOT_MIRROR && recordLinkState != LinkState.NOT_MIRROR) {
            throw new RuntimeException("Cannot merge a non-mirror partition registration with a mirror partition record");
        }
        if (record.leader() == -2) {
            newLeader = this.leader;
            newLeaderEpoch = this.linkState == LinkState.NOT_MIRROR ? this.leaderEpoch : Math.max(this.leaderEpoch, record.linkedLeaderEpoch());
        } else {
            newLeader = record.leader();
            newLeaderEpoch = this.linkState == LinkState.NOT_MIRROR ? this.leaderEpoch + 1 : Math.max(this.leaderEpoch + 1, record.linkedLeaderEpoch());
        }
        LeaderRecoveryState newLeaderRecoveryState = this.leaderRecoveryState.changeTo(record.leaderRecoveryState());
        if (this.linkState == LinkState.NOT_MIRROR) {
            newLinkState = this.linkState;
            newLinkedLeaderEpoch = this.linkedLeaderEpoch;
        } else {
            newLinkedLeaderEpoch = record.linkState() == LinkState.NOT_MIRROR.levelCode ? -1 : (record.linkedLeaderEpoch() == -1 ? this.linkedLeaderEpoch : record.linkedLeaderEpoch());
            newLinkState = recordLinkState;
        }
        int[] newElr = record.eligibleLeaderReplicas() == null ? this.elr : Replicas.toArray(record.eligibleLeaderReplicas());
        int[] newLastKnownElr = record.lastKnownElr() == null ? this.lastKnownElr : Replicas.toArray(record.lastKnownElr());
        return new PartitionRegistration(newReplicas, newObservers, newDirectories, newIsr, newRemovingReplicas, newAddingReplicas, newRemovingObservers, newAddingObservers, newLeader, newLeaderRecoveryState, newLeaderEpoch, this.partitionEpoch + 1, newLinkedLeaderEpoch, newLinkState, newElr, newLastKnownElr);
    }

    public PartitionRegistration merge(MirrorTopicChangeRecord record) {
        MirrorTopic.State newMirrorTopicState = MirrorTopic.State.fromStateName(record.mirrorTopicState());
        LinkState newLinkState = this.getLinkState(newMirrorTopicState);
        int newLinkedLeaderEpoch = this.getLinkedLeaderEpoch(newLinkState);
        int maybeNewLocalLeaderEpoch = record.bumpPartitionLeaderEpochs() ? this.leaderEpoch + 1 : this.leaderEpoch;
        return new PartitionRegistration(this.replicas, this.observers, this.directories, this.isr, this.removingReplicas, this.addingReplicas, this.removingObservers, this.addingObservers, this.leader, this.leaderRecoveryState, maybeNewLocalLeaderEpoch, this.partitionEpoch + 1, newLinkedLeaderEpoch, newLinkState, this.elr, this.lastKnownElr);
    }

    private LinkState getLinkState(MirrorTopic.State newMirrorTopicState) {
        LinkState newLinkState = newMirrorTopicState.equals((Object)MirrorTopic.State.STOPPED) ? LinkState.NOT_MIRROR : (newMirrorTopicState.equals((Object)MirrorTopic.State.FAILED) ? LinkState.FAILED : LinkState.ACTIVE);
        return newLinkState;
    }

    private int getLinkedLeaderEpoch(LinkState linkState) {
        if (linkState.equals((Object)LinkState.NOT_MIRROR)) {
            return -1;
        }
        return this.linkedLeaderEpoch;
    }

    public PartitionRegistration merge(MirrorTopicRecord record) {
        MirrorTopic.State newMirrorTopicState = MirrorTopic.State.fromStateName(record.mirrorTopicState());
        if (!newMirrorTopicState.equals((Object)MirrorTopic.State.PENDING_MIRROR) && !newMirrorTopicState.equals((Object)MirrorTopic.State.PENDING_SETUP_FOR_RESTORE)) {
            throw new IllegalStateException("Mirror topic " + record.topicName() + " is not in PENDING_MIRROR or PENDING_SETUP_FOR_RESTORE state. Cannot merge MirrorTopicRecord.");
        }
        LinkState newLinkState = this.getLinkState(newMirrorTopicState);
        int newLinkedLeaderEpoch = this.getLinkedLeaderEpoch(newLinkState);
        return new PartitionRegistration(this.replicas, this.observers, this.directories, this.isr, this.removingReplicas, this.addingReplicas, this.removingObservers, this.addingObservers, this.leader, this.leaderRecoveryState, this.leaderEpoch, this.partitionEpoch + 1, newLinkedLeaderEpoch, newLinkState, this.elr, this.lastKnownElr);
    }

    public String diff(PartitionRegistration prev) {
        return this.diff(prev, false);
    }

    String diff(PartitionRegistration prev, boolean ignoreDirectories) {
        StringBuilder builder = new StringBuilder();
        String prefix = "";
        if (!Arrays.equals(this.replicas, prev.replicas)) {
            builder.append(prefix).append("replicas: ").append(Arrays.toString(prev.replicas)).append(" -> ").append(Arrays.toString(this.replicas));
            prefix = ", ";
        }
        if (!Arrays.equals(this.observers, prev.observers)) {
            builder.append(prefix).append("observers: ").append(Arrays.toString(prev.observers)).append(" -> ").append(Arrays.toString(this.observers));
            prefix = ", ";
        }
        if (!ignoreDirectories && !Arrays.equals(this.directories, prev.directories)) {
            builder.append(prefix).append("directories: ").append(Arrays.toString(prev.directories)).append(" -> ").append(Arrays.toString(this.directories));
            prefix = ", ";
        }
        if (!Arrays.equals(this.isr, prev.isr)) {
            builder.append(prefix).append("isr: ").append(Arrays.toString(prev.isr)).append(" -> ").append(Arrays.toString(this.isr));
            prefix = ", ";
        }
        if (!Arrays.equals(this.removingReplicas, prev.removingReplicas)) {
            builder.append(prefix).append("removingReplicas: ").append(Arrays.toString(prev.removingReplicas)).append(" -> ").append(Arrays.toString(this.removingReplicas));
            prefix = ", ";
        }
        if (!Arrays.equals(this.addingReplicas, prev.addingReplicas)) {
            builder.append(prefix).append("addingReplicas: ").append(Arrays.toString(prev.addingReplicas)).append(" -> ").append(Arrays.toString(this.addingReplicas));
            prefix = ", ";
        }
        if (!Arrays.equals(this.removingObservers, prev.removingObservers)) {
            builder.append(prefix).append("removingObservers: ").append(Arrays.toString(prev.removingObservers)).append(" -> ").append(Arrays.toString(this.removingObservers));
            prefix = ", ";
        }
        if (!Arrays.equals(this.addingObservers, prev.addingObservers)) {
            builder.append(prefix).append("addingObservers: ").append(Arrays.toString(prev.addingObservers)).append(" -> ").append(Arrays.toString(this.addingObservers));
            prefix = ", ";
        }
        if (this.leader != prev.leader) {
            builder.append(prefix).append("leader: ").append(prev.leader).append(" -> ").append(this.leader);
            prefix = ", ";
        }
        if (this.leaderRecoveryState != prev.leaderRecoveryState) {
            builder.append(prefix).append("leaderRecoveryState: ").append((Object)prev.leaderRecoveryState).append(" -> ").append((Object)this.leaderRecoveryState);
            prefix = ", ";
        }
        if (this.leaderEpoch != prev.leaderEpoch) {
            builder.append(prefix).append("leaderEpoch: ").append(prev.leaderEpoch).append(" -> ").append(this.leaderEpoch);
            prefix = ", ";
        }
        if (!Arrays.equals(this.elr, prev.elr)) {
            builder.append(prefix).append("elr: ").append(Arrays.toString(prev.elr)).append(" -> ").append(Arrays.toString(this.elr));
            prefix = ", ";
        }
        if (!Arrays.equals(this.lastKnownElr, prev.lastKnownElr)) {
            builder.append(prefix).append("lastKnownElr: ").append(Arrays.toString(prev.lastKnownElr)).append(" -> ").append(Arrays.toString(this.lastKnownElr));
            prefix = ", ";
        }
        if (this.partitionEpoch != prev.partitionEpoch) {
            builder.append(prefix).append("partitionEpoch: ").append(prev.partitionEpoch).append(" -> ").append(this.partitionEpoch);
            prefix = ", ";
        }
        if (this.linkedLeaderEpoch != prev.linkedLeaderEpoch) {
            builder.append(prefix).append("linkedLeaderEpoch: ").append(prev.linkedLeaderEpoch).append(" -> ").append(this.linkedLeaderEpoch);
            prefix = ", ";
        }
        if (this.linkState != prev.linkState) {
            builder.append(prefix).append("linkedLeaderEpoch: ").append((Object)prev.linkState).append(" -> ").append((Object)this.linkState);
        }
        return builder.toString();
    }

    public PartitionRegistration unlink() {
        return new PartitionRegistration(this.replicas, this.observers, this.directories, this.isr, this.removingReplicas, this.addingReplicas, this.removingObservers, this.addingObservers, this.leader, this.leaderRecoveryState, this.leaderEpoch, this.partitionEpoch + 1, -1, LinkState.NOT_MIRROR, this.elr, this.lastKnownElr);
    }

    public void maybeLogPartitionChange(Logger log, String description, PartitionRegistration prev) {
        if (!PartitionRegistration.electionWasClean(this.leader, prev.isr, prev.elr)) {
            log.info("UNCLEAN partition change for {}: {}", (Object)description, (Object)this.diff(prev));
        } else if (log.isDebugEnabled()) {
            log.debug("partition change for {}: {}", (Object)description, (Object)this.diff(prev));
        }
    }

    public boolean hasLeader() {
        return this.leader != -1;
    }

    public boolean hasPreferredLeader() {
        return this.leader == this.preferredReplica();
    }

    public int preferredReplica() {
        return this.replicas.length == 0 ? -1 : this.replicas[0];
    }

    public boolean isMirror() {
        return this.linkState != LinkState.NOT_MIRROR;
    }

    public Uuid directory(int replica) {
        for (int i = 0; i < this.replicas.length; ++i) {
            if (this.replicas[i] != replica) continue;
            return this.directories[i];
        }
        throw new IllegalArgumentException("Replica " + replica + " is not assigned to this partition.");
    }

    public ApiMessageAndVersion toRecord(Uuid topicId, int partitionId, ImageWriterOptions options) {
        PartitionRecord record = new PartitionRecord().setPartitionId(partitionId).setTopicId(topicId).setReplicas(Replicas.toList(this.replicas)).setIsr(Replicas.toList(this.isr)).setRemovingReplicas(Replicas.toList(this.removingReplicas)).setAddingReplicas(Replicas.toList(this.addingReplicas)).setLeader(this.leader).setLeaderRecoveryState(this.leaderRecoveryState.value()).setLeaderEpoch(this.leaderEpoch).setPartitionEpoch(this.partitionEpoch).setLinkedLeaderEpoch(this.linkedLeaderEpoch).setLinkState(this.linkState.levelCode);
        if (!options.metadataVersion().isTopicPlacementSupported() && this.containsObserverMetadata()) {
            options.handleLoss("the observer metadata for topic " + String.valueOf(topicId) + ", partition " + partitionId + ".");
        } else {
            record.setObservers(Replicas.toList(this.observers));
            record.setRemovingObservers(Replicas.toList(this.removingObservers));
            record.setAddingObservers(Replicas.toList(this.addingObservers));
        }
        if (options.isEligibleLeaderReplicasEnabled()) {
            if (this.elr.length > 0) {
                record.setEligibleLeaderReplicas(Replicas.toList(this.elr));
            }
            if (this.lastKnownElr.length > 0) {
                record.setLastKnownElr(Replicas.toList(this.lastKnownElr));
            }
        }
        if (options.metadataVersion() == null) {
            options.handleLoss("the metadata version");
            return new ApiMessageAndVersion((ApiMessage)record, 0);
        }
        if (options.metadataVersion().isDirectoryAssignmentSupported()) {
            record.setDirectories(Uuid.toList((Uuid[])this.directories));
        } else {
            for (Uuid directory : this.directories) {
                if (DirectoryId.MIGRATING.equals((Object)directory)) continue;
                options.handleLoss("the directory assignment state of one or more replicas");
                break;
            }
        }
        return new ApiMessageAndVersion((ApiMessage)record, options.metadataVersion().partitionRecordVersion());
    }

    private boolean containsObserverMetadata() {
        return this.observers.length > 0 || this.removingObservers.length > 0 || this.addingObservers.length > 0;
    }

    public LeaderAndIsrRequest.PartitionState toLeaderAndIsrPartitionState(TopicIdPartition tp, boolean isNew, Optional<MirrorTopic> mirrorTopicOptional, Function<PartitionRegistration, List<Integer>> addingSyncReplicas) {
        LeaderAndIsrRequest.PartitionState state = new LeaderAndIsrRequest.PartitionState().setTopicName(tp.topic()).setPartitionIndex(tp.partition()).setControllerEpoch(-1).setLeader(this.leader).setLeaderEpoch(this.leaderEpoch).setIsr(Replicas.toList(this.isr)).setPartitionEpoch(this.partitionEpoch).setReplicas(Replicas.toList(this.replicas)).setObservers(PartitionRegistration.effectiveObservers(Replicas.toList(this.observers), addingSyncReplicas.apply(this))).setAddingReplicas(Replicas.toList(this.addingReplicas)).setRemovingReplicas(Replicas.toList(this.removingReplicas)).setLeaderRecoveryState(this.leaderRecoveryState.value()).setIsNew(isNew);
        mirrorTopicOptional.ifPresent(mirrorTopic -> {
            state.setLinkedLeaderEpoch(this.linkedLeaderEpoch).setClusterLinkTopicState(mirrorTopic.mirrorState().stateName()).setClusterLinkId(Utils.toJavaUuid((Uuid)mirrorTopic.linkId()).toString()).setClusterLinkSourceTopicId(mirrorTopic.sourceTopicId());
            if (mirrorTopic.mirrorStartOffsets() != null && mirrorTopic.mirrorStartOffsets().size() > tp.partition()) {
                state.setMirrorStartOffset(mirrorTopic.mirrorStartOffsets().get(tp.partition()).longValue());
            }
            if (mirrorTopic.mirrorStoppedOffsets() != null && mirrorTopic.mirrorStoppedOffsets().size() > tp.partition()) {
                state.setMirrorStoppedOffset(mirrorTopic.mirrorStoppedOffsets().get(tp.partition()).longValue());
            }
        });
        return state;
    }

    static List<Integer> effectiveObservers(List<Integer> observers, List<Integer> addingSyncReplicas) {
        ArrayList<Integer> replicas = new ArrayList<Integer>(observers);
        replicas.removeAll(addingSyncReplicas);
        return replicas;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Arrays.hashCode(this.replicas), Arrays.hashCode(this.observers), Arrays.hashCode(this.directories), Arrays.hashCode(this.isr), Arrays.hashCode(this.removingReplicas), Arrays.hashCode(this.addingReplicas), Arrays.hashCode(this.removingObservers), Arrays.hashCode(this.addingObservers), Arrays.hashCode(this.elr), Arrays.hashCode(this.lastKnownElr), this.leader, this.leaderRecoveryState, this.leaderEpoch, this.partitionEpoch, this.linkedLeaderEpoch, this.linkState.levelCode});
    }

    public boolean equals(Object o) {
        if (!(o instanceof PartitionRegistration)) {
            return false;
        }
        PartitionRegistration other = (PartitionRegistration)o;
        return Arrays.equals(this.replicas, other.replicas) && Arrays.equals(this.observers, other.observers) && Arrays.equals(this.directories, other.directories) && Arrays.equals(this.isr, other.isr) && Arrays.equals(this.removingReplicas, other.removingReplicas) && Arrays.equals(this.addingReplicas, other.addingReplicas) && Arrays.equals(this.removingObservers, other.removingObservers) && Arrays.equals(this.addingObservers, other.addingObservers) && Arrays.equals(this.elr, other.elr) && Arrays.equals(this.lastKnownElr, other.lastKnownElr) && this.leader == other.leader && this.leaderRecoveryState == other.leaderRecoveryState && this.leaderEpoch == other.leaderEpoch && this.partitionEpoch == other.partitionEpoch && this.linkedLeaderEpoch == other.linkedLeaderEpoch && this.linkState == other.linkState;
    }

    public PartitionRegistration withoutLink() {
        return new PartitionRegistration(this.replicas, this.observers, this.directories, this.isr, this.removingReplicas, this.addingReplicas, this.removingObservers, this.addingObservers, this.leader, this.leaderRecoveryState, this.leaderEpoch + 1, this.partitionEpoch, -1, LinkState.NOT_MIRROR, this.elr, this.lastKnownElr);
    }

    public String toString() {
        return "PartitionRegistration(replicas=" + Arrays.toString(this.replicas) + ", observers=" + Arrays.toString(this.observers) + ", directories=" + Arrays.toString(this.directories) + ", isr=" + Arrays.toString(this.isr) + ", removingReplicas=" + Arrays.toString(this.removingReplicas) + ", addingReplicas=" + Arrays.toString(this.addingReplicas) + ", removingObservers=" + Arrays.toString(this.removingObservers) + ", addingObservers=" + Arrays.toString(this.addingObservers) + ", elr=" + Arrays.toString(this.elr) + ", lastKnownElr=" + Arrays.toString(this.lastKnownElr) + ", leader=" + this.leader + ", leaderRecoveryState=" + String.valueOf((Object)this.leaderRecoveryState) + ", leaderEpoch=" + this.leaderEpoch + ", partitionEpoch=" + this.partitionEpoch + ", linkedLeaderEpoch=" + this.linkedLeaderEpoch + ", linkState=" + String.valueOf((Object)this.linkState) + ")";
    }

    public boolean hasSameAssignment(PartitionRegistration registration) {
        return Arrays.equals(this.replicas, registration.replicas) && Arrays.equals(this.directories, registration.directories) && Arrays.equals(this.addingReplicas, registration.addingReplicas) && Arrays.equals(this.removingReplicas, registration.removingReplicas);
    }

    public static enum LinkState {
        FAILED(1),
        ACTIVE(0),
        NOT_MIRROR(-1);

        public final byte levelCode;

        private LinkState(int levelCode) {
            this.levelCode = (byte)levelCode;
        }

        public static LinkState fromCode(int linkState) {
            LinkState value = linkState == 0 ? ACTIVE : (linkState == 1 ? FAILED : NOT_MIRROR);
            return value;
        }
    }

    private static class MergedReassignmentMetadata {
        final int[] newRemovingReplicas;
        final int[] newAddingReplicas;
        final int[] newRemovingObservers;
        final int[] newAddingObservers;

        public MergedReassignmentMetadata(int[] newRemovingReplicas, int[] newAddingReplicas, int[] newRemovingObservers, int[] newAddingObservers) {
            this.newRemovingReplicas = newRemovingReplicas;
            this.newAddingReplicas = newAddingReplicas;
            this.newRemovingObservers = newRemovingObservers;
            this.newAddingObservers = newAddingObservers;
        }

        private static MergedReassignmentMetadata build(PartitionRegistration part, PartitionChangeRecord record) {
            int[] newRemovingReplicas = record.removingReplicas() == null ? part.removingReplicas : Replicas.toArray(record.removingReplicas());
            int[] newAddingReplicas = record.addingReplicas() == null ? part.addingReplicas : Replicas.toArray(record.addingReplicas());
            int[] newRemovingObservers = record.removingObservers() == null ? part.removingObservers : Replicas.toArray(record.removingObservers());
            int[] newAddingObservers = record.addingObservers() == null ? part.addingObservers : Replicas.toArray(record.addingObservers());
            return new MergedReassignmentMetadata(newRemovingReplicas, newAddingReplicas, newRemovingObservers, newAddingObservers);
        }
    }

    public static class Builder {
        private int[] replicas;
        private int[] observers = Replicas.NONE;
        private Uuid[] directories;
        private int[] isr;
        private int[] removingReplicas = Replicas.NONE;
        private int[] addingReplicas = Replicas.NONE;
        private int[] removingObservers = Replicas.NONE;
        private int[] addingObservers = Replicas.NONE;
        private int[] elr = Replicas.NONE;
        private int[] lastKnownElr = Replicas.NONE;
        private Integer leader;
        private LeaderRecoveryState leaderRecoveryState;
        private Integer leaderEpoch;
        private Integer partitionEpoch;
        private Integer linkedLeaderEpoch = -1;
        private LinkState linkState = LinkState.NOT_MIRROR;

        public Builder setReplicas(int[] replicas) {
            this.replicas = replicas;
            return this;
        }

        public Builder setObservers(int[] observers) {
            this.observers = observers;
            return this;
        }

        public Builder setDirectories(Uuid[] directories) {
            this.directories = directories;
            return this;
        }

        public Builder setIsr(int[] isr) {
            this.isr = isr;
            return this;
        }

        public Builder setRemovingReplicas(int[] removingReplicas) {
            this.removingReplicas = removingReplicas;
            return this;
        }

        public Builder setAddingReplicas(int[] addingReplicas) {
            this.addingReplicas = addingReplicas;
            return this;
        }

        public Builder setRemovingObservers(int[] removingObservers) {
            this.removingObservers = removingObservers;
            return this;
        }

        public Builder setAddingObservers(int[] addingObservers) {
            this.addingObservers = addingObservers;
            return this;
        }

        public Builder setElr(int[] elr) {
            this.elr = elr;
            return this;
        }

        public Builder setLastKnownElr(int[] lastKnownElr) {
            this.lastKnownElr = lastKnownElr;
            return this;
        }

        public Builder setLeader(Integer leader) {
            this.leader = leader;
            return this;
        }

        public Builder setLeaderRecoveryState(LeaderRecoveryState leaderRecoveryState) {
            this.leaderRecoveryState = leaderRecoveryState;
            return this;
        }

        public Builder setLeaderEpoch(Integer leaderEpoch) {
            this.leaderEpoch = leaderEpoch;
            return this;
        }

        public Builder setPartitionEpoch(Integer partitionEpoch) {
            this.partitionEpoch = partitionEpoch;
            return this;
        }

        public Builder setLinkedLeaderEpoch(Integer linkedLeaderEpoch) {
            this.linkedLeaderEpoch = linkedLeaderEpoch;
            return this;
        }

        public Builder setLinkState(LinkState linkState) {
            this.linkState = linkState;
            return this;
        }

        public PartitionRegistration build() {
            if (this.replicas == null) {
                throw new IllegalStateException("You must set replicas.");
            }
            if (this.directories == null) {
                throw new IllegalStateException("You must set directories.");
            }
            if (this.directories.length != this.replicas.length) {
                throw new IllegalStateException("The lengths for replicas and directories do not match.");
            }
            if (this.isr == null) {
                throw new IllegalStateException("You must set isr.");
            }
            if (this.removingReplicas == null) {
                throw new IllegalStateException("You must set removing replicas.");
            }
            if (this.addingReplicas == null) {
                throw new IllegalStateException("You must set adding replicas.");
            }
            if (this.leader == null) {
                throw new IllegalStateException("You must set leader.");
            }
            if (this.leaderRecoveryState == null) {
                throw new IllegalStateException("You must set leader recovery state.");
            }
            if (this.leaderEpoch == null) {
                throw new IllegalStateException("You must set leader epoch.");
            }
            if (this.partitionEpoch == null) {
                throw new IllegalStateException("You must set partition epoch.");
            }
            if (this.observers == null) {
                throw new IllegalStateException("You must set observers.");
            }
            if (this.removingObservers == null) {
                throw new IllegalStateException("You must set removing observers.");
            }
            if (this.addingObservers == null) {
                throw new IllegalStateException("You must set adding observers.");
            }
            if (this.linkedLeaderEpoch == null) {
                throw new IllegalStateException("You must set linked leader epoch.");
            }
            if (this.linkState == null) {
                throw new IllegalStateException("You must set link state.");
            }
            if (this.elr == null) {
                throw new IllegalStateException("You must set ELR.");
            }
            if (this.lastKnownElr == null) {
                throw new IllegalStateException("You must set last known elr.");
            }
            return new PartitionRegistration(this.replicas, this.observers, this.directories, this.isr, this.removingReplicas, this.addingReplicas, this.removingObservers, this.addingObservers, this.leader, this.leaderRecoveryState, this.leaderEpoch, this.partitionEpoch, this.linkedLeaderEpoch, this.linkState, this.elr, this.lastKnownElr);
        }
    }
}

