/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.controller.metrics.ControllerMetadataMetrics;
import org.apache.kafka.controller.metrics.ControllerMetricsChanges;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.DegradedBrokerHealthState;
import org.apache.kafka.server.fault.FaultHandler;

public class ControllerMetadataMetricsPublisher
implements MetadataPublisher {
    private final ControllerMetadataMetrics metrics;
    private final FaultHandler faultHandler;
    private MetadataImage prevImage = MetadataImage.EMPTY;

    public ControllerMetadataMetricsPublisher(ControllerMetadataMetrics metrics, FaultHandler faultHandler) {
        this.metrics = metrics;
        this.faultHandler = faultHandler;
    }

    @Override
    public String name() {
        return "ControllerMetadataMetricsPublisher";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        switch (manifest.type()) {
            case LOG_DELTA: {
                try {
                    this.publishDelta(newImage, delta);
                    if (delta.brokerReplicaExclusionsDelta() == null) break;
                    this.metrics.setExcludedBrokerCount(newImage.brokerReplicaExclusions().activeBrokerReplicaExclusions().keySet().size());
                    break;
                }
                catch (Throwable e) {
                    this.faultHandler.handleFault("Failed to publish controller metrics from log delta  ending at offset " + manifest.provenance().lastContainedOffset(), e);
                    break;
                }
                finally {
                    this.prevImage = newImage;
                }
            }
            case SNAPSHOT: {
                try {
                    this.publishSnapshot(newImage);
                    break;
                }
                catch (Throwable e) {
                    this.faultHandler.handleFault("Failed to publish controller metrics from " + manifest.provenance().snapshotName(), e);
                    break;
                }
                finally {
                    this.prevImage = newImage;
                }
            }
        }
    }

    private void publishDelta(MetadataImage newImage, MetadataDelta delta) {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        if (delta.clusterDelta() != null) {
            for (Map.Entry<Integer, Optional<BrokerRegistration>> entry : delta.clusterDelta().changedBrokers().entrySet()) {
                changes.handleBrokerChange(this.prevImage.cluster().brokers().get(entry.getKey()), entry.getValue().orElse(null));
            }
        }
        changes.apply(this.metrics);
        if (delta.brokerReplicaExclusionsDelta() != null) {
            this.metrics.setExcludedBrokerCount(newImage.brokerReplicaExclusions().activeBrokerReplicaExclusions().keySet().size());
        }
    }

    private void publishSnapshot(MetadataImage newImage) {
        int fencedBrokers = 0;
        int activeBrokers = 0;
        int degradedBrokers = 0;
        int degradedStorageBrokers = 0;
        int degradedNetworkBrokers = 0;
        for (BrokerRegistration broker : newImage.cluster().brokers().values()) {
            if (broker.fenced()) {
                ++fencedBrokers;
            } else {
                ++activeBrokers;
            }
            if (broker.degradedComponents().isEmpty()) continue;
            ++degradedBrokers;
            if (DegradedBrokerHealthState.containsDesiredDegradedComponent(broker.degradedComponents(), BrokerComponent.STORAGE)) {
                ++degradedStorageBrokers;
            }
            if (!DegradedBrokerHealthState.containsDesiredDegradedComponent(broker.degradedComponents(), BrokerComponent.NETWORK)) continue;
            ++degradedNetworkBrokers;
        }
        this.metrics.setFencedBrokerCount(fencedBrokers);
        this.metrics.setActiveBrokerCount(activeBrokers);
        this.metrics.setExcludedBrokerCount(newImage.brokerReplicaExclusions().activeBrokerReplicaExclusions().keySet().size());
        this.metrics.setBrokersWithDegradedHealthCount(degradedBrokers);
        this.metrics.setBrokersWithDegradedStorageCount(degradedStorageBrokers);
        this.metrics.setBrokersWithDegradedNetworkCount(degradedNetworkBrokers);
    }

    @Override
    public void close() {
        this.metrics.close();
    }
}

