/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.node.MetadataLeafNode;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;

public class AclsImageByIdNode
implements MetadataNode {
    public static final String NAME = "byId";
    private final AclsImage image;

    public AclsImageByIdNode(AclsImage image) {
        this.image = image;
    }

    @Override
    public Collection<String> childNames() {
        ArrayList<String> childNames = new ArrayList<String>();
        for (Uuid uuid : this.image.acls().keySet()) {
            childNames.add(uuid.toString());
        }
        return childNames;
    }

    @Override
    public MetadataNode child(String name) {
        Uuid uuid;
        try {
            uuid = Uuid.fromString((String)name);
        }
        catch (Exception e) {
            return null;
        }
        ConfluentStandardAcl acl = this.image.acls().get(uuid);
        if (acl == null) {
            return null;
        }
        return new MetadataLeafNode(acl.toString());
    }
}

