/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.Arrays;
import java.util.Collection;
import org.apache.kafka.image.ClusterLinksImage;
import org.apache.kafka.image.node.ClusterLinksImageByIdNode;
import org.apache.kafka.image.node.ClusterLinksImageByNameNode;
import org.apache.kafka.image.node.LinkNamesByTenantNode;
import org.apache.kafka.image.node.MetadataNode;

public class ClusterLinksImageNode
implements MetadataNode {
    public static final String NAME = "clusterLinks";
    private final ClusterLinksImage image;

    public ClusterLinksImageNode(ClusterLinksImage image) {
        this.image = image;
    }

    @Override
    public Collection<String> childNames() {
        return Arrays.asList("byId", "byName", "linkNamesByTenant");
    }

    @Override
    public MetadataNode child(String name) {
        if (name.equals("byId")) {
            return new ClusterLinksImageByIdNode(this.image);
        }
        if (name.equals("byName")) {
            return new ClusterLinksImageByNameNode(this.image);
        }
        if (name.equals("linkNamesByTenant")) {
            return new LinkNamesByTenantNode(this.image);
        }
        return null;
    }
}

