/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.writer;

import java.util.function.Consumer;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.writer.UnwritableMetadataException;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.server.common.MetadataVersion;

public final class ImageWriterOptions {
    private final MetadataVersion metadataVersion;
    private final Consumer<UnwritableMetadataException> lossHandler;
    private final KafkaConfigSchema configSchema;
    private final boolean isEligibleLeaderReplicasEnabled;

    private ImageWriterOptions(MetadataVersion metadataVersion, Consumer<UnwritableMetadataException> lossHandler, KafkaConfigSchema configSchema, boolean isEligibleLeaderReplicasEnabled) {
        this.metadataVersion = metadataVersion;
        this.lossHandler = lossHandler;
        this.configSchema = configSchema;
        this.isEligibleLeaderReplicasEnabled = isEligibleLeaderReplicasEnabled;
    }

    public MetadataVersion metadataVersion() {
        return this.metadataVersion;
    }

    public boolean isEligibleLeaderReplicasEnabled() {
        return this.isEligibleLeaderReplicasEnabled;
    }

    public void handleLoss(String loss) {
        this.lossHandler.accept(new UnwritableMetadataException(this.metadataVersion, loss));
    }

    public KafkaConfigSchema configSchema() {
        return this.configSchema;
    }

    public static class Builder {
        private MetadataVersion metadataVersion;
        private Consumer<UnwritableMetadataException> lossHandler = e -> {
            throw e;
        };
        private boolean isEligibleLeaderReplicasEnabled = false;
        private KafkaConfigSchema configSchema = KafkaConfigSchema.EMPTY;

        public Builder(MetadataVersion metadataVersion) {
            this.metadataVersion = metadataVersion;
        }

        public Builder(MetadataImage image) {
            this.metadataVersion = image.features().metadataVersionOrThrow();
            this.isEligibleLeaderReplicasEnabled = image.features().isElrEnabled();
        }

        public Builder setMetadataVersion(MetadataVersion metadataVersion) {
            this.metadataVersion = metadataVersion;
            return this;
        }

        public Builder setEligibleLeaderReplicasEnabled(boolean isEligibleLeaderReplicasEnabled) {
            this.isEligibleLeaderReplicasEnabled = isEligibleLeaderReplicasEnabled;
            return this;
        }

        public MetadataVersion metadataVersion() {
            return this.metadataVersion;
        }

        public boolean isEligibleLeaderReplicasEnabled() {
            return this.isEligibleLeaderReplicasEnabled;
        }

        public Builder setLossHandler(Consumer<UnwritableMetadataException> lossHandler) {
            this.lossHandler = lossHandler;
            return this;
        }

        public Builder setConfigSchema(KafkaConfigSchema configSchema) {
            this.configSchema = configSchema;
            return this;
        }

        public ImageWriterOptions build() {
            return new ImageWriterOptions(this.metadataVersion, this.lossHandler, this.configSchema, this.isEligibleLeaderReplicasEnabled);
        }
    }
}

