/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.bootstrap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;

public class BootstrapMetadata {
    private final List<ApiMessageAndVersion> records;
    private final BootstrapMetadataLevel level;
    private final String source;

    public static BootstrapMetadata fromVersions(MetadataVersion metadataVersion, Map<String, Short> featureVersions, String source) {
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        records.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("confluent.metadata.version").setFeatureLevel(metadataVersion.confluentFeatureLevel()), 0));
        ArrayList featureNames = new ArrayList(featureVersions.size());
        featureVersions.keySet().forEach(n -> {
            if (!(n.equals("confluent.metadata.version") || n.equals("metadata.version") || n.equals("kraft.version"))) {
                featureNames.add(n);
            }
        });
        featureNames.sort(String::compareTo);
        for (String featureName : featureNames) {
            short level = featureVersions.get(featureName);
            if (level <= 0) continue;
            records.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName(featureName).setFeatureLevel(level), 0));
        }
        return new BootstrapMetadata(records, new BootstrapMetadataLevel(metadataVersion.confluentFeatureLevel(), false), source);
    }

    public static BootstrapMetadata fromVersion(MetadataVersion metadataVersion, String source) {
        List<ApiMessageAndVersion> records = List.of(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("confluent.metadata.version").setFeatureLevel(metadataVersion.confluentFeatureLevel()), 0));
        return new BootstrapMetadata(records, new BootstrapMetadataLevel(metadataVersion.confluentFeatureLevel(), false), source);
    }

    public static BootstrapMetadata fromRecords(List<ApiMessageAndVersion> records, String source) {
        Optional<Object> metadataVersionLevel = Optional.empty();
        for (ApiMessageAndVersion record : records) {
            Optional<BootstrapMetadataLevel> level = BootstrapMetadata.recordToMetadataVersionLevel(record.message());
            if (!level.isPresent()) continue;
            metadataVersionLevel = level;
        }
        if (metadataVersionLevel.isEmpty()) {
            throw new RuntimeException("No FeatureLevelRecord for metadata.version or confluent.metadata.version was found in the bootstrap metadata from " + source);
        }
        return new BootstrapMetadata(records, (BootstrapMetadataLevel)metadataVersionLevel.get(), source);
    }

    public static Optional<BootstrapMetadataLevel> recordToMetadataVersionLevel(ApiMessage record) {
        if (record instanceof FeatureLevelRecord) {
            FeatureLevelRecord featureLevel = (FeatureLevelRecord)record;
            if (featureLevel.name().equals("metadata.version")) {
                return Optional.of(new BootstrapMetadataLevel(featureLevel.featureLevel(), true));
            }
            if (featureLevel.name().equals("confluent.metadata.version")) {
                return Optional.of(new BootstrapMetadataLevel(featureLevel.featureLevel(), false));
            }
        }
        return Optional.empty();
    }

    BootstrapMetadata(List<ApiMessageAndVersion> records, BootstrapMetadataLevel level, String source) {
        this.records = Objects.requireNonNull(records);
        this.level = level;
        Objects.requireNonNull(source);
        this.source = source;
    }

    public List<ApiMessageAndVersion> records() {
        return this.records;
    }

    public MetadataVersion metadataVersion() {
        if (this.level.isApache) {
            return MetadataVersion.fromApacheFeatureLevel((short)this.level.level);
        }
        return MetadataVersion.fromConfluentFeatureLevel((short)this.level.level);
    }

    public String source() {
        return this.source;
    }

    public short featureLevel(String featureName) {
        short result = 0;
        for (ApiMessageAndVersion record : this.records) {
            FeatureLevelRecord message;
            ApiMessage apiMessage = record.message();
            if (!(apiMessage instanceof FeatureLevelRecord) || !(message = (FeatureLevelRecord)apiMessage).name().equals(featureName)) continue;
            result = message.featureLevel();
        }
        return result;
    }

    public BootstrapMetadata copyWithFeatureRecord(String featureName, short level) {
        int i;
        ArrayList<ApiMessageAndVersion> newRecords = new ArrayList<ApiMessageAndVersion>();
        for (i = 0; i < this.records.size(); ++i) {
            ApiMessage apiMessage = this.records.get(i).message();
            if (!(apiMessage instanceof FeatureLevelRecord)) continue;
            FeatureLevelRecord record = (FeatureLevelRecord)apiMessage;
            if (record.name().equals(featureName)) {
                FeatureLevelRecord newRecord = record.duplicate();
                newRecord.setFeatureLevel(level);
                newRecords.add(new ApiMessageAndVersion((ApiMessage)newRecord, 0));
                break;
            }
            newRecords.add(this.records.get(i));
        }
        if (i == this.records.size()) {
            FeatureLevelRecord newRecord = new FeatureLevelRecord().setName(featureName).setFeatureLevel(level);
            newRecords.add(new ApiMessageAndVersion((ApiMessage)newRecord, 0));
        }
        return BootstrapMetadata.fromRecords(newRecords, this.source);
    }

    public int hashCode() {
        return Objects.hash(this.records, this.level, this.source);
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        BootstrapMetadata other = (BootstrapMetadata)o;
        return Objects.equals(this.records, other.records) && this.level.equals(other.level) && this.source.equals(other.source);
    }

    public String toString() {
        return "BootstrapMetadata(records=" + this.records.toString() + ", metadataVersionLevel=" + String.valueOf(this.level) + ", source=" + this.source + ")";
    }

    record BootstrapMetadataLevel(short level, boolean isApache) {
    }
}

