/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class BrokerRegistrationChangeRecord
implements ApiMessage {
    int brokerId;
    long brokerEpoch;
    byte fenced;
    byte inControlledShutdown;
    List<DegradedComponent> degradedComponents;
    List<Uuid> logDirs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("broker_id", (Type)Type.INT32, "The broker id."), new Field("broker_epoch", (Type)Type.INT64, "The broker epoch assigned by the controller."), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("fenced", (Type)Type.INT8, "-1 if the broker has been unfenced, 0 if no change, 1 if the broker has been fenced.")})});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("broker_id", (Type)Type.INT32, "The broker id."), new Field("broker_epoch", (Type)Type.INT64, "The broker epoch assigned by the controller."), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("fenced", (Type)Type.INT8, "-1 if the broker has been unfenced, 0 if no change, 1 if the broker has been fenced."), 1, new Field("in_controlled_shutdown", (Type)Type.INT8, "0 if no change, 1 if the broker is in controlled shutdown."), 10000, new Field("degraded_components", (Type)CompactArrayOf.nullable((Type)DegradedComponent.SCHEMA_1), "Null if no change to broker status, list of new degraded components if changes exist.")})});
    public static final Schema SCHEMA_2 = new Schema(new Field[]{new Field("broker_id", (Type)Type.INT32, "The broker id."), new Field("broker_epoch", (Type)Type.INT64, "The broker epoch assigned by the controller."), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("fenced", (Type)Type.INT8, "-1 if the broker has been unfenced, 0 if no change, 1 if the broker has been fenced."), 1, new Field("in_controlled_shutdown", (Type)Type.INT8, "0 if no change, 1 if the broker is in controlled shutdown."), 10000, new Field("degraded_components", (Type)CompactArrayOf.nullable((Type)DegradedComponent.SCHEMA_1), "Null if no change to broker status, list of new degraded components if changes exist."), 2, new Field("log_dirs", (Type)new CompactArrayOf((Type)Type.UUID), "Log directories configured in this broker which are available.")})});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 2;

    public BrokerRegistrationChangeRecord(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public BrokerRegistrationChangeRecord(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public BrokerRegistrationChangeRecord() {
        this.brokerId = 0;
        this.brokerEpoch = 0L;
        this.fenced = 0;
        this.inControlledShutdown = 0;
        this.degradedComponents = null;
        this.logDirs = new ArrayList<Uuid>(0);
    }

    public short apiKey() {
        return 17;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 2;
    }

    public final void read(Readable _readable, short _version, MessageContext _context) {
        this.brokerId = _readable.readInt();
        this.brokerEpoch = _readable.readLong();
        this.fenced = 0;
        this.inControlledShutdown = 0;
        this.degradedComponents = null;
        this.logDirs = new ArrayList<Uuid>(0);
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        block6: for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                case 0: {
                    this.fenced = _readable.readByte();
                    continue block6;
                }
                case 1: {
                    if (_version >= 1) {
                        this.inControlledShutdown = _readable.readByte();
                        continue block6;
                    }
                    throw new RuntimeException("Tag 1 is not valid for version " + _version);
                }
                case 10000: {
                    int i;
                    ArrayList<DegradedComponent> newCollection;
                    int arrayLength;
                    if (_version >= 1) {
                        arrayLength = _readable.readUnsignedVarint() - 1;
                        if (arrayLength < 0) {
                            this.degradedComponents = null;
                            continue block6;
                        }
                        if (arrayLength > _readable.remaining()) {
                            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                        }
                        newCollection = new ArrayList<DegradedComponent>(arrayLength);
                        for (i = 0; i < arrayLength; ++i) {
                            newCollection.add(new DegradedComponent(_readable, _version, _context));
                        }
                        this.degradedComponents = newCollection;
                        continue block6;
                    }
                    throw new RuntimeException("Tag 10000 is not valid for version " + _version);
                }
                case 2: {
                    int i;
                    ArrayList<DegradedComponent> newCollection;
                    int arrayLength;
                    if (_version >= 2) {
                        arrayLength = _readable.readUnsignedVarint() - 1;
                        if (arrayLength < 0) {
                            throw new RuntimeException("non-nullable field logDirs was serialized as null");
                        }
                        if (arrayLength > _readable.remaining()) {
                            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                        }
                        newCollection = new ArrayList(arrayLength);
                        for (i = 0; i < arrayLength; ++i) {
                            newCollection.add((DegradedComponent)_readable.readUuid());
                        }
                        this.logDirs = newCollection;
                        continue block6;
                    }
                    throw new RuntimeException("Tag 2 is not valid for version " + _version);
                }
                default: {
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.brokerId);
        _writable.writeLong(this.brokerEpoch);
        if (this.fenced != 0) {
            ++_numTaggedFields;
        }
        if (_version >= 1) {
            if (this.inControlledShutdown != 0) {
                ++_numTaggedFields;
            }
        } else if (this.inControlledShutdown != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default inControlledShutdown at version " + _version);
        }
        if (_version >= 1) {
            if (this.degradedComponents != null) {
                ++_numTaggedFields;
            }
        } else if (this.degradedComponents != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default degradedComponents at version " + _version);
        }
        if (_version >= 2) {
            if (!this.logDirs.isEmpty()) {
                ++_numTaggedFields;
            }
        } else if (!this.logDirs.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default logDirs at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        if (this.fenced != 0) {
            _writable.writeUnsignedVarint(0);
            _writable.writeUnsignedVarint(1);
            _writable.writeByte(this.fenced);
        }
        if (_version >= 1 && this.inControlledShutdown != 0) {
            _writable.writeUnsignedVarint(1);
            _writable.writeUnsignedVarint(1);
            _writable.writeByte(this.inControlledShutdown);
        }
        if (_version >= 2 && !this.logDirs.isEmpty()) {
            _writable.writeUnsignedVarint(2);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.logDirs).intValue());
            _writable.writeUnsignedVarint(this.logDirs.size() + 1);
            for (Uuid logDirsElement : this.logDirs) {
                _writable.writeUuid(logDirsElement);
            }
        }
        _rawWriter.writeRawTags(_writable, 10000);
        if (_version >= 1 && this.degradedComponents != null) {
            _writable.writeUnsignedVarint(10000);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.degradedComponents).intValue());
            _writable.writeUnsignedVarint(this.degradedComponents.size() + 1);
            for (DegradedComponent degradedComponentsElement : this.degradedComponents) {
                degradedComponentsElement.write(_writable, _cache, _version, _context);
            }
        }
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _arraySize;
        int _sizeBeforeArray;
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(8);
        if (this.fenced != 0) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(1);
        }
        if (_version >= 1 && this.inControlledShutdown != 0) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(1);
        }
        if (_version >= 1 && this.degradedComponents != null) {
            ++_numTaggedFields;
            _size.addBytes(2);
            _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.degradedComponents.size() + 1)));
            for (DegradedComponent degradedComponentsElement : this.degradedComponents) {
                degradedComponentsElement.addSize(_size, _cache, _version, _context);
            }
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.degradedComponents, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (_version >= 2 && !this.logDirs.isEmpty()) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.logDirs.size() + 1)));
            _size.addBytes(this.logDirs.size() * 16);
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.logDirs, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BrokerRegistrationChangeRecord)) {
            return false;
        }
        BrokerRegistrationChangeRecord other = (BrokerRegistrationChangeRecord)obj;
        if (this.brokerId != other.brokerId) {
            return false;
        }
        if (this.brokerEpoch != other.brokerEpoch) {
            return false;
        }
        if (this.fenced != other.fenced) {
            return false;
        }
        if (this.inControlledShutdown != other.inControlledShutdown) {
            return false;
        }
        if (this.degradedComponents == null ? other.degradedComponents != null : !this.degradedComponents.equals(other.degradedComponents)) {
            return false;
        }
        if (this.logDirs == null ? other.logDirs != null : !this.logDirs.equals(other.logDirs)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.brokerId;
        hashCode = 31 * hashCode + ((int)(this.brokerEpoch >> 32) ^ (int)this.brokerEpoch);
        hashCode = 31 * hashCode + this.fenced;
        hashCode = 31 * hashCode + this.inControlledShutdown;
        hashCode = 31 * hashCode + (this.degradedComponents == null ? 0 : this.degradedComponents.hashCode());
        hashCode = 31 * hashCode + (this.logDirs == null ? 0 : this.logDirs.hashCode());
        return hashCode;
    }

    public BrokerRegistrationChangeRecord duplicate() {
        BrokerRegistrationChangeRecord _duplicate = new BrokerRegistrationChangeRecord();
        _duplicate.brokerId = this.brokerId;
        _duplicate.brokerEpoch = this.brokerEpoch;
        _duplicate.fenced = this.fenced;
        _duplicate.inControlledShutdown = this.inControlledShutdown;
        if (this.degradedComponents == null) {
            _duplicate.degradedComponents = null;
        } else {
            ArrayList<DegradedComponent> newDegradedComponents = new ArrayList<DegradedComponent>(this.degradedComponents.size());
            for (DegradedComponent degradedComponent : this.degradedComponents) {
                newDegradedComponents.add(degradedComponent.duplicate());
            }
            _duplicate.degradedComponents = newDegradedComponents;
        }
        ArrayList<Uuid> newLogDirs = new ArrayList<Uuid>(this.logDirs.size());
        for (Uuid uuid : this.logDirs) {
            newLogDirs.add(uuid);
        }
        _duplicate.logDirs = newLogDirs;
        return _duplicate;
    }

    public String toString() {
        return "BrokerRegistrationChangeRecord(brokerId=" + this.brokerId + ", brokerEpoch=" + this.brokerEpoch + ", fenced=" + this.fenced + ", inControlledShutdown=" + this.inControlledShutdown + ", degradedComponents=" + (this.degradedComponents == null ? "null" : MessageUtil.deepToString(this.degradedComponents.iterator())) + ", logDirs=" + MessageUtil.deepToString(this.logDirs.iterator()) + ")";
    }

    public int brokerId() {
        return this.brokerId;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    public byte fenced() {
        return this.fenced;
    }

    public byte inControlledShutdown() {
        return this.inControlledShutdown;
    }

    public List<DegradedComponent> degradedComponents() {
        return this.degradedComponents;
    }

    public List<Uuid> logDirs() {
        return this.logDirs;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public BrokerRegistrationChangeRecord setBrokerId(int v) {
        this.brokerId = v;
        return this;
    }

    public BrokerRegistrationChangeRecord setBrokerEpoch(long v) {
        this.brokerEpoch = v;
        return this;
    }

    public BrokerRegistrationChangeRecord setFenced(byte v) {
        this.fenced = v;
        return this;
    }

    public BrokerRegistrationChangeRecord setInControlledShutdown(byte v) {
        this.inControlledShutdown = v;
        return this;
    }

    public BrokerRegistrationChangeRecord setDegradedComponents(List<DegradedComponent> v) {
        this.degradedComponents = v;
        return this;
    }

    public BrokerRegistrationChangeRecord setLogDirs(List<Uuid> v) {
        this.logDirs = v;
        return this;
    }

    public static class DegradedComponent
    implements Message {
        String reason;
        byte componentCode;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 1;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public DegradedComponent(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public DegradedComponent() {
            this.reason = "";
            this.componentCode = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 2;
        }

        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DegradedComponent");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field reason was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field reason had invalid length " + length);
            }
            this.reason = _readable.readString(length);
            this.componentCode = _readable.readByte();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DegradedComponent");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.reason);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeByte(this.componentCode);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DegradedComponent");
            }
            byte[] _stringBytes = this.reason.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'reason' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.reason, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _size.addBytes(1);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DegradedComponent)) {
                return false;
            }
            DegradedComponent other = (DegradedComponent)obj;
            if (this.reason == null ? other.reason != null : !this.reason.equals(other.reason)) {
                return false;
            }
            if (this.componentCode != other.componentCode) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.reason == null ? 0 : this.reason.hashCode());
            hashCode = 31 * hashCode + this.componentCode;
            return hashCode;
        }

        public DegradedComponent duplicate() {
            DegradedComponent _duplicate = new DegradedComponent();
            _duplicate.reason = this.reason;
            _duplicate.componentCode = this.componentCode;
            return _duplicate;
        }

        public String toString() {
            return "DegradedComponent(reason=" + (String)(this.reason == null ? "null" : "'" + this.reason.toString() + "'") + ", componentCode=" + this.componentCode + ")";
        }

        public String reason() {
            return this.reason;
        }

        public byte componentCode() {
            return this.componentCode;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DegradedComponent setReason(String v) {
            this.reason = v;
            return this;
        }

        public DegradedComponent setComponentCode(byte v) {
            this.componentCode = v;
            return this;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = new Schema(new Field[]{new Field("reason", (Type)Type.COMPACT_STRING, "A unique tag representing why a broker's state is degraded."), new Field("component_code", (Type)Type.INT8, "Which component of the broker is degraded due to the provided reason (UNSPECIFIED=0, STORAGE=1, NETWORK=2, EXTERNAL_CONNECTIVITY_STARTUP=3)."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{null, SCHEMA_1, SCHEMA_2};
        }
    }
}

