/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.server.fault.FaultHandler;

public class ConfluentControllerMetricsUtils {
    static boolean partitionHasImbalancedLeader(PartitionRegistration partition) {
        if (partition.leader < 0) {
            return false;
        }
        if (partition.replicas.length == 0) {
            return false;
        }
        int preferredLeader = partition.replicas[0];
        return partition.leader != preferredLeader;
    }

    static boolean partitionHasOfflineLeader(PartitionRegistration partition) {
        return partition.leader < 0;
    }

    static void withParsedUnderMinIsrConfig(Optional<String> input, FaultHandler faultHandler, Consumer<OptionalInt> callback) {
        int parsedUnderMinIsr;
        if (!input.isPresent()) {
            callback.accept(OptionalInt.empty());
            return;
        }
        try {
            parsedUnderMinIsr = Integer.parseInt(input.get());
        }
        catch (NumberFormatException e) {
            faultHandler.handleFault("Error parsing " + ServerLogConfigs.MIN_IN_SYNC_REPLICAS_CONFIG + " configuration of " + input.get() + ": " + e.getMessage());
            return;
        }
        callback.accept(OptionalInt.of(parsedUnderMinIsr));
    }
}

