/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.Collection;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.image.node.TopicImageNode;
import org.apache.kafka.server.immutable.ImmutableSet;

public class TopicsImageByTenantNameNode
implements MetadataNode {
    private final TopicsImage image;
    private final ImmutableSet<String> tenantTopics;

    public TopicsImageByTenantNameNode(TopicsImage image, ImmutableSet<String> tenantTopics) {
        this.image = image;
        this.tenantTopics = tenantTopics;
    }

    @Override
    public Collection<String> childNames() {
        return this.tenantTopics;
    }

    @Override
    public MetadataNode child(String name) {
        if (!this.tenantTopics.contains((Object)name)) {
            return null;
        }
        TopicImage topicImage = (TopicImage)this.image.topicsByName().get((Object)name);
        if (topicImage == null) {
            return null;
        }
        return new TopicImageNode(topicImage);
    }
}

