/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.DegradedBrokerComponent;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;

public class DegradedBrokerHealthState
implements Comparable<DegradedBrokerHealthState> {
    private final String reason;
    private final BrokerComponent component;

    public DegradedBrokerHealthState(String reason, BrokerComponent component) {
        this.reason = reason;
        this.component = component;
    }

    public static List<RegisterBrokerRecord.DegradedComponent> toRegisterBrokerRecordDegradedComponent(Set<DegradedBrokerHealthState> degradedHealthStates) {
        return degradedHealthStates.stream().map(state -> new RegisterBrokerRecord.DegradedComponent().setReason(state.reason()).setComponentCode(state.component().id())).collect(Collectors.toList());
    }

    public static Set<DegradedBrokerHealthState> fromRegisterBrokerRecord(List<RegisterBrokerRecord.DegradedComponent> degradedComponents) {
        return degradedComponents.stream().map(DegradedBrokerHealthState::fromDegradedComponent).collect(Collectors.toSet());
    }

    public static Set<DegradedBrokerHealthState> fromBrokerRegistrationChangeRecord(List<BrokerRegistrationChangeRecord.DegradedComponent> degradedComponents) {
        return degradedComponents.stream().map(DegradedBrokerHealthState::fromDegradedComponent).collect(Collectors.toSet());
    }

    public static DegradedBrokerHealthState fromDegradedComponent(RegisterBrokerRecord.DegradedComponent degradedComponent) {
        return new DegradedBrokerHealthState(degradedComponent.reason(), BrokerComponent.forId((byte)degradedComponent.componentCode()));
    }

    public static DegradedBrokerHealthState fromDegradedComponent(BrokerRegistrationChangeRecord.DegradedComponent degradedComponent) {
        return new DegradedBrokerHealthState(degradedComponent.reason(), BrokerComponent.forId((byte)degradedComponent.componentCode()));
    }

    public static DegradedBrokerComponent toDegradedBrokerComponent(DegradedBrokerHealthState degradedBrokerHealthState) {
        return new DegradedBrokerComponent(degradedBrokerHealthState.reason(), degradedBrokerHealthState.component().id());
    }

    public static Set<DegradedBrokerComponent> toDegradedBrokerComponents(Set<DegradedBrokerHealthState> degradedBrokerComponents) {
        return degradedBrokerComponents.stream().map(DegradedBrokerHealthState::toDegradedBrokerComponent).collect(Collectors.toSet());
    }

    public static boolean containsDesiredDegradedComponent(Set<DegradedBrokerHealthState> degradedComponents, BrokerComponent desiredComponent) {
        for (DegradedBrokerHealthState degradedComponent : degradedComponents) {
            if (degradedComponent.component() != desiredComponent) continue;
            return true;
        }
        return false;
    }

    public String reason() {
        return this.reason;
    }

    public BrokerComponent component() {
        return this.component;
    }

    public String toString() {
        return "DegradedBrokerHealthState(reason=" + this.reason + ", component=" + String.valueOf(this.component) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DegradedBrokerHealthState that = (DegradedBrokerHealthState)o;
        return this.reason.equals(that.reason) && this.component == that.component;
    }

    public int hashCode() {
        return Objects.hash(this.reason, this.component);
    }

    @Override
    public int compareTo(DegradedBrokerHealthState other) {
        if (this.component.ordinal() < other.component.ordinal()) {
            return -1;
        }
        if (this.component.ordinal() > other.component.ordinal()) {
            return 1;
        }
        return this.reason.compareTo(other.reason);
    }
}

