/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.slf4j.Logger;

public interface MatchingRule {
    public AuthorizationResult result();

    default public void logAuditMessage(Logger auditLog, KafkaPrincipal principal, AuthorizableRequestContext requestContext, Action action) {
        switch (this.result()) {
            case ALLOWED: {
                if (action.logIfAllowed() && auditLog.isDebugEnabled()) {
                    auditLog.debug(this.buildAuditMessage(principal, requestContext, action));
                    break;
                }
                if (!auditLog.isTraceEnabled()) break;
                auditLog.trace(this.buildAuditMessage(principal, requestContext, action));
                break;
            }
            case DENIED: {
                if (action.logIfDenied()) {
                    auditLog.info(this.buildAuditMessage(principal, requestContext, action));
                    break;
                }
                if (!auditLog.isTraceEnabled()) break;
                auditLog.trace(this.buildAuditMessage(principal, requestContext, action));
            }
        }
    }

    default public String buildAuditMessage(KafkaPrincipal principal, AuthorizableRequestContext context, Action action) {
        StringBuilder bldr = new StringBuilder();
        bldr.append("Principal = ").append(principal);
        bldr.append(" is ").append(this.result() == AuthorizationResult.ALLOWED ? "Allowed" : "Denied");
        bldr.append(" operation = ").append(action.operation());
        bldr.append(" from host = ").append(context.clientAddress().getHostAddress());
        bldr.append(" on resource = ");
        MatchingRule.appendResourcePattern(action.resourcePattern(), bldr);
        bldr.append(" for request = ").append(ApiKeys.forId((int)context.requestType()).name);
        bldr.append(" with resourceRefCount = ").append(action.resourceReferenceCount());
        bldr.append(" based on rule ").append(this);
        return bldr.toString();
    }

    public static void appendResourcePattern(ResourcePattern resourcePattern, StringBuilder bldr) {
        bldr.append(SecurityUtils.resourceTypeName((ResourceType)resourcePattern.resourceType())).append(":").append(resourcePattern.patternType()).append(":").append(resourcePattern.name());
    }
}

