/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.ClearElrRecord;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.ConfigurationValidator;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.EncryptionControlManager;
import org.apache.kafka.controller.FeatureControlManager;
import org.apache.kafka.controller.ResultOrError;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.TopicPlacement;
import org.apache.kafka.metadata.config.ConfigurationListener;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.mutable.BoundedList;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.apache.kafka.timeline.TimelineHashSet;
import org.slf4j.Logger;

public class ConfigurationControlManager {
    public static final ConfigResource DEFAULT_NODE = new ConfigResource(ConfigResource.Type.BROKER, "");
    private final Logger log;
    private final SnapshotRegistry snapshotRegistry;
    private final KafkaConfigSchema configSchema;
    private final Consumer<ConfigResource> existenceChecker;
    private final Optional<AlterConfigPolicy> alterConfigPolicy;
    private final ConfigurationValidator validator;
    private final TimelineHashMap<ConfigResource, TimelineHashMap<String, String>> configData;
    private final TimelineHashSet<Integer> brokersWithConfigs;
    private final Map<String, Object> staticConfig;
    private final ConfigResource currentController;
    private final EncryptionControlManager encryptionControl;
    private final Supplier<Iterator<UsableBroker>> usableBrokers;
    private final Supplier<Boolean> isTopicPlacementSupported;
    private final ConfigurationListener configurationListener;
    private final FeatureControlManager featureControl;
    private static final ApiError DISALLOWED_BROKER_MIN_ISR_TRANSITION_ERROR = new ApiError(Errors.INVALID_CONFIG, "Broker-level min.insync.replicas cannot be altered while ELR is enabled.");
    private static final ApiError DISALLOWED_CLUSTER_MIN_ISR_REMOVAL_ERROR = new ApiError(Errors.INVALID_CONFIG, "Cluster-level min.insync.replicas cannot be removed while ELR is enabled.");
    private static final ApiError DISALLOWED_CONFIG_VALUE_SIZE_ERROR = new ApiError(Errors.INVALID_CONFIG, "The configuration value cannot be added because it exceeds the maximum value size of 32767 bytes.");

    private ConfigurationControlManager(LogContext logContext, SnapshotRegistry snapshotRegistry, KafkaConfigSchema configSchema, Consumer<ConfigResource> existenceChecker, Optional<AlterConfigPolicy> alterConfigPolicy, ConfigurationValidator validator, Map<String, Object> staticConfig, int nodeId, EncryptionControlManager encryptionControl, Supplier<Iterator<UsableBroker>> usableBrokers, Supplier<Boolean> isTopicPlacementSupported, ConfigurationListener configurationListener, FeatureControlManager featureControl) {
        this.log = logContext.logger(ConfigurationControlManager.class);
        this.snapshotRegistry = snapshotRegistry;
        this.configSchema = configSchema;
        this.existenceChecker = existenceChecker;
        this.alterConfigPolicy = alterConfigPolicy;
        this.validator = validator;
        this.configData = new TimelineHashMap(snapshotRegistry, 0);
        this.staticConfig = Map.copyOf(staticConfig);
        this.encryptionControl = encryptionControl;
        this.usableBrokers = usableBrokers;
        this.isTopicPlacementSupported = isTopicPlacementSupported;
        this.configurationListener = configurationListener;
        this.brokersWithConfigs = new TimelineHashSet(snapshotRegistry, 0);
        this.currentController = new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(nodeId));
        this.featureControl = featureControl;
    }

    KafkaConfigSchema configSchema() {
        return this.configSchema;
    }

    SnapshotRegistry snapshotRegistry() {
        return this.snapshotRegistry;
    }

    EncryptionControlManager encryptionControl() {
        return this.encryptionControl;
    }

    ControllerResult<Map<ConfigResource, ApiError>> incrementalAlterConfigs(Map<ConfigResource, Map<String, Map.Entry<AlterConfigOp.OpType, String>>> configChanges, boolean newlyCreatedResource, KafkaPrincipal principal) {
        BoundedList outputRecords = BoundedList.newArrayBacked((int)10000);
        HashMap<ConfigResource, ApiError> outputResults = new HashMap<ConfigResource, ApiError>();
        for (Map.Entry<ConfigResource, Map<String, Map.Entry<AlterConfigOp.OpType, String>>> resourceEntry : configChanges.entrySet()) {
            ApiError apiError = this.incrementalAlterConfigResource(resourceEntry.getKey(), resourceEntry.getValue(), newlyCreatedResource, (List<ApiMessageAndVersion>)outputRecords, principal);
            outputResults.put(resourceEntry.getKey(), apiError);
        }
        outputRecords.addAll(this.createClearElrRecordsAsNeeded((List<ApiMessageAndVersion>)outputRecords));
        return ControllerResult.atomicOf((List<ApiMessageAndVersion>)outputRecords, outputResults);
    }

    List<ApiMessageAndVersion> createClearElrRecordsAsNeeded(List<ApiMessageAndVersion> input) {
        if (!this.featureControl.isElrFeatureEnabled()) {
            return List.of();
        }
        ArrayList<ApiMessageAndVersion> output = new ArrayList<ApiMessageAndVersion>();
        for (ApiMessageAndVersion messageAndVersion : input) {
            ConfigRecord record;
            if (messageAndVersion.message().apiKey() != MetadataRecordType.CONFIG_RECORD.id() || !(record = (ConfigRecord)messageAndVersion.message()).name().equals("min.insync.replicas")) continue;
            if (ConfigResource.Type.forId((byte)record.resourceType()) == ConfigResource.Type.TOPIC) {
                output.add(new ApiMessageAndVersion((ApiMessage)new ClearElrRecord().setTopicName(record.resourceName()), 0));
                continue;
            }
            output.add(new ApiMessageAndVersion((ApiMessage)new ClearElrRecord(), 0));
        }
        return output;
    }

    ControllerResult<ApiError> incrementalAlterConfig(ConfigResource configResource, Map<String, Map.Entry<AlterConfigOp.OpType, String>> keyToOps, boolean newlyCreatedResource, KafkaPrincipal principal) {
        BoundedList outputRecords = BoundedList.newArrayBacked((int)10000);
        ApiError apiError = this.incrementalAlterConfigResource(configResource, keyToOps, newlyCreatedResource, (List<ApiMessageAndVersion>)outputRecords, principal);
        outputRecords.addAll(this.createClearElrRecordsAsNeeded((List<ApiMessageAndVersion>)outputRecords));
        return ControllerResult.atomicOf((List<ApiMessageAndVersion>)outputRecords, apiError);
    }

    private ApiError incrementalAlterConfigResource(ConfigResource configResource, Map<String, Map.Entry<AlterConfigOp.OpType, String>> keysToOps, boolean newlyCreatedResource, List<ApiMessageAndVersion> outputRecords, KafkaPrincipal principal) {
        ArrayList<ApiMessageAndVersion> newRecords = new ArrayList<ApiMessageAndVersion>();
        for (Map.Entry<String, Map.Entry<AlterConfigOp.OpType, String>> keysToOpsEntry : keysToOps.entrySet()) {
            String key = keysToOpsEntry.getKey();
            String currentValue = null;
            TimelineHashMap currentConfigs = (TimelineHashMap)this.configData.get((Object)configResource);
            if (currentConfigs != null) {
                currentValue = (String)currentConfigs.get((Object)key);
            }
            String newValue = currentValue;
            Map.Entry<AlterConfigOp.OpType, String> opTypeAndNewValue = keysToOpsEntry.getValue();
            AlterConfigOp.OpType opType = opTypeAndNewValue.getKey();
            String opValue = opTypeAndNewValue.getValue();
            switch (opType) {
                case SET: {
                    newValue = opValue;
                    break;
                }
                case DELETE: {
                    newValue = null;
                    break;
                }
                case APPEND: 
                case SUBTRACT: {
                    if (!this.configSchema.isSplittable(configResource.type(), key)) {
                        return new ApiError(Errors.INVALID_CONFIG, "Can't " + String.valueOf(opType) + " to key " + key + " because its type is not LIST.");
                    }
                    List<String> oldValueList = this.getParts(newValue, key, configResource);
                    if (opType == AlterConfigOp.OpType.APPEND) {
                        for (String value : opValue.split(",")) {
                            if (oldValueList.contains(value)) continue;
                            oldValueList.add(value);
                        }
                    } else {
                        for (String value : opValue.split(",")) {
                            oldValueList.remove(value);
                        }
                    }
                    newValue = String.join((CharSequence)",", oldValueList);
                }
            }
            if (Objects.equals(currentValue, newValue) && !configResource.type().equals((Object)ConfigResource.Type.BROKER)) continue;
            newRecords.add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(configResource.type().id()).setResourceName(configResource.name()).setName(key).setValue(newValue), 0));
        }
        ApiError error = this.validateAlterConfig(configResource, newRecords, List.of(), newlyCreatedResource, principal);
        if (error.isFailure()) {
            return error;
        }
        this.addOutputRecordsWithEncryptionIfNeeded(this.encryptionControl.encryptor(), outputRecords, newRecords);
        return ApiError.NONE;
    }

    private void addOutputRecordsWithEncryptionIfNeeded(MetadataEncryptor encryptor, List<ApiMessageAndVersion> outputRecords, List<ApiMessageAndVersion> newRecords) {
        for (ApiMessageAndVersion messageAndVersion : newRecords) {
            ConfigRecord record = (ConfigRecord)messageAndVersion.message();
            ConfigResource.Type type = ConfigResource.Type.forId((byte)record.resourceType());
            if (this.configSchema.isSensitive(type, record.name())) {
                outputRecords.add(encryptor.encrypt(messageAndVersion));
                continue;
            }
            outputRecords.add(messageAndVersion);
        }
    }

    private ApiError validateAlterConfig(ConfigResource configResource, List<ApiMessageAndVersion> recordsExplicitlyAltered, List<ApiMessageAndVersion> recordsImplicitlyDeleted, boolean newlyCreatedResource, KafkaPrincipal principal) {
        ConfigRecord configRecord;
        HashMap<String, String> allConfigs = new HashMap<String, String>();
        HashMap<String, String> existingConfigsMap = new HashMap<String, String>();
        HashMap<String, String> alteredConfigsForAlterConfigPolicyCheck = new HashMap<String, String>();
        TimelineHashMap existingConfigsSnapshot = (TimelineHashMap)this.configData.get((Object)configResource);
        if (existingConfigsSnapshot != null) {
            allConfigs.putAll((Map<String, String>)existingConfigsSnapshot);
            existingConfigsMap.putAll((Map<String, String>)existingConfigsSnapshot);
        }
        for (ApiMessageAndVersion newRecord : recordsExplicitlyAltered) {
            configRecord = (ConfigRecord)newRecord.message();
            if (this.isDisallowedBrokerMinIsrTransition(configRecord)) {
                return DISALLOWED_BROKER_MIN_ISR_TRANSITION_ERROR;
            }
            if (this.isDisallowedClusterMinIsrTransition(configRecord)) {
                return DISALLOWED_CLUSTER_MIN_ISR_REMOVAL_ERROR;
            }
            if (configRecord.value() == null) {
                allConfigs.remove(configRecord.name());
            } else {
                if (configRecord.value().length() > Short.MAX_VALUE) {
                    return DISALLOWED_CONFIG_VALUE_SIZE_ERROR;
                }
                allConfigs.put(configRecord.name(), configRecord.value());
            }
            alteredConfigsForAlterConfigPolicyCheck.put(configRecord.name(), configRecord.value());
        }
        for (ApiMessageAndVersion recordImplicitlyDeleted : recordsImplicitlyDeleted) {
            configRecord = (ConfigRecord)recordImplicitlyDeleted.message();
            if (this.isDisallowedBrokerMinIsrTransition(configRecord)) {
                return DISALLOWED_BROKER_MIN_ISR_TRANSITION_ERROR;
            }
            if (this.isDisallowedClusterMinIsrTransition(configRecord)) {
                return DISALLOWED_CLUSTER_MIN_ISR_REMOVAL_ERROR;
            }
            allConfigs.remove(configRecord.name());
        }
        try {
            this.validator.validate(configResource, allConfigs, existingConfigsMap);
            if (!newlyCreatedResource) {
                this.existenceChecker.accept(configResource);
                if (configResource.type().equals((Object)ConfigResource.Type.TOPIC)) {
                    this.validateTopicConfigChange(configResource, allConfigs);
                }
            }
            if (!(!this.alterConfigPolicy.isPresent() || configResource.type().equals((Object)ConfigResource.Type.CLUSTER_LINK) && newlyCreatedResource)) {
                this.alterConfigPolicy.get().validate(new AlterConfigPolicy.RequestMetadata(configResource, alteredConfigsForAlterConfigPolicyCheck, principal));
            }
        }
        catch (ConfigException e) {
            return new ApiError(Errors.INVALID_CONFIG, e.getMessage());
        }
        catch (Throwable e) {
            ApiError apiError = ApiError.fromThrowable((Throwable)e);
            if (apiError.error() == Errors.UNKNOWN_SERVER_ERROR) {
                this.log.error("Unknown server error validating Alter Configs", e);
            }
            return apiError;
        }
        return ApiError.NONE;
    }

    private void validateTopicConfigChange(ConfigResource configResource, Map<String, String> newConfigs) {
        Map topicConfigs = (Map)this.configData.get((Object)configResource);
        if (topicConfigs == null) {
            topicConfigs = Map.of();
        }
        Map<String, String> prevResolvedConfig = this.configSchema.resolveEffectiveTopicConfigsToStrings(this.staticConfig, this.clusterConfig(), this.currentControllerConfig(), topicConfigs);
        Map<String, String> newResolvedConfig = this.configSchema.resolveEffectiveTopicConfigsToStrings(this.staticConfig, this.clusterConfig(), this.currentControllerConfig(), newConfigs);
        this.validator.validateTopicConfigChange(prevResolvedConfig, newResolvedConfig, this.usableBrokers.get(), this.isTopicPlacementSupported.get());
    }

    boolean isDisallowedBrokerMinIsrTransition(ConfigRecord configRecord) {
        return configRecord.name().equals("min.insync.replicas") && configRecord.resourceType() == ConfigResource.Type.BROKER.id() && !configRecord.resourceName().isEmpty() && this.featureControl.isElrFeatureEnabled();
    }

    boolean isDisallowedClusterMinIsrTransition(ConfigRecord configRecord) {
        return configRecord.name().equals("min.insync.replicas") && configRecord.resourceType() == ConfigResource.Type.BROKER.id() && configRecord.resourceName().isEmpty() && configRecord.value() == null && this.featureControl.isElrFeatureEnabled();
    }

    ControllerResult<Map<ConfigResource, ApiError>> legacyAlterConfigs(Map<ConfigResource, Map<String, String>> newConfigs, boolean newlyCreatedResource) {
        return this.legacyAlterConfigs(newConfigs, newlyCreatedResource, null);
    }

    ControllerResult<Map<ConfigResource, ApiError>> legacyAlterConfigs(Map<ConfigResource, Map<String, String>> newConfigs, boolean newlyCreatedResource, KafkaPrincipal principal) {
        BoundedList outputRecords = BoundedList.newArrayBacked((int)10000);
        HashMap<ConfigResource, ApiError> outputResults = new HashMap<ConfigResource, ApiError>();
        for (Map.Entry<ConfigResource, Map<String, String>> resourceEntry : newConfigs.entrySet()) {
            this.legacyAlterConfigResource(resourceEntry.getKey(), resourceEntry.getValue(), newlyCreatedResource, (List<ApiMessageAndVersion>)outputRecords, outputResults, principal);
        }
        outputRecords.addAll(this.createClearElrRecordsAsNeeded((List<ApiMessageAndVersion>)outputRecords));
        return ControllerResult.atomicOf((List<ApiMessageAndVersion>)outputRecords, outputResults);
    }

    private void legacyAlterConfigResource(ConfigResource configResource, Map<String, String> newConfigs, boolean newlyCreatedResource, List<ApiMessageAndVersion> outputRecords, Map<ConfigResource, ApiError> outputResults, KafkaPrincipal principal) {
        ArrayList<ApiMessageAndVersion> recordsExplicitlyAltered = new ArrayList<ApiMessageAndVersion>();
        Map currentConfigs = (Map)this.configData.get((Object)configResource);
        if (currentConfigs == null) {
            currentConfigs = Map.of();
        }
        for (Map.Entry<String, String> entry : newConfigs.entrySet()) {
            String key = entry.getKey();
            String newValue = entry.getValue();
            String currentValue = (String)currentConfigs.get(key);
            if (Objects.equals(currentValue, newValue) && !configResource.type().equals((Object)ConfigResource.Type.BROKER)) continue;
            recordsExplicitlyAltered.add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(configResource.type().id()).setResourceName(configResource.name()).setName(key).setValue(newValue), 0));
        }
        ArrayList<ApiMessageAndVersion> recordsImplicitlyDeleted = new ArrayList<ApiMessageAndVersion>();
        for (String key : currentConfigs.keySet()) {
            if (newConfigs.containsKey(key)) continue;
            recordsImplicitlyDeleted.add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(configResource.type().id()).setResourceName(configResource.name()).setName(key).setValue(null), 0));
        }
        ApiError apiError = this.validateAlterConfig(configResource, recordsExplicitlyAltered, recordsImplicitlyDeleted, newlyCreatedResource, principal);
        if (apiError.isFailure()) {
            outputResults.put(configResource, apiError);
            return;
        }
        MetadataEncryptor encryptor = this.encryptionControl.encryptor();
        this.addOutputRecordsWithEncryptionIfNeeded(encryptor, outputRecords, recordsExplicitlyAltered);
        this.addOutputRecordsWithEncryptionIfNeeded(encryptor, outputRecords, recordsImplicitlyDeleted);
        outputResults.put(configResource, ApiError.NONE);
    }

    private List<String> getParts(String value, String key, ConfigResource configResource) {
        String[] splitValues;
        if (value == null) {
            value = this.configSchema.getDefault(configResource.type(), key);
        }
        ArrayList<String> parts = new ArrayList<String>();
        if (value == null) {
            return parts;
        }
        for (String splitValue : splitValues = value.split(",")) {
            if (splitValue.isEmpty()) continue;
            parts.add(splitValue);
        }
        return parts;
    }

    public void replay(ConfigRecord record) {
        ConfigResource.Type type = ConfigResource.Type.forId((byte)record.resourceType());
        ConfigResource configResource = new ConfigResource(type, record.resourceName());
        TimelineHashMap configs = (TimelineHashMap)this.configData.get((Object)configResource);
        if (configs == null) {
            configs = new TimelineHashMap(this.snapshotRegistry, 0);
            this.configData.put((Object)configResource, (Object)configs);
            if (configResource.type().equals((Object)ConfigResource.Type.BROKER) && !configResource.name().isEmpty()) {
                this.brokersWithConfigs.add((Object)Integer.parseInt(configResource.name()));
            }
        }
        if (record.value() == null) {
            configs.remove((Object)record.name());
        } else {
            configs.put((Object)record.name(), (Object)record.value());
        }
        if (configs.isEmpty()) {
            this.configData.remove((Object)configResource);
            if (configResource.type().equals((Object)ConfigResource.Type.BROKER) && !configResource.name().isEmpty()) {
                this.brokersWithConfigs.remove((Object)Integer.parseInt(configResource.name()));
            }
        }
        this.configurationListener.update(configResource, record.name(), record.value());
        if (this.configSchema.isSensitive(record)) {
            this.log.info("Replayed ConfigRecord for {} which set configuration {} to {}", new Object[]{configResource, record.name(), "[hidden]"});
        } else {
            this.log.info("Replayed ConfigRecord for {} which set configuration {} to {}", new Object[]{configResource, record.name(), record.value()});
        }
    }

    public Map<String, String> getConfig(ConfigRecord record) {
        ConfigResource.Type type = ConfigResource.Type.forId((byte)record.resourceType());
        ConfigResource configResource = new ConfigResource(type, record.resourceName());
        return this.getConfigs(configResource);
    }

    Map<String, String> getConfigs(ConfigResource configResource) {
        Map map = (Map)this.configData.get((Object)configResource);
        if (map == null) {
            return Map.of();
        }
        return Map.copyOf(map);
    }

    ConfigEntry getTopicConfig(String topicName, String configKey) throws NoSuchElementException {
        ConfigEntry result = this.configSchema.resolveEffectiveTopicConfig(configKey, this.staticConfig, this.clusterConfig(), this.currentControllerConfig(), this.currentTopicConfig(topicName));
        return result;
    }

    public Map<ConfigResource, ResultOrError<Map<String, String>>> describeConfigs(long lastCommittedOffset, Map<ConfigResource, Collection<String>> resources) {
        HashMap<ConfigResource, ResultOrError<Map<String, String>>> results = new HashMap<ConfigResource, ResultOrError<Map<String, String>>>();
        for (Map.Entry<ConfigResource, Collection<String>> resourceEntry : resources.entrySet()) {
            ConfigResource resource = resourceEntry.getKey();
            try {
                this.validator.validate(resource);
            }
            catch (Throwable e) {
                results.put(resource, new ResultOrError(ApiError.fromThrowable((Throwable)e)));
                continue;
            }
            HashMap<String, String> foundConfigs = new HashMap<String, String>();
            TimelineHashMap configs = (TimelineHashMap)this.configData.get((Object)resource, lastCommittedOffset);
            if (configs != null) {
                Collection<String> targetConfigs = resourceEntry.getValue();
                if (targetConfigs.isEmpty()) {
                    for (Map.Entry entry : configs.entrySet(lastCommittedOffset)) {
                        foundConfigs.put((String)entry.getKey(), (String)entry.getValue());
                    }
                } else {
                    for (String key : targetConfigs) {
                        String value = (String)configs.get((Object)key, lastCommittedOffset);
                        if (value == null) continue;
                        foundConfigs.put(key, value);
                    }
                }
            }
            results.put(resource, new ResultOrError(foundConfigs));
        }
        return results;
    }

    Map<String, String> getTopicConfigs(String topicName) {
        Map configs = (Map)this.configData.get((Object)new ConfigResource(ConfigResource.Type.TOPIC, topicName));
        if (configs == null) {
            return Map.of();
        }
        return new HashMap<String, String>(configs);
    }

    public String getEffectiveTopicConfigValue(String configKey, String topicName) {
        Map<String, ConfigEntry> entries = this.configSchema.resolveEffectiveTopicConfigs(this.staticConfig, this.clusterConfig(), this.currentControllerConfig(), this.getTopicConfigs(topicName));
        ConfigEntry entry = entries.get(configKey);
        return entry != null ? entry.value() : null;
    }

    void deleteTopicConfigs(String name) {
        this.configData.remove((Object)new ConfigResource(ConfigResource.Type.TOPIC, name));
    }

    void deleteClusterLinkConfigs(String linkName) {
        this.configData.remove((Object)new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkName));
    }

    Optional<TopicPlacement> topicPlacementConfig(String topicName) {
        Map<String, String> topicConfigs = this.getTopicConfigs(topicName);
        String topicPlacementStr = topicConfigs.get("confluent.placement.constraints");
        try {
            return TopicPlacement.parse((String)topicPlacementStr);
        }
        catch (IllegalArgumentException e) {
            this.log.error("Failed to parse topic placement {} for topic {}.", new Object[]{topicPlacementStr, topicName, e});
            throw e;
        }
    }

    int getStaticallyConfiguredMinInsyncReplicas() {
        return this.configSchema.getStaticallyConfiguredMinInsyncReplicas(this.staticConfig);
    }

    String maybeGenerateElrSafetyRecords(List<ApiMessageAndVersion> outputRecords) {
        StringBuilder bld = new StringBuilder();
        Object prefix = "";
        if (!this.clusterConfig().containsKey("min.insync.replicas")) {
            int minInsyncReplicas = this.configSchema.getStaticallyConfiguredMinInsyncReplicas(this.staticConfig);
            outputRecords.add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("").setName("min.insync.replicas").setValue(Integer.toString(minInsyncReplicas)), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion()));
            bld.append("Generating cluster-level ").append("min.insync.replicas").append(" of ").append(minInsyncReplicas);
            prefix = ". ";
        }
        prefix = (String)prefix + "Removing broker-level min.insync.replicas for brokers: ";
        for (Integer brokerId : this.brokersWithConfigs) {
            ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, brokerId.toString());
            Map configs = (Map)this.configData.get((Object)configResource);
            if (!configs.containsKey("min.insync.replicas")) continue;
            outputRecords.add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName(configResource.name()).setName("min.insync.replicas").setValue(null), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion()));
            bld.append((String)prefix).append(brokerId);
            prefix = ", ";
        }
        if (bld.isEmpty()) {
            return "";
        }
        bld.append(".");
        return bld.toString();
    }

    ControllerResult<ApiError> updateFeatures(Map<String, Short> updates, Map<String, FeatureUpdate.UpgradeType> upgradeTypes, boolean validateOnly, int currentClaimEpoch) {
        ControllerResult<ApiError> result = this.featureControl.updateFeatures(updates, upgradeTypes, validateOnly, currentClaimEpoch);
        if (result.response().isSuccess() && !validateOnly && updates.getOrDefault("eligible.leader.replicas.version", (short)0) > 0) {
            BoundedList records = BoundedList.newArrayBacked((int)10000);
            String logMessage = this.maybeGenerateElrSafetyRecords((List<ApiMessageAndVersion>)records);
            if (!logMessage.isEmpty()) {
                this.log.info("{}", (Object)logMessage);
            }
            records.addAll(result.records());
            return ControllerResult.atomicOf((List<ApiMessageAndVersion>)records, ApiError.NONE);
        }
        return result;
    }

    boolean uncleanLeaderElectionEnabledForTopic(String topicName) {
        String uncleanLeaderElection = this.getTopicConfig(topicName, "unclean.leader.election.enable").value();
        if (!uncleanLeaderElection.isEmpty()) {
            return Boolean.parseBoolean(uncleanLeaderElection);
        }
        return false;
    }

    Map<String, ConfigEntry> computeEffectiveTopicConfigs(Map<String, String> creationConfigs) {
        return this.configSchema.resolveEffectiveTopicConfigs(this.staticConfig, this.clusterConfig(), this.currentControllerConfig(), creationConfigs);
    }

    Map<String, String> clusterConfig() {
        Map result = (Map)this.configData.get((Object)DEFAULT_NODE);
        return result == null ? Map.of() : result;
    }

    Map<String, String> currentControllerConfig() {
        Map result = (Map)this.configData.get((Object)this.currentController);
        return result == null ? Map.of() : result;
    }

    Map<String, String> currentTopicConfig(String topicName) {
        Map result = (Map)this.configData.get((Object)new ConfigResource(ConfigResource.Type.TOPIC, topicName));
        return result == null ? Map.of() : result;
    }

    TimelineHashSet<Integer> brokersWithConfigs() {
        return this.brokersWithConfigs;
    }

    static class Builder {
        private LogContext logContext = null;
        private SnapshotRegistry snapshotRegistry = null;
        private KafkaConfigSchema configSchema = null;
        private Consumer<ConfigResource> existenceChecker = __ -> {};
        private Optional<AlterConfigPolicy> alterConfigPolicy = Optional.empty();
        private ConfigurationValidator validator = ConfigurationValidator.NO_OP;
        private Map<String, Object> staticConfig = Map.of();
        private int nodeId = 0;
        private EncryptionControlManager encryptionControl = null;
        private Supplier<Iterator<UsableBroker>> usableBrokers;
        private Supplier<Boolean> isTopicPlacementSupported;
        private ConfigurationListener configurationListener = (__, ___, ____) -> {};
        private FeatureControlManager featureControl = null;

        Builder() {
        }

        Builder setLogContext(LogContext logContext) {
            this.logContext = logContext;
            return this;
        }

        Builder setSnapshotRegistry(SnapshotRegistry snapshotRegistry) {
            this.snapshotRegistry = snapshotRegistry;
            return this;
        }

        Builder setKafkaConfigSchema(KafkaConfigSchema configSchema) {
            this.configSchema = configSchema;
            return this;
        }

        Builder setExistenceChecker(Consumer<ConfigResource> existenceChecker) {
            this.existenceChecker = existenceChecker;
            return this;
        }

        Builder setAlterConfigPolicy(Optional<AlterConfigPolicy> alterConfigPolicy) {
            this.alterConfigPolicy = alterConfigPolicy;
            return this;
        }

        Builder setValidator(ConfigurationValidator validator) {
            this.validator = validator;
            return this;
        }

        Builder setStaticConfig(Map<String, Object> staticConfig) {
            this.staticConfig = staticConfig;
            return this;
        }

        Builder setNodeId(int nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        Builder setEncryptionControlManager(EncryptionControlManager encryptionControl) {
            this.encryptionControl = encryptionControl;
            return this;
        }

        Builder setUsableBrokers(Supplier<Iterator<UsableBroker>> usableBrokers) {
            this.usableBrokers = usableBrokers;
            return this;
        }

        Builder setIsTopicPlacementSupport(Supplier<Boolean> isTopicPlacementSupported) {
            this.isTopicPlacementSupported = isTopicPlacementSupported;
            return this;
        }

        Builder setConfigurationListener(ConfigurationListener configurationListener) {
            this.configurationListener = configurationListener;
            return this;
        }

        Builder setFeatureControl(FeatureControlManager featureControl) {
            this.featureControl = featureControl;
            return this;
        }

        ConfigurationControlManager build() {
            if (this.logContext == null) {
                this.logContext = new LogContext();
            }
            if (this.snapshotRegistry == null) {
                this.snapshotRegistry = new SnapshotRegistry(this.logContext);
            }
            if (this.configSchema == null) {
                throw new RuntimeException("You must set the configSchema.");
            }
            if (this.encryptionControl == null) {
                this.encryptionControl = new EncryptionControlManager.Builder().setLogContext(this.logContext).setSnapshotRegistry(this.snapshotRegistry).setEncryptorFactorySupplier(() -> MetadataEncryptorFactory.NO_ENCRYPTION_FACTORY).setIsEncryptorRequired(Boolean.valueOf(this.staticConfig.getOrDefault("confluent.metadata.encryptor.required", "false").toString())).build();
            }
            if (this.featureControl == null) {
                this.featureControl = new FeatureControlManager.Builder().build();
            }
            return new ConfigurationControlManager(this.logContext, this.snapshotRegistry, this.configSchema, this.existenceChecker, this.alterConfigPolicy, this.validator, this.staticConfig, this.nodeId, this.encryptionControl, this.usableBrokers, this.isTopicPlacementSupported, this.configurationListener, this.featureControl);
        }
    }
}

