/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;

public class CellControllerMetrics
implements AutoCloseable {
    private static final MetricName READY_CELL_COUNT = CellControllerMetrics.getMetricName("KafkaController", "ReadyCellCount");
    private static final MetricName QUARANTINED_CELL_COUNT = CellControllerMetrics.getMetricName("KafkaController", "QuarantinedCellCount");
    private static final MetricName EXCLUDED_CELL_COUNT = CellControllerMetrics.getMetricName("KafkaController", "ExcludedCellCount");
    private static final MetricName NOT_READY_FOR_TENANT_ASSIGNMENT_CELL_COUNT = CellControllerMetrics.getMetricName("KafkaController", "NotTenantAssignableCellCount");
    private static final MetricName STRAY_BROKER_COUNT = CellControllerMetrics.getMetricName("KafkaController", "StrayBrokerCount");
    private static final MetricName CELL_MIGRATION_STATE = CellControllerMetrics.getMetricName("KafkaController", "CellMigrationState");
    private static final String CELL_TENANT_COUNT = "TenantCount";
    private static final String CELL_REPLICA_COUNT = "ReplicaCount";
    private static final String CELL_INCOMING_TENANT_COUNT = "IncomingTenantCount";
    private static final String CELL_OUTGOING_TENANT_COUNT = "OutgoingTenantCount";
    private static final String CELL_BROKER_COUNT = "BrokerCount";
    private final Optional<MetricsRegistry> registry;
    private final Map<Integer, CellMetrics> cellMetricsMap = new ConcurrentHashMap<Integer, CellMetrics>();
    private volatile int readyCellCount;
    private volatile int quarantinedCellCount;
    private volatile int excludedCellCount;
    private volatile int notTenantAssignableCellCount;
    private volatile int strayBrokerCount;
    private volatile byte cellMigrationState;
    private volatile boolean cellMetricsCreated;

    public CellControllerMetrics(Optional<MetricsRegistry> registry) {
        this.registry = registry;
        this.readyCellCount = 0;
        this.quarantinedCellCount = 0;
        this.excludedCellCount = 0;
        this.notTenantAssignableCellCount = 0;
        this.strayBrokerCount = 0;
        this.cellMigrationState = 0;
        this.cellMetricsCreated = false;
    }

    void createCellMetricsIfNeeded() {
        if (!this.cellMetricsCreated) {
            this.registry.ifPresent(r -> r.newGauge(READY_CELL_COUNT, (Gauge)new Gauge<Integer>(){

                public Integer value() {
                    return CellControllerMetrics.this.readyCellCount();
                }
            }));
            this.registry.ifPresent(r -> r.newGauge(QUARANTINED_CELL_COUNT, (Gauge)new Gauge<Integer>(){

                public Integer value() {
                    return CellControllerMetrics.this.quarantinedCellCount();
                }
            }));
            this.registry.ifPresent(r -> r.newGauge(EXCLUDED_CELL_COUNT, (Gauge)new Gauge<Integer>(){

                public Integer value() {
                    return CellControllerMetrics.this.excludedCellCount();
                }
            }));
            this.registry.ifPresent(r -> r.newGauge(NOT_READY_FOR_TENANT_ASSIGNMENT_CELL_COUNT, (Gauge)new Gauge<Integer>(){

                public Integer value() {
                    return CellControllerMetrics.this.notTenantAssignableCellCount();
                }
            }));
            this.registry.ifPresent(r -> r.newGauge(STRAY_BROKER_COUNT, (Gauge)new Gauge<Integer>(){

                public Integer value() {
                    return CellControllerMetrics.this.strayBrokerCount();
                }
            }));
            this.registry.ifPresent(r -> r.newGauge(CELL_MIGRATION_STATE, (Gauge)new Gauge<Byte>(){

                public Byte value() {
                    return CellControllerMetrics.this.cellMigrationState();
                }
            }));
            this.cellMetricsCreated = true;
        }
    }

    public int readyCellCount() {
        return this.readyCellCount;
    }

    public void setReadyCellCount(int value) {
        this.readyCellCount = value;
    }

    public int quarantinedCellCount() {
        return this.quarantinedCellCount;
    }

    public void setQuarantinedCellCount(int value) {
        this.quarantinedCellCount = value;
    }

    public int excludedCellCount() {
        return this.excludedCellCount;
    }

    public void setExcludedCellCount(int value) {
        this.excludedCellCount = value;
    }

    public int notTenantAssignableCellCount() {
        return this.notTenantAssignableCellCount;
    }

    public void setNotTenantAssignableCellCount(int value) {
        this.notTenantAssignableCellCount = value;
    }

    public int strayBrokerCount() {
        return this.strayBrokerCount;
    }

    public void setStrayBrokerCount(int value) {
        this.strayBrokerCount = value;
    }

    public byte cellMigrationState() {
        return this.cellMigrationState;
    }

    public void setCellMigrationState(byte value) {
        this.cellMigrationState = value;
    }

    public boolean cellMetricsCreated() {
        return this.cellMetricsCreated;
    }

    @Override
    public void close() {
        this.registry.ifPresent(r -> List.of(READY_CELL_COUNT, QUARANTINED_CELL_COUNT, EXCLUDED_CELL_COUNT, NOT_READY_FOR_TENANT_ASSIGNMENT_CELL_COUNT, STRAY_BROKER_COUNT, CELL_MIGRATION_STATE).forEach(arg_0 -> ((MetricsRegistry)r).removeMetric(arg_0)));
        this.cellMetricsMap.keySet().forEach(this::uninstallCellMetrics);
        this.cellMetricsMap.clear();
    }

    private static MetricName getMetricName(String type, String name) {
        return KafkaYammerMetrics.getMetricName((String)"kafka.controller", (String)type, (String)name);
    }

    static MetricName cellMetricName(int cellId, String name) {
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        tags.put("cellId", String.valueOf(cellId));
        return KafkaYammerMetrics.getMetricName((String)"kafka.controller", (String)"KafkaController", (String)name, tags);
    }

    public CellMetrics cellMetrics(int cellId) {
        CellMetrics metrics = this.cellMetricsMap.get(cellId);
        if (metrics != null) {
            return metrics;
        }
        return new CellMetrics();
    }

    void setCellMetrics(Map<Integer, CellMetrics> newCellMetricsMap) {
        Iterator<Map.Entry<Integer, CellMetrics>> iter = this.cellMetricsMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, CellMetrics> entry = iter.next();
            CellMetrics newMetrics = newCellMetricsMap.get(entry.getKey());
            if (newMetrics != null) continue;
            iter.remove();
            this.uninstallCellMetrics(entry.getKey());
        }
        for (Map.Entry<Integer, CellMetrics> entry : newCellMetricsMap.entrySet()) {
            if (this.cellMetricsMap.put(entry.getKey(), entry.getValue()) != null) continue;
            this.installCellMetrics(entry.getKey());
        }
    }

    private void uninstallCellMetrics(int cellId) {
        this.registry.ifPresent(r -> {
            r.removeMetric(CellControllerMetrics.cellMetricName(cellId, CELL_TENANT_COUNT));
            r.removeMetric(CellControllerMetrics.cellMetricName(cellId, CELL_REPLICA_COUNT));
            r.removeMetric(CellControllerMetrics.cellMetricName(cellId, CELL_INCOMING_TENANT_COUNT));
            r.removeMetric(CellControllerMetrics.cellMetricName(cellId, CELL_OUTGOING_TENANT_COUNT));
            r.removeMetric(CellControllerMetrics.cellMetricName(cellId, CELL_BROKER_COUNT));
        });
    }

    private void installCellMetrics(final int cellId) {
        this.registry.ifPresent(r -> {
            r.newGauge(CellControllerMetrics.cellMetricName(cellId, CELL_TENANT_COUNT), (Gauge)new Gauge<Integer>(this){
                final /* synthetic */ CellControllerMetrics this$0;
                {
                    this.this$0 = this$0;
                }

                public Integer value() {
                    return this.this$0.cellMetrics((int)cellId).tenantCount;
                }
            });
            r.newGauge(CellControllerMetrics.cellMetricName(cellId, CELL_REPLICA_COUNT), (Gauge)new Gauge<Integer>(this){
                final /* synthetic */ CellControllerMetrics this$0;
                {
                    this.this$0 = this$0;
                }

                public Integer value() {
                    return this.this$0.cellMetrics((int)cellId).replicaCount;
                }
            });
            r.newGauge(CellControllerMetrics.cellMetricName(cellId, CELL_INCOMING_TENANT_COUNT), (Gauge)new Gauge<Integer>(this){
                final /* synthetic */ CellControllerMetrics this$0;
                {
                    this.this$0 = this$0;
                }

                public Integer value() {
                    return this.this$0.cellMetrics((int)cellId).incomingTenants.size();
                }
            });
            r.newGauge(CellControllerMetrics.cellMetricName(cellId, CELL_OUTGOING_TENANT_COUNT), (Gauge)new Gauge<Integer>(this){
                final /* synthetic */ CellControllerMetrics this$0;
                {
                    this.this$0 = this$0;
                }

                public Integer value() {
                    return this.this$0.cellMetrics((int)cellId).outgoingTenants.size();
                }
            });
            r.newGauge(CellControllerMetrics.cellMetricName(cellId, CELL_BROKER_COUNT), (Gauge)new Gauge<Integer>(this){
                final /* synthetic */ CellControllerMetrics this$0;
                {
                    this.this$0 = this$0;
                }

                public Integer value() {
                    return this.this$0.cellMetrics((int)cellId).brokerCount;
                }
            });
        });
    }

    public static final class CellMetrics {
        int tenantCount;
        int replicaCount;
        Set<String> incomingTenants;
        Set<String> outgoingTenants;
        int brokerCount;

        CellMetrics() {
            this.tenantCount = 0;
            this.replicaCount = 0;
            this.incomingTenants = new HashSet<String>();
            this.outgoingTenants = new HashSet<String>();
            this.brokerCount = 0;
        }

        CellMetrics(int tenantCount, int replicaCount, Set<String> incomingTenants, Set<String> outgoingTenants, int brokerCount) {
            this.tenantCount = tenantCount;
            this.replicaCount = replicaCount;
            this.incomingTenants = incomingTenants;
            this.outgoingTenants = outgoingTenants;
            this.brokerCount = brokerCount;
        }

        public int tenantCount() {
            return this.tenantCount;
        }

        public int replicaCount() {
            return this.replicaCount;
        }

        public int numIncomingTenants() {
            return this.incomingTenants.size();
        }

        public int numOutgoingTenants() {
            return this.outgoingTenants.size();
        }

        public int brokerCount() {
            return this.brokerCount;
        }

        public int hashCode() {
            return Objects.hash(this.tenantCount, this.replicaCount, this.incomingTenants, this.outgoingTenants, this.brokerCount);
        }

        public boolean equals(Object o) {
            if (o == null || !o.getClass().equals(CellMetrics.class)) {
                return false;
            }
            CellMetrics other = (CellMetrics)o;
            return this.tenantCount == other.tenantCount && this.replicaCount == other.replicaCount && this.incomingTenants.equals(other.incomingTenants) && this.outgoingTenants.equals(other.outgoingTenants) && this.brokerCount == other.brokerCount;
        }

        public String toString() {
            return "CellMetrics(tenantCount=" + this.tenantCount + ", replicaCount=" + this.replicaCount + ", incomingTenants=" + String.valueOf(this.incomingTenants) + ", outgoingTenants=" + String.valueOf(this.outgoingTenants) + ", brokerCount=" + this.brokerCount + ")";
        }
    }
}

