/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;

public class ConfluentControllerMetrics
implements AutoCloseable {
    private static final MetricName GLOBAL_TOPIC_COUNT = ConfluentControllerMetrics.getMetricName("KafkaController", "GlobalTopicCount");
    private static final MetricName GLOBAL_PARTITION_COUNT = ConfluentControllerMetrics.getMetricName("KafkaController", "GlobalPartitionCount");
    private static final MetricName GLOBAL_OFFLINE_PARTITION_COUNT = ConfluentControllerMetrics.getMetricName("KafkaController", "OfflinePartitionsCount");
    private static final MetricName GLOBAL_UNDER_MIN_ISR_COUNT = ConfluentControllerMetrics.getMetricName("KafkaController", "GlobalUnderMinIsrPartitionCount");
    private static final MetricName GLOBAL_PARTITION_AVAILABILITY = ConfluentControllerMetrics.getMetricName("KafkaController", "PartitionAvailability");
    private static final MetricName PREFERRED_REPLICA_IMBALANCE_COUNT = ConfluentControllerMetrics.getMetricName("KafkaController", "PreferredReplicaImbalanceCount");
    private static final MetricName UNCLEAN_LEADER_ELECTIONS_PER_SEC = ConfluentControllerMetrics.getMetricName("ControllerStats", "UncleanLeaderElectionsPerSec");
    private static final MetricName ELECTION_FROM_ELIGIBLE_LEADER_REPLICAS_PER_SEC = ConfluentControllerMetrics.getMetricName("ControllerStats", "ElectionFromEligibleLeaderReplicasPerSec");
    private final Optional<MetricsRegistry> registry;
    private volatile int globalTopicCount;
    private final Map<String, TenantPartitionMetrics> tenantPartitionMetricsMap = new ConcurrentHashMap<String, TenantPartitionMetrics>();
    private volatile int globalPartitionCount;
    private volatile int globalOfflinePartitionCount;
    private volatile int globalUnderMinIsrCount;
    private volatile int globalUnderSLOCount;
    private volatile int preferredReplicaImbalanceCount;
    private Optional<Meter> uncleanLeaderElectionMeter = Optional.empty();
    private Optional<Meter> electionFromEligibleLeaderReplicasMeter = Optional.empty();

    public ConfluentControllerMetrics(Optional<MetricsRegistry> registry) {
        this.registry = registry;
        this.globalTopicCount = 0;
        this.globalPartitionCount = 0;
        this.globalOfflinePartitionCount = 0;
        this.globalUnderMinIsrCount = 0;
        this.globalUnderSLOCount = 0;
        this.preferredReplicaImbalanceCount = 0;
        registry.ifPresent(r -> r.newGauge(GLOBAL_TOPIC_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ConfluentControllerMetrics.this.globalTopicCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(GLOBAL_PARTITION_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ConfluentControllerMetrics.this.globalPartitionCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(GLOBAL_OFFLINE_PARTITION_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ConfluentControllerMetrics.this.globalOfflinePartitionCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(GLOBAL_UNDER_MIN_ISR_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ConfluentControllerMetrics.this.globalUnderMinIsrCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(GLOBAL_PARTITION_AVAILABILITY, (Gauge)new Gauge<Double>(){

            public Double value() {
                return ConfluentControllerMetrics.this.globalPartitionAvailability();
            }
        }));
        registry.ifPresent(r -> r.newGauge(PREFERRED_REPLICA_IMBALANCE_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ConfluentControllerMetrics.this.preferredReplicaImbalanceCount();
            }
        }));
        registry.ifPresent(r -> {
            this.uncleanLeaderElectionMeter = Optional.of(((MetricsRegistry)registry.get()).newMeter(UNCLEAN_LEADER_ELECTIONS_PER_SEC, "elections", TimeUnit.SECONDS));
        });
        registry.ifPresent(r -> {
            this.electionFromEligibleLeaderReplicasMeter = Optional.of(((MetricsRegistry)registry.get()).newMeter(ELECTION_FROM_ELIGIBLE_LEADER_REPLICAS_PER_SEC, "elections", TimeUnit.SECONDS));
        });
    }

    public int globalTopicCount() {
        return this.globalTopicCount;
    }

    public void setGlobalTopicCount(int value) {
        this.globalTopicCount = value;
    }

    public void addToGlobalTopicCount(int delta) {
        this.globalTopicCount += delta;
    }

    public int globalPartitionCount() {
        return this.globalPartitionCount;
    }

    public void setGlobalPartitionCount(int value) {
        this.globalPartitionCount = value;
    }

    public void addToGlobalPartitionCount(int delta) {
        this.globalPartitionCount += delta;
    }

    public int globalOfflinePartitionCount() {
        return this.globalOfflinePartitionCount;
    }

    public void setGlobalOfflinePartitionCount(int value) {
        this.globalOfflinePartitionCount = value;
    }

    public void addToGlobalOfflinePartitionCount(int delta) {
        this.globalOfflinePartitionCount += delta;
    }

    public int globalUnderMinIsrCount() {
        return this.globalUnderMinIsrCount;
    }

    public void setGlobalUnderMinIsrCount(int value) {
        this.globalUnderMinIsrCount = value;
    }

    public void addToGlobalUnderMinIsrCount(int delta) {
        this.globalUnderMinIsrCount += delta;
    }

    public void setGlobalUnderSLOCount(int value) {
        this.globalUnderSLOCount = value;
    }

    public void addToGlobalUnderSLOCount(int delta) {
        this.globalUnderSLOCount += delta;
    }

    public int preferredReplicaImbalanceCount() {
        return this.preferredReplicaImbalanceCount;
    }

    public void setPreferredReplicaImbalanceCount(int value) {
        this.preferredReplicaImbalanceCount = value;
    }

    public void addToPreferredReplicaImbalanceCount(int delta) {
        this.preferredReplicaImbalanceCount += delta;
    }

    public void updateUncleanLeaderElection(int count) {
        this.uncleanLeaderElectionMeter.ifPresent(m -> m.mark((long)count));
    }

    public void updateElectionFromEligibleLeaderReplicasCount(int count) {
        this.electionFromEligibleLeaderReplicasMeter.ifPresent(m -> m.mark((long)count));
    }

    public double globalPartitionAvailability() {
        return ConfluentControllerMetrics.computePartitionAvailability(this.globalPartitionCount, this.globalUnderSLOCount);
    }

    @Override
    public void close() {
        this.registry.ifPresent(r -> List.of(GLOBAL_TOPIC_COUNT, GLOBAL_PARTITION_COUNT, GLOBAL_OFFLINE_PARTITION_COUNT, GLOBAL_UNDER_MIN_ISR_COUNT, GLOBAL_PARTITION_AVAILABILITY, PREFERRED_REPLICA_IMBALANCE_COUNT, UNCLEAN_LEADER_ELECTIONS_PER_SEC, ELECTION_FROM_ELIGIBLE_LEADER_REPLICAS_PER_SEC).forEach(arg_0 -> ((MetricsRegistry)r).removeMetric(arg_0)));
        this.tenantPartitionMetricsMap.keySet().forEach(this::uninstallTenantMetrics);
        this.tenantPartitionMetricsMap.clear();
    }

    private static MetricName getMetricName(String type, String name) {
        return KafkaYammerMetrics.getMetricName((String)"kafka.controller", (String)type, (String)name);
    }

    static MetricName tenantPartitionAvailabilityMetricName(String tenant) {
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        tags.put("tenant", tenant);
        return KafkaYammerMetrics.getMetricName((String)"kafka.controller", (String)"KafkaController", (String)"TenantPartitionAvailability", tags);
    }

    static double computePartitionAvailability(double partitionCount, double underSLOCount) {
        return partitionCount == 0.0 ? 1.0 : (partitionCount - underSLOCount) / partitionCount;
    }

    TenantPartitionMetrics tenantPartitionMetrics(String tenant) {
        return this.tenantPartitionMetricsMap.getOrDefault(tenant, TenantPartitionMetrics.EMPTY);
    }

    void setTenantPartitionMetrics(Map<String, TenantPartitionMetrics> newTenantPartitionMetricsMap) {
        Iterator<Map.Entry<String, TenantPartitionMetrics>> iter = this.tenantPartitionMetricsMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, TenantPartitionMetrics> entry = iter.next();
            TenantPartitionMetrics newMetrics = newTenantPartitionMetricsMap.get(entry.getKey());
            if (newMetrics != null && !newMetrics.empty()) continue;
            iter.remove();
            this.uninstallTenantMetrics(entry.getKey());
        }
        for (Map.Entry<String, TenantPartitionMetrics> entry : newTenantPartitionMetricsMap.entrySet()) {
            if (entry.getValue().empty() || this.tenantPartitionMetricsMap.put(entry.getKey(), entry.getValue()) != null) continue;
            this.installTenantMetrics(entry.getKey());
        }
    }

    void addToTenantPartitionMetrics(String tenant, int partitionCountDelta, int underSLOCountDelta) {
        this.tenantPartitionMetricsMap.compute(tenant, (__, tenantMetrics) -> {
            if (tenantMetrics == null) {
                tenantMetrics = TenantPartitionMetrics.EMPTY;
            }
            TenantPartitionMetrics next = tenantMetrics.next(partitionCountDelta, underSLOCountDelta);
            if (tenantMetrics.empty()) {
                if (!next.empty()) {
                    this.installTenantMetrics(tenant);
                }
            } else if (next.empty()) {
                this.uninstallTenantMetrics(tenant);
                return null;
            }
            return next;
        });
    }

    private void uninstallTenantMetrics(String tenant) {
        this.registry.ifPresent(r -> r.removeMetric(ConfluentControllerMetrics.tenantPartitionAvailabilityMetricName(tenant)));
    }

    private void installTenantMetrics(final String tenant) {
        this.registry.ifPresent(r -> r.newGauge(ConfluentControllerMetrics.tenantPartitionAvailabilityMetricName(tenant), (Gauge)new Gauge<Double>(this){
            final /* synthetic */ ConfluentControllerMetrics this$0;
            {
                this.this$0 = this$0;
            }

            public Double value() {
                return this.this$0.tenantPartitionMetrics(tenant).partitionAvailability();
            }
        }));
    }

    static final class TenantPartitionMetrics {
        final int partitionCount;
        final int underSLOCount;
        static final TenantPartitionMetrics EMPTY = new TenantPartitionMetrics(0, 0);

        TenantPartitionMetrics(int partitionCount, int underSLOCount) {
            this.partitionCount = partitionCount;
            this.underSLOCount = underSLOCount;
        }

        boolean empty() {
            return this.partitionCount == 0;
        }

        double partitionAvailability() {
            return ConfluentControllerMetrics.computePartitionAvailability(this.partitionCount, this.underSLOCount);
        }

        TenantPartitionMetrics next(int partitionCountDelta, int underSLOCountDelta) {
            return new TenantPartitionMetrics(this.partitionCount + partitionCountDelta, this.underSLOCount + underSLOCountDelta);
        }

        public boolean equals(Object o) {
            if (o == null || !o.getClass().equals(TenantPartitionMetrics.class)) {
                return false;
            }
            TenantPartitionMetrics other = (TenantPartitionMetrics)o;
            return this.partitionCount == other.partitionCount && this.underSLOCount == other.underSLOCount;
        }

        public int hashCode() {
            return Objects.hash(this.partitionCount, this.underSLOCount);
        }

        public String toString() {
            return "TenantPartitionMetrics(partitionCount=" + this.partitionCount + ", underSLOCount=" + this.underSLOCount + ")";
        }
    }
}

