/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.DegradedBrokerHealthState;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public class BrokerRegistration {
    private final int id;
    private final long epoch;
    private final Uuid incarnationId;
    private final Map<String, Endpoint> listeners;
    private final Map<String, VersionRange> supportedFeatures;
    private final Optional<String> rack;
    private final boolean fenced;
    private final boolean inControlledShutdown;
    private final boolean isMigratingZkBroker;
    private final TreeSet<DegradedBrokerHealthState> degradedComponents;
    private final Set<Uuid> metadataEncryptors;
    private final List<Uuid> sortedDirectories;

    private BrokerRegistration(int id, long epoch, Uuid incarnationId, Map<String, Endpoint> listeners, Map<String, VersionRange> supportedFeatures, Optional<String> rack, boolean fenced, boolean inControlledShutdown, boolean isMigratingZkBroker, Collection<DegradedBrokerHealthState> degradedComponents, Set<Uuid> metadataEncryptors, List<Uuid> directories) {
        this.id = id;
        this.epoch = epoch;
        this.incarnationId = incarnationId;
        HashMap<String, Endpoint> newListeners = new HashMap<String, Endpoint>(listeners.size());
        for (Map.Entry<String, Endpoint> entry : listeners.entrySet()) {
            if (entry.getValue().listener().isEmpty()) {
                throw new IllegalArgumentException("Broker listeners must be named.");
            }
            newListeners.put(entry.getKey(), entry.getValue());
        }
        this.listeners = Collections.unmodifiableMap(newListeners);
        Objects.requireNonNull(supportedFeatures);
        this.supportedFeatures = new HashMap<String, VersionRange>(supportedFeatures);
        this.rack = rack;
        this.fenced = fenced;
        this.inControlledShutdown = inControlledShutdown;
        this.isMigratingZkBroker = isMigratingZkBroker;
        this.degradedComponents = new TreeSet<DegradedBrokerHealthState>(degradedComponents);
        this.metadataEncryptors = metadataEncryptors;
        directories = new ArrayList<Uuid>(directories);
        directories.sort(Uuid::compareTo);
        this.sortedDirectories = Collections.unmodifiableList(directories);
    }

    public static BrokerRegistration fromRecord(RegisterBrokerRecord record) {
        HashSet<Uuid> metadataEncryptors;
        Set<DegradedBrokerHealthState> degradedComponents;
        Object endpoint;
        HashMap<String, Endpoint> listeners = new HashMap<String, Endpoint>();
        Iterator iterator = record.endPoints().iterator();
        while (iterator.hasNext()) {
            endpoint = (RegisterBrokerRecord.BrokerEndpoint)iterator.next();
            listeners.put(((RegisterBrokerRecord.BrokerEndpoint)endpoint).name(), new Endpoint(((RegisterBrokerRecord.BrokerEndpoint)endpoint).name(), SecurityProtocol.forId((short)((RegisterBrokerRecord.BrokerEndpoint)endpoint).securityProtocol()), ((RegisterBrokerRecord.BrokerEndpoint)endpoint).host(), ((RegisterBrokerRecord.BrokerEndpoint)endpoint).port()));
        }
        HashMap<String, VersionRange> supportedFeatures = new HashMap<String, VersionRange>();
        endpoint = record.features().iterator();
        while (endpoint.hasNext()) {
            RegisterBrokerRecord.BrokerFeature feature = (RegisterBrokerRecord.BrokerFeature)endpoint.next();
            supportedFeatures.put(feature.name(), VersionRange.of(feature.minSupportedVersion(), feature.maxSupportedVersion()));
        }
        Set<DegradedBrokerHealthState> set = degradedComponents = record.degradedComponents() != null ? DegradedBrokerHealthState.fromRegisterBrokerRecord(record.degradedComponents()) : Set.of();
        if (record.metadataEncryptors() != null) {
            metadataEncryptors = new HashSet<Uuid>();
            record.metadataEncryptors().forEach(e -> metadataEncryptors.add(e.encryptorId()));
        } else {
            metadataEncryptors = null;
        }
        return new BrokerRegistration(record.brokerId(), record.brokerEpoch(), record.incarnationId(), listeners, supportedFeatures, Optional.ofNullable(record.rack()), record.fenced(), record.inControlledShutdown(), record.isMigratingZkBroker(), degradedComponents, metadataEncryptors, record.logDirs());
    }

    public int id() {
        return this.id;
    }

    public long epoch() {
        return this.epoch;
    }

    public Uuid incarnationId() {
        return this.incarnationId;
    }

    public Map<String, Endpoint> listeners() {
        return this.listeners;
    }

    public Optional<Node> node(String listenerName) {
        Endpoint endpoint = this.listeners().get(listenerName);
        if (endpoint == null) {
            return Optional.empty();
        }
        return Optional.of(new Node(this.id, endpoint.host(), endpoint.port(), (String)this.rack.orElse(null), this.fenced));
    }

    public List<Node> nodes() {
        return this.listeners.keySet().stream().flatMap(l -> this.node((String)l).stream()).toList();
    }

    public Map<String, VersionRange> supportedFeatures() {
        return this.supportedFeatures;
    }

    public Optional<String> rack() {
        return this.rack;
    }

    public boolean fenced() {
        return this.fenced;
    }

    public boolean inControlledShutdown() {
        return this.inControlledShutdown;
    }

    public Set<DegradedBrokerHealthState> degradedComponents() {
        return this.degradedComponents;
    }

    public Set<Uuid> metadataEncryptorIds() {
        return this.metadataEncryptors;
    }

    public List<Uuid> directories() {
        return this.sortedDirectories;
    }

    public boolean hasOnlineDir(Uuid dir) {
        return DirectoryId.isOnline((Uuid)dir, this.sortedDirectories);
    }

    public List<Uuid> directoryIntersection(List<Uuid> otherDirectories) {
        ArrayList<Uuid> results = new ArrayList<Uuid>();
        for (Uuid directory : this.sortedDirectories) {
            if (!otherDirectories.contains(directory)) continue;
            results.add(directory);
        }
        return results;
    }

    public List<Uuid> directoryDifference(List<Uuid> otherDirectories) {
        ArrayList<Uuid> results = new ArrayList<Uuid>();
        for (Uuid directory : this.sortedDirectories) {
            if (otherDirectories.contains(directory)) continue;
            results.add(directory);
        }
        return results;
    }

    public ApiMessageAndVersion toRecord(ImageWriterOptions options) {
        RegisterBrokerRecord registrationRecord = new RegisterBrokerRecord().setBrokerId(this.id).setRack(this.rack.orElse(null)).setBrokerEpoch(this.epoch).setIncarnationId(this.incarnationId).setFenced(this.fenced).setInControlledShutdown(this.inControlledShutdown);
        if (!this.degradedComponents.isEmpty()) {
            if (options.metadataVersion().isSettingBrokerHealthSupported()) {
                registrationRecord.setDegradedComponents(this.degradedComponents.stream().map(degradedComponent -> new RegisterBrokerRecord.DegradedComponent().setReason(degradedComponent.reason()).setComponentCode(degradedComponent.component().id())).collect(Collectors.toList()));
            } else {
                options.handleLoss("the demotion status of a broker");
            }
        }
        if (this.isMigratingZkBroker) {
            if (options.metadataVersion().isMigrationSupported()) {
                registrationRecord.setIsMigratingZkBroker(this.isMigratingZkBroker);
            } else {
                options.handleLoss("the isMigratingZkBroker state of one or more brokers");
            }
        }
        if (this.metadataEncryptors == null) {
            registrationRecord.setMetadataEncryptors(null);
        } else {
            ArrayList<RegisterBrokerRecord.Encryptor> registrationRecordEncryptors = new ArrayList<RegisterBrokerRecord.Encryptor>();
            this.metadataEncryptors.forEach(uuid -> registrationRecordEncryptors.add(new RegisterBrokerRecord.Encryptor().setEncryptorId((Uuid)uuid)));
            registrationRecordEncryptors.sort(Comparator.comparing(RegisterBrokerRecord.Encryptor::encryptorId));
            registrationRecord.setMetadataEncryptors(registrationRecordEncryptors);
        }
        if (this.sortedDirectories.isEmpty() || options.metadataVersion().isDirectoryAssignmentSupported()) {
            registrationRecord.setLogDirs(this.sortedDirectories);
        } else {
            options.handleLoss("the online log directories of one or more brokers");
        }
        for (Map.Entry<String, Endpoint> entry : this.listeners.entrySet()) {
            Endpoint endpoint = entry.getValue();
            registrationRecord.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setName(entry.getKey()).setHost(endpoint.host()).setPort(endpoint.port()).setSecurityProtocol(endpoint.securityProtocol().id));
        }
        for (Map.Entry<String, Object> entry : this.supportedFeatures.entrySet()) {
            registrationRecord.features().add(new RegisterBrokerRecord.BrokerFeature().setName(entry.getKey()).setMinSupportedVersion(((VersionRange)entry.getValue()).min()).setMaxSupportedVersion(((VersionRange)entry.getValue()).max()));
        }
        return new ApiMessageAndVersion((ApiMessage)registrationRecord, options.metadataVersion().registerBrokerRecordVersion());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.epoch, this.incarnationId, this.listeners, this.supportedFeatures, this.rack, this.fenced, this.inControlledShutdown, this.isMigratingZkBroker, this.degradedComponents, this.metadataEncryptors, this.sortedDirectories);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BrokerRegistration)) {
            return false;
        }
        BrokerRegistration other = (BrokerRegistration)o;
        return other.id == this.id && other.epoch == this.epoch && other.incarnationId.equals((Object)this.incarnationId) && other.listeners.equals(this.listeners) && other.supportedFeatures.equals(this.supportedFeatures) && other.rack.equals(this.rack) && other.fenced == this.fenced && other.inControlledShutdown == this.inControlledShutdown && other.isMigratingZkBroker == this.isMigratingZkBroker && other.degradedComponents.equals(this.degradedComponents) && Objects.equals(other.metadataEncryptors, this.metadataEncryptors) && other.sortedDirectories.equals(this.sortedDirectories);
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("BrokerRegistration(id=").append(this.id);
        bld.append(", epoch=").append(this.epoch);
        bld.append(", incarnationId=").append(this.incarnationId);
        bld.append(", listeners=[").append(this.listeners.keySet().stream().sorted().map(n -> this.listeners.get(n).toString()).collect(Collectors.joining(", ")));
        bld.append("], supportedFeatures={").append(this.supportedFeatures.keySet().stream().sorted().map(k -> k + ": " + String.valueOf(this.supportedFeatures.get(k))).collect(Collectors.joining(", ")));
        bld.append("}");
        bld.append(", rack=").append(this.rack);
        bld.append(", fenced=").append(this.fenced);
        bld.append(", inControlledShutdown=").append(this.inControlledShutdown);
        bld.append(", isMigratingZkBroker=").append(this.isMigratingZkBroker);
        bld.append(", degradedComponents=").append(this.degradedComponents);
        bld.append(", metadataEncryptors=");
        if (this.metadataEncryptors == null) {
            bld.append("null");
        } else {
            bld.append("[");
            bld.append(this.metadataEncryptors.stream().map(Uuid::toString).sorted().collect(Collectors.joining(", ")));
            bld.append("]");
        }
        bld.append(", directories=").append(this.sortedDirectories);
        bld.append(")");
        return bld.toString();
    }

    public BrokerRegistration cloneWith(Optional<Boolean> fencingChange, Optional<Boolean> inControlledShutdownChange, Optional<Set<DegradedBrokerHealthState>> brokerStatusChanges, Optional<List<Uuid>> directoriesChange) {
        boolean newFenced = fencingChange.orElse(this.fenced);
        boolean newInControlledShutdownChange = inControlledShutdownChange.orElse(this.inControlledShutdown);
        Set newDegradedComponents = brokerStatusChanges.orElse(this.degradedComponents);
        List<Uuid> newDirectories = directoriesChange.orElse(this.sortedDirectories);
        if (newFenced == this.fenced && newInControlledShutdownChange == this.inControlledShutdown && newDegradedComponents.equals(this.degradedComponents) && newDirectories.equals(this.sortedDirectories)) {
            return this;
        }
        return new BrokerRegistration(this.id, this.epoch, this.incarnationId, this.listeners, this.supportedFeatures, this.rack, newFenced, newInControlledShutdownChange, this.isMigratingZkBroker, newDegradedComponents, this.metadataEncryptors, newDirectories);
    }

    public static class Builder {
        private int id = 0;
        private long epoch = -1L;
        private Uuid incarnationId = Uuid.ZERO_UUID;
        private Map<String, Endpoint> listeners = new HashMap<String, Endpoint>();
        private Map<String, VersionRange> supportedFeatures = new HashMap<String, VersionRange>();
        private Optional<String> rack = Optional.empty();
        private boolean fenced = false;
        private boolean inControlledShutdown = false;
        private boolean isMigratingZkBroker = false;
        private Collection<DegradedBrokerHealthState> degradedComponents = Set.of();
        private Set<Uuid> metadataEncryptors = Set.of();
        private List<Uuid> directories = List.of();

        public Builder setId(int id) {
            this.id = id;
            return this;
        }

        public Builder setEpoch(long epoch) {
            this.epoch = epoch;
            return this;
        }

        public Builder setIncarnationId(Uuid incarnationId) {
            this.incarnationId = incarnationId;
            return this;
        }

        public Builder setListeners(List<Endpoint> listeners) {
            HashMap<String, Endpoint> listenersMap = new HashMap<String, Endpoint>();
            for (Endpoint endpoint : listeners) {
                listenersMap.put(endpoint.listener(), endpoint);
            }
            this.listeners = listenersMap;
            return this;
        }

        public Builder setListeners(Map<String, Endpoint> listeners) {
            this.listeners = listeners;
            return this;
        }

        public Builder setSupportedFeatures(Map<String, VersionRange> supportedFeatures) {
            this.supportedFeatures = supportedFeatures;
            return this;
        }

        public Builder setRack(Optional<String> rack) {
            Objects.requireNonNull(rack);
            this.rack = rack;
            return this;
        }

        public Builder setFenced(boolean fenced) {
            this.fenced = fenced;
            return this;
        }

        public Builder setInControlledShutdown(boolean inControlledShutdown) {
            this.inControlledShutdown = inControlledShutdown;
            return this;
        }

        public Builder setIsMigratingZkBroker(boolean isMigratingZkBroker) {
            this.isMigratingZkBroker = isMigratingZkBroker;
            return this;
        }

        public Builder setDegradedComponents(Collection<DegradedBrokerHealthState> degradedComponents) {
            this.degradedComponents = degradedComponents;
            return this;
        }

        public Builder setMetadataEncryptors(Set<Uuid> metadataEncryptors) {
            this.metadataEncryptors = metadataEncryptors;
            return this;
        }

        public Builder setDirectories(List<Uuid> directories) {
            this.directories = directories;
            return this;
        }

        public BrokerRegistration build() {
            return new BrokerRegistration(this.id, this.epoch, this.incarnationId, this.listeners, this.supportedFeatures, this.rack, this.fenced, this.inControlledShutdown, this.isMigratingZkBroker, this.degradedComponents, this.metadataEncryptors, this.directories);
        }
    }
}

