/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.resource.Resource;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.metadata.authorizer.AclStore;
import org.apache.kafka.metadata.authorizer.ResourceAclsBuilder;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.authorizer.Visitor;

class ResourceAcls
implements AclStore {
    static final Set<AclOperation> IMPLIES_DESCRIBE = Collections.unmodifiableSet(EnumSet.of(AclOperation.DESCRIBE, AclOperation.READ, AclOperation.WRITE, AclOperation.DELETE, AclOperation.ALTER));
    static final Set<AclOperation> IMPLIES_DESCRIBE_CONFIGS = Collections.unmodifiableSet(EnumSet.of(AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS));
    static final ResourceAcls EMPTY = new ResourceAcls(List.of(), List.of());
    private final List<StandardAcl> denyAcls;
    private final List<StandardAcl> allowAcls;

    ResourceAcls(List<StandardAcl> allowAcls, List<StandardAcl> denyAcls) {
        this.allowAcls = allowAcls;
        this.denyAcls = denyAcls;
    }

    ResourceAcls(StandardAcl acl) {
        List<StandardAcl> acls = List.of(acl);
        if (acl.permissionType() == AclPermissionType.ALLOW) {
            this.allowAcls = acls;
            this.denyAcls = List.of();
        } else {
            this.allowAcls = List.of();
            this.denyAcls = acls;
        }
    }

    ResourceAcls(List<StandardAcl> acls) {
        ArrayList<StandardAcl> allowAcls = new ArrayList<StandardAcl>();
        ArrayList<StandardAcl> denyAcls = new ArrayList<StandardAcl>();
        for (StandardAcl acl : acls) {
            if (acl.permissionType() == AclPermissionType.ALLOW) {
                allowAcls.add(acl);
                continue;
            }
            denyAcls.add(acl);
        }
        this.allowAcls = Collections.unmodifiableList(allowAcls);
        this.denyAcls = Collections.unmodifiableList(denyAcls);
    }

    boolean isEmpty() {
        return this.allowAcls.size() + this.denyAcls.size() == 0;
    }

    ResourceAcls copyWithChanges(ResourceAclsBuilder changes) {
        return changes.build(this);
    }

    @Override
    public boolean walk(Visitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public Optional<StandardAcl> findMatchingAcl(AclOperation operation, String host) {
        Optional<StandardAcl> rule = ResourceAcls.findMatchingAcl(this.denyAcls, operation, host);
        return rule.isPresent() ? rule : ResourceAcls.findMatchingAcl(this.allowAcls, operation, host);
    }

    private static Optional<StandardAcl> findMatchingAcl(List<StandardAcl> acls, AclOperation operation, String host) {
        for (StandardAcl acl : acls) {
            boolean matching = ResourceAcls.isMatching(acl, operation, host);
            if (!matching) continue;
            return Optional.of(acl);
        }
        return Optional.empty();
    }

    private static boolean isMatching(StandardAcl acl, AclOperation operation, String host) {
        block8: {
            block9: {
                if (!acl.host().equals("*") && !acl.host().equals(host)) {
                    return false;
                }
                if (acl.operation() == AclOperation.ALL) break block8;
                if (!acl.permissionType().equals((Object)AclPermissionType.ALLOW)) break block9;
                switch (operation) {
                    case DESCRIBE: {
                        if (!IMPLIES_DESCRIBE.contains(acl.operation())) {
                            return false;
                        }
                        break block8;
                    }
                    case DESCRIBE_CONFIGS: {
                        if (!IMPLIES_DESCRIBE_CONFIGS.contains(acl.operation())) {
                            return false;
                        }
                        break block8;
                    }
                    default: {
                        if (operation != acl.operation()) {
                            return false;
                        }
                        break block8;
                    }
                }
            }
            return operation == acl.operation();
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.allowAcls, this.denyAcls);
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        ResourceAcls other = (ResourceAcls)o;
        return this.allowAcls.equals(other.allowAcls) && this.denyAcls.equals(other.denyAcls);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ResourceAcls(AllowAcls(");
        this.allowAcls.forEach(standardAcl -> {
            builder.append("Entry(");
            builder.append(standardAcl);
            builder.append(")");
        });
        builder.append("), DenyAcls(");
        this.denyAcls.forEach(standardAcl -> {
            builder.append("Entry(");
            builder.append(standardAcl);
            builder.append(")");
        });
        builder.append(")");
        builder.append(")");
        return builder.toString();
    }

    List<StandardAcl> allowAcls() {
        return this.allowAcls;
    }

    List<StandardAcl> denyAcls() {
        return this.denyAcls;
    }

    List<StandardAcl> acls() {
        ArrayList<StandardAcl> allAcls = new ArrayList<StandardAcl>(this.allowAcls);
        allAcls.addAll(this.denyAcls);
        return allAcls;
    }

    boolean validateAclCache(KafkaPrincipal principal, Resource resource) {
        for (StandardAcl standardAcl : this.allowAcls) {
            if (ResourceAcls.validateAcl(standardAcl, principal, resource)) continue;
            return false;
        }
        for (StandardAcl standardAcl : this.denyAcls) {
            if (ResourceAcls.validateAcl(standardAcl, principal, resource)) continue;
            return false;
        }
        return true;
    }

    private static boolean validateAcl(StandardAcl standardAcl, KafkaPrincipal principal, Resource resource) {
        return standardAcl.kafkaPrincipal().equals((Object)principal) && standardAcl.resource().equals((Object)resource);
    }
}

