/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class RegisterControllerRecord
implements ApiMessage {
    int controllerId;
    Uuid incarnationId;
    boolean zkMigrationReady;
    ControllerEndpointCollection endPoints;
    ControllerFeatureCollection features;
    List<Encryptor> metadataEncryptors;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("controller_id", (Type)Type.INT32, "The controller id."), new Field("incarnation_id", (Type)Type.UUID, "The incarnation ID of the controller process"), new Field("zk_migration_ready", (Type)Type.BOOLEAN, "Set if the required configurations for ZK migration are present."), new Field("end_points", (Type)new CompactArrayOf((Type)ControllerEndpoint.SCHEMA_0), "The endpoints that can be used to communicate with this controller."), new Field("features", (Type)new CompactArrayOf((Type)ControllerFeature.SCHEMA_0), "The features on this controller"), Field.TaggedFieldsSection.of((Object[])new Object[]{10000, new Field("metadata_encryptors", (Type)CompactArrayOf.nullable((Type)Encryptor.SCHEMA_0), "The metadata encryptors known to this controller")})});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public RegisterControllerRecord(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public RegisterControllerRecord(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public RegisterControllerRecord() {
        this.controllerId = 0;
        this.incarnationId = Uuid.ZERO_UUID;
        this.zkMigrationReady = false;
        this.endPoints = new ControllerEndpointCollection(0);
        this.features = new ControllerFeatureCollection(0);
        this.metadataEncryptors = null;
    }

    public short apiKey() {
        return 27;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public final void read(Readable _readable, short _version, MessageContext _context) {
        int i;
        this.controllerId = _readable.readInt();
        this.incarnationId = _readable.readUuid();
        this.zkMigrationReady = _readable.readByte() != 0;
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field endPoints was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ImplicitLinkedHashMultiCollection newCollection = new ControllerEndpointCollection(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add((ImplicitLinkedHashCollection.Element)new ControllerEndpoint(_readable, _version, _context));
        }
        this.endPoints = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field features was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ControllerFeatureCollection(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add((ImplicitLinkedHashCollection.Element)new ControllerFeature(_readable, _version, _context));
        }
        this.features = newCollection;
        this.metadataEncryptors = null;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        block5: for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                case 10000: {
                    int arrayLength2 = _readable.readUnsignedVarint() - 1;
                    if (arrayLength2 < 0) {
                        this.metadataEncryptors = null;
                        continue block5;
                    }
                    if (arrayLength2 > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength2 + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<Encryptor> newCollection2 = new ArrayList<Encryptor>(arrayLength2);
                    for (int i2 = 0; i2 < arrayLength2; ++i2) {
                        newCollection2.add(new Encryptor(_readable, _version, _context));
                    }
                    this.metadataEncryptors = newCollection2;
                    continue block5;
                }
                default: {
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.controllerId);
        _writable.writeUuid(this.incarnationId);
        _writable.writeByte(this.zkMigrationReady ? (byte)1 : 0);
        _writable.writeUnsignedVarint(this.endPoints.size() + 1);
        Iterator iterator = this.endPoints.iterator();
        while (iterator.hasNext()) {
            ControllerEndpoint endPointsElement = (ControllerEndpoint)iterator.next();
            endPointsElement.write(_writable, _cache, _version, _context);
        }
        _writable.writeUnsignedVarint(this.features.size() + 1);
        iterator = this.features.iterator();
        while (iterator.hasNext()) {
            ControllerFeature featuresElement = (ControllerFeature)iterator.next();
            featuresElement.write(_writable, _cache, _version, _context);
        }
        if (this.metadataEncryptors != null) {
            ++_numTaggedFields;
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, 10000);
        if (this.metadataEncryptors != null) {
            _writable.writeUnsignedVarint(10000);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.metadataEncryptors).intValue());
            _writable.writeUnsignedVarint(this.metadataEncryptors.size() + 1);
            for (Encryptor metadataEncryptorsElement : this.metadataEncryptors) {
                metadataEncryptorsElement.write(_writable, _cache, _version, _context);
            }
        }
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(16);
        _size.addBytes(1);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.endPoints.size() + 1)));
        Iterator iterator = this.endPoints.iterator();
        while (iterator.hasNext()) {
            ControllerEndpoint endPointsElement = (ControllerEndpoint)iterator.next();
            endPointsElement.addSize(_size, _cache, _version, _context);
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.features.size() + 1)));
        iterator = this.features.iterator();
        while (iterator.hasNext()) {
            ControllerFeature featuresElement = (ControllerFeature)iterator.next();
            featuresElement.addSize(_size, _cache, _version, _context);
        }
        if (this.metadataEncryptors != null) {
            ++_numTaggedFields;
            _size.addBytes(2);
            int _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.metadataEncryptors.size() + 1)));
            for (Encryptor metadataEncryptorsElement : this.metadataEncryptors) {
                metadataEncryptorsElement.addSize(_size, _cache, _version, _context);
            }
            int _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.metadataEncryptors, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RegisterControllerRecord)) {
            return false;
        }
        RegisterControllerRecord other = (RegisterControllerRecord)obj;
        if (this.controllerId != other.controllerId) {
            return false;
        }
        if (!this.incarnationId.equals((Object)other.incarnationId)) {
            return false;
        }
        if (this.zkMigrationReady != other.zkMigrationReady) {
            return false;
        }
        if (this.endPoints == null ? other.endPoints != null : !this.endPoints.equals((Object)other.endPoints)) {
            return false;
        }
        if (this.features == null ? other.features != null : !this.features.equals((Object)other.features)) {
            return false;
        }
        if (this.metadataEncryptors == null ? other.metadataEncryptors != null : !this.metadataEncryptors.equals(other.metadataEncryptors)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.controllerId;
        hashCode = 31 * hashCode + this.incarnationId.hashCode();
        hashCode = 31 * hashCode + (this.zkMigrationReady ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.endPoints == null ? 0 : this.endPoints.hashCode());
        hashCode = 31 * hashCode + (this.features == null ? 0 : this.features.hashCode());
        hashCode = 31 * hashCode + (this.metadataEncryptors == null ? 0 : this.metadataEncryptors.hashCode());
        return hashCode;
    }

    public RegisterControllerRecord duplicate() {
        Object _element;
        RegisterControllerRecord _duplicate = new RegisterControllerRecord();
        _duplicate.controllerId = this.controllerId;
        _duplicate.incarnationId = this.incarnationId;
        _duplicate.zkMigrationReady = this.zkMigrationReady;
        ControllerEndpointCollection newEndPoints = new ControllerEndpointCollection(this.endPoints.size());
        Iterator iterator = this.endPoints.iterator();
        while (iterator.hasNext()) {
            _element = (ControllerEndpoint)iterator.next();
            newEndPoints.add(((ControllerEndpoint)_element).duplicate());
        }
        _duplicate.endPoints = newEndPoints;
        ControllerFeatureCollection newFeatures = new ControllerFeatureCollection(this.features.size());
        _element = this.features.iterator();
        while (_element.hasNext()) {
            ControllerFeature _element2 = (ControllerFeature)_element.next();
            newFeatures.add(_element2.duplicate());
        }
        _duplicate.features = newFeatures;
        if (this.metadataEncryptors == null) {
            _duplicate.metadataEncryptors = null;
        } else {
            ArrayList<Encryptor> newMetadataEncryptors = new ArrayList<Encryptor>(this.metadataEncryptors.size());
            for (Encryptor _element3 : this.metadataEncryptors) {
                newMetadataEncryptors.add(_element3.duplicate());
            }
            _duplicate.metadataEncryptors = newMetadataEncryptors;
        }
        return _duplicate;
    }

    public String toString() {
        return "RegisterControllerRecord(controllerId=" + this.controllerId + ", incarnationId=" + this.incarnationId.toString() + ", zkMigrationReady=" + (this.zkMigrationReady ? "true" : "false") + ", endPoints=" + MessageUtil.deepToString((Iterator)this.endPoints.iterator()) + ", features=" + MessageUtil.deepToString((Iterator)this.features.iterator()) + ", metadataEncryptors=" + (this.metadataEncryptors == null ? "null" : MessageUtil.deepToString(this.metadataEncryptors.iterator())) + ")";
    }

    public int controllerId() {
        return this.controllerId;
    }

    public Uuid incarnationId() {
        return this.incarnationId;
    }

    public boolean zkMigrationReady() {
        return this.zkMigrationReady;
    }

    public ControllerEndpointCollection endPoints() {
        return this.endPoints;
    }

    public ControllerFeatureCollection features() {
        return this.features;
    }

    public List<Encryptor> metadataEncryptors() {
        return this.metadataEncryptors;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public RegisterControllerRecord setControllerId(int v) {
        this.controllerId = v;
        return this;
    }

    public RegisterControllerRecord setIncarnationId(Uuid v) {
        this.incarnationId = v;
        return this;
    }

    public RegisterControllerRecord setZkMigrationReady(boolean v) {
        this.zkMigrationReady = v;
        return this;
    }

    public RegisterControllerRecord setEndPoints(ControllerEndpointCollection v) {
        this.endPoints = v;
        return this;
    }

    public RegisterControllerRecord setFeatures(ControllerFeatureCollection v) {
        this.features = v;
        return this;
    }

    public RegisterControllerRecord setMetadataEncryptors(List<Encryptor> v) {
        this.metadataEncryptors = v;
        return this;
    }

    public static class ControllerEndpointCollection
    extends ImplicitLinkedHashMultiCollection<ControllerEndpoint> {
        public ControllerEndpointCollection() {
        }

        public ControllerEndpointCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public ControllerEndpointCollection(Iterator<ControllerEndpoint> iterator) {
            super(iterator);
        }

        public ControllerEndpoint find(String name) {
            ControllerEndpoint _key = new ControllerEndpoint();
            _key.setName(name);
            return (ControllerEndpoint)this.find(_key);
        }

        public List<ControllerEndpoint> findAll(String name) {
            ControllerEndpoint _key = new ControllerEndpoint();
            _key.setName(name);
            return this.findAll(_key);
        }

        public ControllerEndpointCollection duplicate() {
            ControllerEndpointCollection _duplicate = new ControllerEndpointCollection(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ControllerEndpoint _element = (ControllerEndpoint)iterator.next();
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class ControllerFeatureCollection
    extends ImplicitLinkedHashMultiCollection<ControllerFeature> {
        public ControllerFeatureCollection() {
        }

        public ControllerFeatureCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public ControllerFeatureCollection(Iterator<ControllerFeature> iterator) {
            super(iterator);
        }

        public ControllerFeature find(String name) {
            ControllerFeature _key = new ControllerFeature();
            _key.setName(name);
            return (ControllerFeature)this.find(_key);
        }

        public List<ControllerFeature> findAll(String name) {
            ControllerFeature _key = new ControllerFeature();
            _key.setName(name);
            return this.findAll(_key);
        }

        public ControllerFeatureCollection duplicate() {
            ControllerFeatureCollection _duplicate = new ControllerFeatureCollection(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ControllerFeature _element = (ControllerFeature)iterator.next();
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class ControllerEndpoint
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        String host;
        int port;
        short securityProtocol;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.COMPACT_STRING, "The name of the endpoint."), new Field("host", (Type)Type.COMPACT_STRING, "The hostname."), new Field("port", (Type)Type.UINT16, "The port."), new Field("security_protocol", (Type)Type.INT16, "The security protocol."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public ControllerEndpoint(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
            this.prev = -2;
            this.next = -2;
        }

        public ControllerEndpoint() {
            this.name = "";
            this.host = "";
            this.port = 0;
            this.securityProtocol = 0;
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ControllerEndpoint");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            this.port = _readable.readUnsignedShort();
            this.securityProtocol = _readable.readShort();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.name);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue((Object)this.host);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeUnsignedShort(this.port);
            _writable.writeShort(this.securityProtocol);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ControllerEndpoint");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.host, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _size.addBytes(2);
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof ControllerEndpoint)) {
                return false;
            }
            ControllerEndpoint other = (ControllerEndpoint)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ControllerEndpoint)) {
                return false;
            }
            ControllerEndpoint other = (ControllerEndpoint)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.port != other.port) {
                return false;
            }
            if (this.securityProtocol != other.securityProtocol) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public ControllerEndpoint duplicate() {
            ControllerEndpoint _duplicate = new ControllerEndpoint();
            _duplicate.name = this.name;
            _duplicate.host = this.host;
            _duplicate.port = this.port;
            _duplicate.securityProtocol = this.securityProtocol;
            return _duplicate;
        }

        public String toString() {
            return "ControllerEndpoint(name=" + (String)(this.name == null ? "null" : "'" + this.name.toString() + "'") + ", host=" + (String)(this.host == null ? "null" : "'" + this.host.toString() + "'") + ", port=" + this.port + ", securityProtocol=" + this.securityProtocol + ")";
        }

        public String name() {
            return this.name;
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        public short securityProtocol() {
            return this.securityProtocol;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ControllerEndpoint setName(String v) {
            this.name = v;
            return this;
        }

        public ControllerEndpoint setHost(String v) {
            this.host = v;
            return this;
        }

        public ControllerEndpoint setPort(int v) {
            if (v < 0 || v > 65535) {
                throw new RuntimeException("Invalid value " + v + " for unsigned short field.");
            }
            this.port = v;
            return this;
        }

        public ControllerEndpoint setSecurityProtocol(short v) {
            this.securityProtocol = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }
    }

    public static class ControllerFeature
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        short minSupportedVersion;
        short maxSupportedVersion;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.COMPACT_STRING, "The feature name."), new Field("min_supported_version", (Type)Type.INT16, "The minimum supported feature level."), new Field("max_supported_version", (Type)Type.INT16, "The maximum supported feature level."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public ControllerFeature(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
            this.prev = -2;
            this.next = -2;
        }

        public ControllerFeature() {
            this.name = "";
            this.minSupportedVersion = 0;
            this.maxSupportedVersion = 0;
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ControllerFeature");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.minSupportedVersion = _readable.readShort();
            this.maxSupportedVersion = _readable.readShort();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.name);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeShort(this.minSupportedVersion);
            _writable.writeShort(this.maxSupportedVersion);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ControllerFeature");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _size.addBytes(2);
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof ControllerFeature)) {
                return false;
            }
            ControllerFeature other = (ControllerFeature)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ControllerFeature)) {
                return false;
            }
            ControllerFeature other = (ControllerFeature)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.minSupportedVersion != other.minSupportedVersion) {
                return false;
            }
            if (this.maxSupportedVersion != other.maxSupportedVersion) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public ControllerFeature duplicate() {
            ControllerFeature _duplicate = new ControllerFeature();
            _duplicate.name = this.name;
            _duplicate.minSupportedVersion = this.minSupportedVersion;
            _duplicate.maxSupportedVersion = this.maxSupportedVersion;
            return _duplicate;
        }

        public String toString() {
            return "ControllerFeature(name=" + (String)(this.name == null ? "null" : "'" + this.name.toString() + "'") + ", minSupportedVersion=" + this.minSupportedVersion + ", maxSupportedVersion=" + this.maxSupportedVersion + ")";
        }

        public String name() {
            return this.name;
        }

        public short minSupportedVersion() {
            return this.minSupportedVersion;
        }

        public short maxSupportedVersion() {
            return this.maxSupportedVersion;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ControllerFeature setName(String v) {
            this.name = v;
            return this;
        }

        public ControllerFeature setMinSupportedVersion(short v) {
            this.minSupportedVersion = v;
            return this;
        }

        public ControllerFeature setMaxSupportedVersion(short v) {
            this.maxSupportedVersion = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }
    }

    public static class Encryptor
    implements Message {
        Uuid encryptorId;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("encryptor_id", (Type)Type.UUID, "The UUID of the metadata encryptor."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public Encryptor(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public Encryptor() {
            this.encryptorId = Uuid.ZERO_UUID;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of Encryptor");
            }
            this.encryptorId = _readable.readUuid();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeUuid(this.encryptorId);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of Encryptor");
            }
            _size.addBytes(16);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Encryptor)) {
                return false;
            }
            Encryptor other = (Encryptor)obj;
            if (!this.encryptorId.equals((Object)other.encryptorId)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.encryptorId.hashCode();
            return hashCode;
        }

        public Encryptor duplicate() {
            Encryptor _duplicate = new Encryptor();
            _duplicate.encryptorId = this.encryptorId;
            return _duplicate;
        }

        public String toString() {
            return "Encryptor(encryptorId=" + this.encryptorId.toString() + ")";
        }

        public Uuid encryptorId() {
            return this.encryptorId;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Encryptor setEncryptorId(Uuid v) {
            this.encryptorId = v;
            return this;
        }
    }
}

