/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;

public class UserScramCredentialRecord
implements ApiMessage {
    String name;
    byte mechanism;
    byte[] salt;
    byte[] storedKey;
    byte[] serverKey;
    int iterations;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.COMPACT_STRING, "The user name."), new Field("mechanism", (Type)Type.INT8, "The SCRAM mechanism."), new Field("salt", (Type)Type.COMPACT_BYTES, "A random salt generated by the client."), new Field("stored_key", (Type)Type.COMPACT_BYTES, "The key the Server uses to authenticate the Client."), new Field("server_key", (Type)Type.COMPACT_BYTES, "The key the Client uses to validate the Servers identity."), new Field("iterations", (Type)Type.INT32, "The number of iterations used in the SCRAM credential."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public UserScramCredentialRecord(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public UserScramCredentialRecord(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public UserScramCredentialRecord() {
        this.name = "";
        this.mechanism = 0;
        this.salt = Bytes.EMPTY;
        this.storedKey = Bytes.EMPTY;
        this.serverKey = Bytes.EMPTY;
        this.iterations = 0;
    }

    public short apiKey() {
        return 11;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public final void read(Readable _readable, short _version, MessageContext _context) {
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field name was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field name had invalid length " + length);
        }
        this.name = _readable.readString(length);
        this.mechanism = _readable.readByte();
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field salt was serialized as null");
        }
        byte[] newBytes = _readable.readArray(length);
        this.salt = newBytes;
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field storedKey was serialized as null");
        }
        newBytes = _readable.readArray(length);
        this.storedKey = newBytes;
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field serverKey was serialized as null");
        }
        newBytes = _readable.readArray(length);
        this.serverKey = newBytes;
        this.iterations = _readable.readInt();
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = _cache.getSerializedValue((Object)this.name);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        _writable.writeByte(this.mechanism);
        _writable.writeUnsignedVarint(this.salt.length + 1);
        _writable.writeByteArray(this.salt);
        _writable.writeUnsignedVarint(this.storedKey.length + 1);
        _writable.writeByteArray(this.storedKey);
        _writable.writeUnsignedVarint(this.serverKey.length + 1);
        _writable.writeByteArray(this.serverKey);
        _writable.writeInt(this.iterations);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'name' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.name, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        _size.addBytes(1);
        _size.addBytes(this.salt.length);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.salt.length + 1)));
        _size.addBytes(this.storedKey.length);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.storedKey.length + 1)));
        _size.addBytes(this.serverKey.length);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.serverKey.length + 1)));
        _size.addBytes(4);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UserScramCredentialRecord)) {
            return false;
        }
        UserScramCredentialRecord other = (UserScramCredentialRecord)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.mechanism != other.mechanism) {
            return false;
        }
        if (!Arrays.equals(this.salt, other.salt)) {
            return false;
        }
        if (!Arrays.equals(this.storedKey, other.storedKey)) {
            return false;
        }
        if (!Arrays.equals(this.serverKey, other.serverKey)) {
            return false;
        }
        if (this.iterations != other.iterations) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
        hashCode = 31 * hashCode + this.mechanism;
        hashCode = 31 * hashCode + Arrays.hashCode(this.salt);
        hashCode = 31 * hashCode + Arrays.hashCode(this.storedKey);
        hashCode = 31 * hashCode + Arrays.hashCode(this.serverKey);
        hashCode = 31 * hashCode + this.iterations;
        return hashCode;
    }

    public UserScramCredentialRecord duplicate() {
        UserScramCredentialRecord _duplicate = new UserScramCredentialRecord();
        _duplicate.name = this.name;
        _duplicate.mechanism = this.mechanism;
        _duplicate.salt = MessageUtil.duplicate((byte[])this.salt);
        _duplicate.storedKey = MessageUtil.duplicate((byte[])this.storedKey);
        _duplicate.serverKey = MessageUtil.duplicate((byte[])this.serverKey);
        _duplicate.iterations = this.iterations;
        return _duplicate;
    }

    public String toString() {
        return "UserScramCredentialRecord(name=" + (String)(this.name == null ? "null" : "'" + this.name.toString() + "'") + ", mechanism=" + this.mechanism + ", salt=" + Arrays.toString(this.salt) + ", storedKey=" + Arrays.toString(this.storedKey) + ", serverKey=" + Arrays.toString(this.serverKey) + ", iterations=" + this.iterations + ")";
    }

    public String name() {
        return this.name;
    }

    public byte mechanism() {
        return this.mechanism;
    }

    public byte[] salt() {
        return this.salt;
    }

    public byte[] storedKey() {
        return this.storedKey;
    }

    public byte[] serverKey() {
        return this.serverKey;
    }

    public int iterations() {
        return this.iterations;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public UserScramCredentialRecord setName(String v) {
        this.name = v;
        return this;
    }

    public UserScramCredentialRecord setMechanism(byte v) {
        this.mechanism = v;
        return this;
    }

    public UserScramCredentialRecord setSalt(byte[] v) {
        this.salt = v;
        return this;
    }

    public UserScramCredentialRecord setStoredKey(byte[] v) {
        this.storedKey = v;
        return this;
    }

    public UserScramCredentialRecord setServerKey(byte[] v) {
        this.serverKey = v;
        return this;
    }

    public UserScramCredentialRecord setIterations(int v) {
        this.iterations = v;
        return this;
    }
}

