/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import java.util.function.Function;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.metrics.ConfluentControllerMetrics;
import org.apache.kafka.controller.metrics.ConfluentControllerMetricsCache;
import org.apache.kafka.controller.metrics.ConfluentControllerMetricsChanges;
import org.apache.kafka.image.ConfigurationsDelta;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.server.fault.FaultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluentControllerMetricsPublisher
implements MetadataPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(ConfluentControllerMetricsChanges.class);
    private final ConfluentControllerMetrics metrics;
    private ConfluentControllerMetricsCache cache;
    private Logger log;
    private long numSnapshotLoads;

    public ConfluentControllerMetricsPublisher(ConfluentControllerMetrics metrics, FaultHandler faultHandler, Function<String, String> topicNameToTenant, int nodeId, int staticDefaultMinIsr) {
        this.metrics = metrics;
        this.cache = new ConfluentControllerMetricsCache(faultHandler, topicNameToTenant, nodeId, staticDefaultMinIsr);
        this.log = new LogContext("[ConfluentControllerMetricsPublisher id=" + nodeId + "] ").logger(ConfluentControllerMetricsPublisher.class);
        this.numSnapshotLoads = 0L;
    }

    @Override
    public String name() {
        return "ConfluentControllerMetricsPublisher";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        switch (manifest.type()) {
            case LOG_DELTA: {
                try {
                    this.publishDelta(newImage, delta);
                    break;
                }
                catch (Throwable e) {
                    this.cache.faultHandler().handleFault("Failed to publish Confluent controller metrics from log delta ending at offset " + manifest.provenance().lastContainedOffset(), e);
                    break;
                }
                finally {
                    this.cache.setPrevImage(newImage);
                }
            }
            case SNAPSHOT: {
                try {
                    this.publishSnapshot(newImage);
                    break;
                }
                catch (Throwable e) {
                    this.cache.faultHandler().handleFault("Failed to publish Confluent controller metrics from " + manifest.provenance().snapshotName(), e);
                    break;
                }
                finally {
                    this.cache.setPrevImage(newImage);
                }
            }
        }
    }

    private void publishDelta(MetadataImage newImage, MetadataDelta delta) {
        if (this.cache.firstPublish()) {
            this.log.info("Publishing initial Confluent cluster metrics.");
            this.publishSnapshot(newImage);
            return;
        }
        ConfigurationsDelta configsDelta = delta.configsDelta();
        TopicsDelta topicsDelta = delta.topicsDelta();
        if (configsDelta == null && topicsDelta == null) {
            return;
        }
        ConfluentControllerMetricsChanges changes = new ConfluentControllerMetricsChanges(this.cache);
        if (configsDelta != null && changes.handleConfigsChanges(newImage, configsDelta)) {
            this.log.info("Detected change to node or cluster level {}. Reloading metrics from metadata image.", (Object)ServerLogConfigs.MIN_IN_SYNC_REPLICAS_CONFIG);
            this.publishSnapshot(newImage);
            return;
        }
        if (topicsDelta != null) {
            changes.handleTopicsChanges(newImage, topicsDelta);
        }
        changes.applyDelta(this.metrics);
    }

    private void publishSnapshot(MetadataImage newImage) {
        ConfluentControllerMetricsChanges changes = new ConfluentControllerMetricsChanges(this.cache);
        changes.loadImage(newImage);
        changes.applyFullState(this.metrics);
        ++this.numSnapshotLoads;
        this.cache.setFirstPublish(false);
    }

    long numSnapshotLoads() {
        return this.numSnapshotLoads;
    }

    @Override
    public void close() {
        this.metrics.close();
    }
}

