/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.CellMigrationState;
import org.apache.kafka.common.metadata.CellMigrationRecord;
import org.apache.kafka.common.metadata.CellRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.node.CellImageNode;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public class CellImage {
    public static final CellImage EMPTY = new CellImage(Map.of(), CellMigrationState.INACTIVE.code());
    private final Map<Integer, Cell> cellIdToCell;
    private final byte cellMigrationState;

    public CellImage(Map<Integer, Cell> cellIdToCell, byte cellMigrationState) {
        this.cellIdToCell = Collections.unmodifiableMap(cellIdToCell);
        this.cellMigrationState = cellMigrationState;
    }

    public Optional<List<Integer>> k2Brokers() {
        if (this.cellIdToCell.containsKey(1000)) {
            return Optional.of(this.cellIdToCell.get(1000).brokersList());
        }
        return Optional.empty();
    }

    public Map<Integer, Cell> cellIdToCell() {
        return this.cellIdToCell;
    }

    public byte cellMigrationState() {
        return this.cellMigrationState;
    }

    public int getBrokerCellId(int brokerId) {
        for (Cell cell : this.cellIdToCell.values()) {
            if (!cell.brokers().contains(brokerId)) continue;
            return cell.cellId();
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.cellIdToCell.isEmpty() && this.cellMigrationState == CellMigrationState.INACTIVE.code();
    }

    public void write(ImageWriter writer, ImageWriterOptions options) {
        for (Cell cell : this.cellIdToCell.values()) {
            writer.write(new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(cell.cellId()).setState(cell.state().code()).setMinSize(cell.minSize()).setMaxSize(cell.maxSize()).setBrokers(cell.brokersList()), MetadataRecordType.CELL_RECORD.highestSupportedVersion()));
        }
        if (options.metadataVersion().isCellMigrationSupported()) {
            writer.write(new ApiMessageAndVersion((ApiMessage)new CellMigrationRecord().setState(this.cellMigrationState), MetadataRecordType.CELL_MIGRATION_RECORD.highestSupportedVersion()));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CellImage that = (CellImage)o;
        return Objects.equals(this.cellIdToCell, that.cellIdToCell()) && this.cellMigrationState == that.cellMigrationState();
    }

    public int hashCode() {
        return Objects.hash(this.cellIdToCell, this.cellMigrationState);
    }

    public String toString() {
        return new CellImageNode(this).stringify();
    }
}

