/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.RemoveClusterLinkRecord;
import org.apache.kafka.common.metadata.RemoveTopicRecord;
import org.apache.kafka.image.ConfigurationDelta;
import org.apache.kafka.image.ConfigurationImage;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.server.common.MetadataVersion;

public final class ConfigurationsDelta {
    private final ConfigurationsImage image;
    private final Map<ConfigResource, ConfigurationDelta> changes = new HashMap<ConfigResource, ConfigurationDelta>();

    public ConfigurationsDelta(ConfigurationsImage image) {
        this.image = image;
    }

    public Map<ConfigResource, ConfigurationDelta> changes() {
        return this.changes;
    }

    public void finishSnapshot() {
        for (Map.Entry<ConfigResource, ConfigurationImage> entry : this.image.resourceData().entrySet()) {
            ConfigResource resource = entry.getKey();
            ConfigurationImage configImage = entry.getValue();
            ConfigurationDelta configDelta = this.changes.computeIfAbsent(resource, __ -> new ConfigurationDelta(configImage));
            configDelta.finishSnapshot();
        }
    }

    public void handleMetadataVersionChange(MetadataVersion newVersion) {
    }

    public void replay(ConfigRecord record) {
        ConfigResource resource = new ConfigResource(ConfigResource.Type.forId((byte)record.resourceType()), record.resourceName());
        ConfigurationImage configImage = this.image.resourceData().getOrDefault(resource, new ConfigurationImage(resource, Map.of()));
        ConfigurationDelta delta = this.changes.computeIfAbsent(resource, __ -> new ConfigurationDelta(configImage));
        delta.replay(record);
    }

    public void replay(RemoveTopicRecord record, String topicName) {
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topicName);
        if (this.image.resourceData().containsKey(resource)) {
            ConfigurationImage configImage = this.image.resourceData().get(resource);
            ConfigurationDelta delta = this.changes.computeIfAbsent(resource, __ -> new ConfigurationDelta(configImage));
            delta.deleteAll();
        }
    }

    public void replay(RemoveClusterLinkRecord record) {
        ConfigResource resource = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, record.clusterLinkId().toString());
        ConfigurationImage configImage = this.image.resourceData().getOrDefault(resource, new ConfigurationImage(resource, Map.of()));
        ConfigurationDelta delta = this.changes.computeIfAbsent(resource, __ -> new ConfigurationDelta(configImage));
        delta.deleteAll();
    }

    public ConfigurationsImage apply() {
        HashMap<ConfigResource, ConfigurationImage> newData = new HashMap<ConfigResource, ConfigurationImage>();
        for (Map.Entry<ConfigResource, ConfigurationImage> entry : this.image.resourceData().entrySet()) {
            ConfigResource resource = entry.getKey();
            ConfigurationDelta delta = this.changes.get(resource);
            if (delta == null) {
                newData.put(resource, entry.getValue());
                continue;
            }
            ConfigurationImage newImage = delta.apply();
            if (newImage.isEmpty()) continue;
            newData.put(resource, newImage);
        }
        for (Map.Entry<ConfigResource, Object> entry : this.changes.entrySet()) {
            ConfigurationImage newImage;
            if (newData.containsKey(entry.getKey()) || (newImage = ((ConfigurationDelta)entry.getValue()).apply()).isEmpty()) continue;
            newData.put(entry.getKey(), newImage);
        }
        return new ConfigurationsImage(newData);
    }

    public Map<String, String> getChangesMatching(ConfigResource resource, Set<String> keys) {
        HashMap<String, String> configChanges = new HashMap<String, String>();
        if (!this.changes.containsKey(resource)) {
            return Map.of();
        }
        ConfigurationDelta delta = this.changes().get(resource);
        for (String key : keys) {
            Optional<String> config = delta.find(key);
            if (config == null || !config.isPresent()) continue;
            configChanges.put(key, config.get());
        }
        return Collections.unmodifiableMap(configChanges);
    }

    public String toString() {
        return "ConfigurationsDelta(changes=" + String.valueOf(this.changes) + ")";
    }
}

