/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.node.TopicsImageByNameNode;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.server.immutable.ImmutableMap;
import org.apache.kafka.server.immutable.ImmutableSet;
import org.apache.kafka.server.util.TranslatedValueMapView;

public final class TopicsImage {
    public static final TopicsImage EMPTY = new TopicsImage((ImmutableMap<Uuid, TopicImage>)ImmutableMap.empty(), (ImmutableMap<String, TopicImage>)ImmutableMap.empty(), (ImmutableMap<String, ImmutableSet<String>>)ImmutableMap.empty(), (ImmutableMap<Uuid, ImmutableMap<Uuid, TopicImage>>)ImmutableMap.empty());
    private final ImmutableMap<Uuid, TopicImage> topicsById;
    private final ImmutableMap<String, TopicImage> topicsByName;
    private final ImmutableMap<String, ImmutableSet<String>> topicNamesByTenant;
    private final ImmutableMap<Uuid, ImmutableMap<Uuid, TopicImage>> topicsByLinkId;

    public TopicsImage(ImmutableMap<Uuid, TopicImage> topicsById, ImmutableMap<String, TopicImage> topicsByName, ImmutableMap<String, ImmutableSet<String>> topicNamesByTenant, ImmutableMap<Uuid, ImmutableMap<Uuid, TopicImage>> topicsByLinkId) {
        this.topicsById = topicsById;
        this.topicsByName = topicsByName;
        this.topicNamesByTenant = topicNamesByTenant;
        this.topicsByLinkId = topicsByLinkId;
    }

    public TopicsImage including(TopicImage topic, Function<String, String> nameToTenantCallback) {
        ImmutableMap<String, ImmutableSet<String>> newTopicNamesByTenant = this.topicNamesByTenant;
        String tenant = nameToTenantCallback.apply(topic.name());
        if (tenant != null) {
            newTopicNamesByTenant = TopicsDelta.addTo(newTopicNamesByTenant, tenant, topic.name());
        }
        ImmutableMap<Uuid, ImmutableMap<Uuid, TopicImage>> newTopicsByLinkId = this.topicsByLinkId;
        if (topic.mirrorTopic().isPresent()) {
            newTopicsByLinkId = TopicsDelta.addTo(newTopicsByLinkId, topic.mirrorTopic().get().linkId(), topic);
        }
        return new TopicsImage((ImmutableMap<Uuid, TopicImage>)this.topicsById.updated((Object)topic.id(), (Object)topic), (ImmutableMap<String, TopicImage>)this.topicsByName.updated((Object)topic.name(), (Object)topic), newTopicNamesByTenant, newTopicsByLinkId);
    }

    public boolean isEmpty() {
        return this.topicsById.isEmpty() && this.topicsByName.isEmpty();
    }

    public ImmutableMap<Uuid, TopicImage> topicsById() {
        return this.topicsById;
    }

    public ImmutableMap<String, TopicImage> topicsByName() {
        return this.topicsByName;
    }

    public ImmutableMap<String, ImmutableSet<String>> topicNamesByTenant() {
        return this.topicNamesByTenant;
    }

    public ImmutableMap<Uuid, ImmutableMap<Uuid, TopicImage>> topicsByLinkId() {
        return this.topicsByLinkId;
    }

    public ImmutableSet<String> topicsByTenant(String tenant) {
        return (ImmutableSet)this.topicNamesByTenant.getOrDefault((Object)tenant, (Object)ImmutableSet.empty());
    }

    public ImmutableMap<Uuid, TopicImage> topicsByLinkId(Uuid linkId) {
        return (ImmutableMap)this.topicsByLinkId.getOrDefault((Object)linkId, (Object)ImmutableMap.empty());
    }

    public PartitionRegistration getPartition(Uuid id, int partitionId) {
        TopicImage topicImage = (TopicImage)this.topicsById.get((Object)id);
        if (topicImage == null) {
            return null;
        }
        return topicImage.partitions().get(partitionId);
    }

    public TopicImage getTopic(Uuid id) {
        return (TopicImage)this.topicsById.get((Object)id);
    }

    public TopicImage getTopic(String name) {
        return (TopicImage)this.topicsByName.get((Object)name);
    }

    public void write(ImageWriter writer, ImageWriterOptions options) {
        for (Map.Entry entry : this.topicsById.entrySet()) {
            ((TopicImage)entry.getValue()).write(writer, options);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof TopicsImage)) {
            return false;
        }
        TopicsImage other = (TopicsImage)o;
        boolean topicsByLinkIdEqual = true;
        if (this.topicsByLinkId.size() != other.topicsByLinkId.size()) {
            topicsByLinkIdEqual = false;
        } else {
            for (Map.Entry entry : this.topicsByLinkId.entrySet()) {
                ImmutableMap otherImages;
                Uuid linkID = (Uuid)entry.getKey();
                ImmutableMap images = (ImmutableMap)entry.getValue();
                if (images.equals((Object)(otherImages = (ImmutableMap)other.topicsByLinkId.get((Object)linkID)))) continue;
                topicsByLinkIdEqual = false;
                break;
            }
        }
        return this.topicsById.equals(other.topicsById) && this.topicsByName.equals(other.topicsByName) && this.topicNamesByTenant.equals(other.topicNamesByTenant) && topicsByLinkIdEqual;
    }

    public int hashCode() {
        return Objects.hash(this.topicsById, this.topicsByName, this.topicNamesByTenant, this.topicsByLinkId);
    }

    public Map<String, Uuid> topicNameToIdView() {
        return new TranslatedValueMapView(this.topicsByName, TopicImage::id);
    }

    public Map<Uuid, String> topicIdToNameView() {
        return new TranslatedValueMapView(this.topicsById, TopicImage::name);
    }

    public String toString() {
        return new TopicsImageByNameNode(this).stringify();
    }
}

