/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.ClusterLinkRecord;
import org.apache.kafka.metadata.ClusterLinkSwitchoverMetadata;

public class ClusterLink {
    private final String linkName;
    private final Uuid linkId;
    private final Optional<String> tenantPrefix;
    private final String remoteClusterId;
    private final ClusterLinkConfig.LinkMode linkMode;
    private final Optional<ClusterLinkSwitchoverMetadata> switchoverMetadata;

    public ClusterLink(ClusterLinkRecord record) {
        this.linkName = record.clusterLinkName();
        this.linkId = record.clusterLinkId();
        this.tenantPrefix = Optional.ofNullable(record.tenantPrefix());
        this.remoteClusterId = record.remoteClusterId();
        this.linkMode = ClusterLinkConfig.LinkMode.fromString((String)record.linkMode());
        this.switchoverMetadata = record.switchoverMetadata() != null ? Optional.of(new ClusterLinkSwitchoverMetadata(record.switchoverMetadata())) : Optional.empty();
    }

    public ClusterLink(String linkName, Uuid linkId, String tenantPrefix, String remoteClusterId, String linkMode) {
        this(linkName, linkId, tenantPrefix, remoteClusterId, linkMode, null);
    }

    public ClusterLink(String linkName, Uuid linkId, String tenantPrefix, String remoteClusterId, String linkMode, ClusterLinkSwitchoverMetadata switchoverMetadata) {
        this.linkName = linkName;
        this.linkId = linkId;
        this.tenantPrefix = Optional.ofNullable(tenantPrefix);
        this.remoteClusterId = remoteClusterId;
        this.linkMode = ClusterLinkConfig.LinkMode.fromString((String)linkMode);
        this.switchoverMetadata = Optional.ofNullable(switchoverMetadata);
    }

    public String linkName() {
        return this.linkName;
    }

    public Uuid linkId() {
        return this.linkId;
    }

    public Optional<String> tenantPrefix() {
        return this.tenantPrefix;
    }

    public String remoteClusterId() {
        return this.remoteClusterId;
    }

    public ClusterLinkConfig.LinkMode linkMode() {
        return this.linkMode;
    }

    public Optional<ClusterLinkSwitchoverMetadata> switchoverMetadata() {
        return this.switchoverMetadata;
    }

    public ClusterLinkRecord toRecord() {
        ClusterLinkRecord clusterLinkRecord = new ClusterLinkRecord().setClusterLinkName(this.linkName).setClusterLinkId(this.linkId).setRemoteClusterId(this.remoteClusterId).setTenantPrefix(this.tenantPrefix.orElse(null)).setLinkMode(this.linkMode.toString());
        this.switchoverMetadata.ifPresent(clusterLinkSwitchoverMetadata -> clusterLinkRecord.setSwitchoverMetadata(clusterLinkSwitchoverMetadata.toRecord()));
        return clusterLinkRecord;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClusterLink)) {
            return false;
        }
        ClusterLink other = (ClusterLink)o;
        return this.linkName.equals(other.linkName) && this.linkId.equals((Object)other.linkId) && this.tenantPrefix.equals(other.tenantPrefix) && this.remoteClusterId.equals(other.remoteClusterId) && this.linkMode.equals((Object)other.linkMode) && this.switchoverMetadata.equals(other.switchoverMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.linkName, this.linkId, this.tenantPrefix, this.remoteClusterId, this.linkMode, this.switchoverMetadata);
    }

    public String toString() {
        String tenantPrefixString = this.tenantPrefix.map(s -> ", tenantPrefix=" + s).orElse("");
        return "ClusterLinkImage(linkName=" + this.linkName + ", linkId=" + String.valueOf(this.linkId) + tenantPrefixString + ", remoteClusterId=" + this.remoteClusterId + ", linkMode=" + String.valueOf(this.linkMode) + ", switchoverMetadata=" + this.switchoverMetadata.toString() + ")";
    }
}

