/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.CandidateState;
import org.apache.kafka.raft.ElectionState;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.EpochState;
import org.apache.kafka.raft.FollowerState;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.LeaderState;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.NomineeState;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.ProspectiveState;
import org.apache.kafka.raft.QuorumStateStore;
import org.apache.kafka.raft.ReplicaKey;
import org.apache.kafka.raft.ResignedState;
import org.apache.kafka.raft.UnattachedState;
import org.apache.kafka.raft.VoterSet;
import org.apache.kafka.raft.internals.BatchAccumulator;
import org.apache.kafka.raft.internals.KRaftControlRecordStateMachine;
import org.apache.kafka.raft.internals.KafkaRaftMetrics;
import org.slf4j.Logger;

public class QuorumState {
    private final OptionalInt localId;
    private final Uuid localDirectoryId;
    private final Time time;
    private final Logger log;
    private final QuorumStateStore store;
    private final KRaftControlRecordStateMachine partitionState;
    private final Endpoints localListeners;
    private final SupportedVersionRange localSupportedKRaftVersion;
    private final Random random;
    private final int electionTimeoutMs;
    private final int fetchTimeoutMs;
    private final LogContext logContext;
    private final KafkaRaftMetrics kafkaRaftMetrics;
    private volatile EpochState state;

    public QuorumState(OptionalInt localId, Uuid localDirectoryId, KRaftControlRecordStateMachine partitionState, Endpoints localListeners, SupportedVersionRange localSupportedKRaftVersion, int electionTimeoutMs, int fetchTimeoutMs, QuorumStateStore store, Time time, LogContext logContext, Random random, KafkaRaftMetrics kafkaRaftMetrics) {
        this.localId = localId;
        this.localDirectoryId = localDirectoryId;
        this.partitionState = partitionState;
        this.localListeners = localListeners;
        this.localSupportedKRaftVersion = localSupportedKRaftVersion;
        this.electionTimeoutMs = electionTimeoutMs;
        this.fetchTimeoutMs = fetchTimeoutMs;
        this.store = store;
        this.time = time;
        this.log = logContext.logger(QuorumState.class);
        this.random = random;
        this.logContext = logContext;
        this.kafkaRaftMetrics = kafkaRaftMetrics;
    }

    private ElectionState readElectionState() {
        ElectionState election = this.store.readElectionState().orElseGet(() -> ElectionState.withUnknownLeader(0, this.partitionState.lastVoterSet().voterIds()));
        return election;
    }

    public void initialize(OffsetAndEpoch logEndOffsetAndEpoch) throws IllegalStateException {
        EpochState initialState;
        ElectionState election = this.readElectionState();
        if (election.hasVoted() && this.localId.isEmpty()) {
            throw new IllegalStateException(String.format("Initialized quorum state (%s) with a voted candidate but without a local id", election));
        }
        if (election.epoch() < logEndOffsetAndEpoch.epoch()) {
            this.log.warn("Epoch from quorum store file ({}) is {}, which is smaller than last written epoch {} in the log", new Object[]{this.store.path(), election.epoch(), logEndOffsetAndEpoch.epoch()});
            initialState = new UnattachedState(this.time, logEndOffsetAndEpoch.epoch(), OptionalInt.empty(), Optional.empty(), this.partitionState.lastVoterSet().voterIds(), Optional.empty(), this.randomElectionTimeoutMs(), this.logContext);
        } else if (this.localId.isPresent() && election.isLeader(this.localId.getAsInt())) {
            initialState = new ResignedState(this.time, this.localId.getAsInt(), election.epoch(), this.partitionState.lastVoterSet().voterIds(), this.randomElectionTimeoutMs(), Collections.emptyList(), this.localListeners, this.logContext);
        } else if (this.localId.isPresent() && election.isVotedCandidate(ReplicaKey.of(this.localId.getAsInt(), this.localDirectoryId))) {
            initialState = new CandidateState(this.time, this.localId.getAsInt(), this.localDirectoryId, election.epoch(), this.partitionState.lastVoterSet(), Optional.empty(), 1, this.randomElectionTimeoutMs(), this.logContext);
        } else if (election.hasLeader()) {
            VoterSet voters = this.partitionState.lastVoterSet();
            Endpoints leaderEndpoints = voters.listeners(election.leaderId());
            if (leaderEndpoints.isEmpty()) {
                this.log.info("The leader in election state {} is not a member of the latest voter set {}; transitioning to unattached instead of follower because the leader's endpoints are not known", (Object)election, (Object)voters);
                initialState = new UnattachedState(this.time, election.epoch(), OptionalInt.of(election.leaderId()), election.optionalVotedKey(), this.partitionState.lastVoterSet().voterIds(), Optional.empty(), this.randomElectionTimeoutMs(), this.logContext);
            } else {
                initialState = new FollowerState(this.time, election.epoch(), election.leaderId(), leaderEndpoints, election.optionalVotedKey(), voters.voterIds(), Optional.empty(), this.fetchTimeoutMs, this.logContext);
            }
        } else {
            initialState = new UnattachedState(this.time, election.epoch(), OptionalInt.empty(), election.optionalVotedKey(), this.partitionState.lastVoterSet().voterIds(), Optional.empty(), this.randomElectionTimeoutMs(), this.logContext);
        }
        this.durableTransitionTo(initialState);
    }

    public Set<Integer> voters() {
        return this.partitionState.lastVoterSet().voterIds();
    }

    public boolean isOnlyVoter() {
        return this.localId.isPresent() && this.partitionState.lastVoterSet().isOnlyVoter(ReplicaKey.of(this.localId.getAsInt(), this.localDirectoryId));
    }

    public int localIdOrSentinel() {
        return this.localId.orElse(-1);
    }

    public int localIdOrThrow() {
        return this.localId.orElseThrow(() -> new IllegalStateException("Required local id is not present"));
    }

    public OptionalInt localId() {
        return this.localId;
    }

    public Uuid localDirectoryId() {
        return this.localDirectoryId;
    }

    public ReplicaKey localReplicaKeyOrThrow() {
        return ReplicaKey.of(this.localIdOrThrow(), this.localDirectoryId());
    }

    public VoterSet.VoterNode localVoterNodeOrThrow() {
        return VoterSet.VoterNode.of(this.localReplicaKeyOrThrow(), this.localListeners, this.localSupportedKRaftVersion);
    }

    public int epoch() {
        return this.state.epoch();
    }

    public int leaderIdOrSentinel() {
        return this.state.election().leaderIdOrSentinel();
    }

    public Optional<LogOffsetMetadata> highWatermark() {
        return this.state.highWatermark();
    }

    public OptionalInt leaderId() {
        ElectionState election = this.state.election();
        if (election.hasLeader()) {
            return OptionalInt.of(this.state.election().leaderId());
        }
        return OptionalInt.empty();
    }

    public Optional<ReplicaKey> votedKey() {
        return this.state.election().optionalVotedKey();
    }

    public boolean hasLeader() {
        return this.leaderId().isPresent();
    }

    public boolean hasRemoteLeader() {
        return this.hasLeader() && this.leaderIdOrSentinel() != this.localIdOrSentinel();
    }

    public Endpoints leaderEndpoints() {
        return this.state.leaderEndpoints();
    }

    public boolean isVoter() {
        if (this.localId.isEmpty()) {
            return false;
        }
        return this.partitionState.lastVoterSet().isVoter(ReplicaKey.of(this.localId.getAsInt(), this.localDirectoryId));
    }

    public boolean isVoter(ReplicaKey nodeKey) {
        return this.partitionState.lastVoterSet().isVoter(nodeKey);
    }

    public boolean isObserver() {
        return !this.isVoter();
    }

    public void transitionToResigned(List<ReplicaKey> preferredSuccessors) {
        if (!this.isLeader()) {
            throw new IllegalStateException("Invalid transition to Resigned state from " + String.valueOf(this.state));
        }
        int epoch = this.state.epoch();
        this.memoryTransitionTo(new ResignedState(this.time, this.localIdOrThrow(), epoch, this.partitionState.lastVoterSet().voterIds(), this.randomElectionTimeoutMs(), preferredSuccessors, this.localListeners, this.logContext));
    }

    public void transitionToUnattached(int epoch, OptionalInt leaderId) {
        int currentEpoch = this.state.epoch();
        if (epoch < currentEpoch || epoch == currentEpoch && !this.isProspective()) {
            throw new IllegalStateException(String.format("Cannot transition to Unattached with epoch %d from current state %s", epoch, this.state));
        }
        long electionTimeoutMs = this.isObserver() ? Long.MAX_VALUE : (this.isCandidate() ? this.candidateStateOrThrow().remainingElectionTimeMs(this.time.milliseconds()) : (this.isUnattached() ? this.unattachedStateOrThrow().remainingElectionTimeMs(this.time.milliseconds()) : (this.isProspective() && !this.prospectiveStateOrThrow().epochElection().isVoteRejected() ? this.prospectiveStateOrThrow().remainingElectionTimeMs(this.time.milliseconds()) : (this.isResigned() ? this.resignedStateOrThrow().remainingElectionTimeMs(this.time.milliseconds()) : (long)this.randomElectionTimeoutMs()))));
        Optional<ReplicaKey> votedKey = epoch == currentEpoch ? this.votedKey() : Optional.empty();
        this.durableTransitionTo(new UnattachedState(this.time, epoch, leaderId, votedKey, this.partitionState.lastVoterSet().voterIds(), this.state.highWatermark(), electionTimeoutMs, this.logContext));
    }

    public void unattachedAddVotedState(int epoch, ReplicaKey candidateKey) {
        int currentEpoch = this.state.epoch();
        if (this.localId.isPresent() && candidateKey.id() == this.localId.getAsInt()) {
            throw new IllegalStateException(String.format("Cannot add voted key (%s) to current state (%s) in epoch %d since it matches the local broker.id", candidateKey, this.state, epoch));
        }
        if (this.localId.isEmpty()) {
            throw new IllegalStateException("Cannot add voted state without a replica id");
        }
        if (epoch != currentEpoch || !this.isUnattachedNotVoted()) {
            throw new IllegalStateException(String.format("Cannot add voted key (%s) to current state (%s) in epoch %d", candidateKey, this.state, epoch));
        }
        this.durableTransitionTo(new UnattachedState(this.time, epoch, this.state.election().optionalLeaderId(), Optional.of(candidateKey), this.partitionState.lastVoterSet().voterIds(), this.state.highWatermark(), this.randomElectionTimeoutMs(), this.logContext));
    }

    public void prospectiveAddVotedState(int epoch, ReplicaKey candidateKey) {
        int currentEpoch = this.state.epoch();
        if (this.localId.isPresent() && candidateKey.id() == this.localId.getAsInt()) {
            throw new IllegalStateException(String.format("Cannot add voted key (%s) to current state (%s) in epoch %d since it matches the local broker.id", candidateKey, this.state, epoch));
        }
        if (this.localId.isEmpty()) {
            throw new IllegalStateException("Cannot add voted state without a replica id");
        }
        if (epoch != currentEpoch || !this.isProspectiveNotVoted()) {
            throw new IllegalStateException(String.format("Cannot add voted key (%s) to current state (%s) in epoch %d", candidateKey, this.state, epoch));
        }
        ProspectiveState prospectiveState = this.prospectiveStateOrThrow();
        this.durableTransitionTo(new ProspectiveState(this.time, this.localIdOrThrow(), epoch, this.state.election().optionalLeaderId(), this.state.leaderEndpoints(), Optional.of(candidateKey), this.partitionState.lastVoterSet(), this.state.highWatermark(), prospectiveState.retries(), this.randomElectionTimeoutMs(), this.logContext));
    }

    public void transitionToFollower(int epoch, int leaderId, Endpoints endpoints) {
        int currentEpoch = this.state.epoch();
        if (endpoints.isEmpty()) {
            throw new IllegalArgumentException(String.format("Cannot transition to Follower with leader %s and epoch %s without a leader endpoint", leaderId, epoch));
        }
        if (this.localId.isPresent() && leaderId == this.localId.getAsInt()) {
            throw new IllegalStateException(String.format("Cannot transition to Follower with leader %s and epoch %s since it matches the local node.id %s", leaderId, epoch, this.localId));
        }
        if (epoch < currentEpoch) {
            throw new IllegalStateException(String.format("Cannot transition to Follower with leader %s and epoch %s since the current epoch %s is larger", leaderId, epoch, currentEpoch));
        }
        if (epoch == currentEpoch) {
            if (this.isFollower() && this.state.leaderEndpoints().size() >= endpoints.size()) {
                throw new IllegalStateException(String.format("Cannot transition to Follower with leader %s, epoch %s and endpoints %s from state %s", leaderId, epoch, endpoints, this.state));
            }
            if (this.isLeader()) {
                throw new IllegalStateException(String.format("Cannot transition to Follower with leader %s and epoch %s from state %s", leaderId, epoch, this.state));
            }
        }
        Optional<ReplicaKey> votedKey = epoch == currentEpoch ? this.votedKey() : Optional.empty();
        this.durableTransitionTo(new FollowerState(this.time, epoch, leaderId, endpoints, votedKey, this.partitionState.lastVoterSet().voterIds(), this.state.highWatermark(), this.fetchTimeoutMs, this.logContext));
    }

    public void transitionToProspective() {
        if (this.isObserver()) {
            throw new IllegalStateException(String.format("Cannot transition to Prospective since the local id (%s) and directory id (%s) is not one of the voters %s", this.localId, this.localDirectoryId, this.partitionState.lastVoterSet()));
        }
        if (this.isLeader() || this.isProspective()) {
            throw new IllegalStateException("Cannot transition to Prospective since the local broker.id=" + String.valueOf(this.localId) + " is state " + String.valueOf(this.state));
        }
        int retries = this.isCandidate() ? this.candidateStateOrThrow().retries() + 1 : 1;
        this.memoryTransitionTo(new ProspectiveState(this.time, this.localIdOrThrow(), this.epoch(), this.leaderId(), this.state.leaderEndpoints(), this.votedKey(), this.partitionState.lastVoterSet(), this.state.highWatermark(), retries, this.randomElectionTimeoutMs(), this.logContext));
    }

    public void transitionToCandidate() {
        this.checkValidTransitionToCandidate();
        int newEpoch = this.epoch() + 1;
        int electionTimeoutMs = this.randomElectionTimeoutMs();
        int retries = this.isProspective() ? this.prospectiveStateOrThrow().retries() : 1;
        this.durableTransitionTo(new CandidateState(this.time, this.localIdOrThrow(), this.localDirectoryId, newEpoch, this.partitionState.lastVoterSet(), this.state.highWatermark(), retries, electionTimeoutMs, this.logContext));
    }

    private void checkValidTransitionToCandidate() {
        if (this.isObserver()) {
            throw new IllegalStateException(String.format("Cannot transition to Candidate since the local id (%s) and directory id (%s) is not one of the voters %s", this.localId, this.localDirectoryId, this.partitionState.lastVoterSet()));
        }
        if (!this.isProspective()) {
            throw new IllegalStateException(String.format("Cannot transition to Candidate since the local broker.id=%s is state %s", this.localId, this.state));
        }
    }

    public <T> LeaderState<T> transitionToLeader(long epochStartOffset, BatchAccumulator<T> accumulator) {
        if (this.isObserver()) {
            throw new IllegalStateException(String.format("Cannot transition to Leader since the local id (%s) and directory id (%s) is not one of the voters %s", this.localId, this.localDirectoryId, this.partitionState.lastVoterSet()));
        }
        if (!this.isCandidate()) {
            throw new IllegalStateException("Cannot transition to Leader from current state " + String.valueOf(this.state));
        }
        CandidateState candidateState = this.candidateStateOrThrow();
        if (!candidateState.epochElection().isVoteGranted()) {
            throw new IllegalStateException("Cannot become leader without majority votes granted");
        }
        LeaderState<T> state = new LeaderState<T>(this.time, this.localVoterNodeOrThrow(), this.epoch(), epochStartOffset, this.partitionState.lastVoterSet(), this.partitionState.lastVoterSetOffset(), this.partitionState.lastKraftVersion(), candidateState.epochElection().grantingVoters(), accumulator, this.fetchTimeoutMs, this.logContext, this.kafkaRaftMetrics);
        this.durableTransitionTo(state);
        return state;
    }

    private void durableTransitionTo(EpochState newState) {
        this.log.info("Attempting durable transition to {} from {}", (Object)newState, (Object)this.state);
        this.store.writeElectionState(newState.election(), this.partitionState.lastKraftVersion());
        this.memoryTransitionTo(newState);
    }

    private void memoryTransitionTo(EpochState newState) {
        if (this.state != null) {
            try {
                this.state.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to transition from " + this.state.name() + " to " + newState.name(), e);
            }
        }
        EpochState from = this.state;
        this.state = newState;
        this.log.info("Completed transition to {} from {}", (Object)newState, (Object)from);
    }

    private int randomElectionTimeoutMs() {
        if (this.electionTimeoutMs == 0) {
            return 0;
        }
        return this.electionTimeoutMs + this.random.nextInt(this.electionTimeoutMs);
    }

    public boolean canGrantVote(ReplicaKey replicaKey, boolean isLogUpToDate, boolean isPreVote) {
        return this.state.canGrantVote(replicaKey, isLogUpToDate, isPreVote);
    }

    public FollowerState followerStateOrThrow() {
        if (this.isFollower()) {
            return (FollowerState)this.state;
        }
        throw new IllegalStateException("Expected to be Follower, but the current state is " + String.valueOf(this.state));
    }

    public Optional<UnattachedState> maybeUnattachedState() {
        EpochState fixedState = this.state;
        if (fixedState instanceof UnattachedState) {
            return Optional.of((UnattachedState)fixedState);
        }
        return Optional.empty();
    }

    public UnattachedState unattachedStateOrThrow() {
        return this.maybeUnattachedState().orElseThrow(() -> new IllegalStateException("Expected to be Unattached, but current state is " + String.valueOf(this.state)));
    }

    public <T> LeaderState<T> leaderStateOrThrow() {
        return this.maybeLeaderState().orElseThrow(() -> new IllegalStateException("Expected to be Leader, but current state is " + String.valueOf(this.state)));
    }

    public <T> Optional<LeaderState<T>> maybeLeaderState() {
        EpochState fixedState = this.state;
        if (fixedState instanceof LeaderState) {
            return Optional.of((LeaderState)fixedState);
        }
        return Optional.empty();
    }

    public ResignedState resignedStateOrThrow() {
        if (this.isResigned()) {
            return (ResignedState)this.state;
        }
        throw new IllegalStateException("Expected to be Resigned, but current state is " + String.valueOf(this.state));
    }

    public Optional<ProspectiveState> maybeProspectiveState() {
        EpochState fixedState = this.state;
        if (fixedState instanceof ProspectiveState) {
            return Optional.of((ProspectiveState)fixedState);
        }
        return Optional.empty();
    }

    public ProspectiveState prospectiveStateOrThrow() {
        return this.maybeProspectiveState().orElseThrow(() -> new IllegalStateException("Expected to be Prospective, but current state is " + String.valueOf(this.state)));
    }

    public boolean isProspectiveNotVoted() {
        return this.maybeProspectiveState().filter(prospective -> prospective.votedKey().isEmpty()).isPresent();
    }

    public boolean isProspectiveAndVoted() {
        return this.maybeProspectiveState().flatMap(ProspectiveState::votedKey).isPresent();
    }

    public CandidateState candidateStateOrThrow() {
        if (this.isCandidate()) {
            return (CandidateState)this.state;
        }
        throw new IllegalStateException("Expected to be Candidate, but current state is " + String.valueOf(this.state));
    }

    public NomineeState nomineeStateOrThrow() {
        if (this.isNomineeState()) {
            return (NomineeState)this.state;
        }
        throw new IllegalStateException("Expected to be a NomineeState (Prospective or Candidate), but current state is " + String.valueOf(this.state));
    }

    public LeaderAndEpoch leaderAndEpoch() {
        ElectionState election = this.state.election();
        return new LeaderAndEpoch(election.optionalLeaderId(), election.epoch());
    }

    public boolean isFollower() {
        return this.state instanceof FollowerState;
    }

    public boolean isUnattached() {
        return this.state instanceof UnattachedState;
    }

    public boolean isUnattachedNotVoted() {
        return this.maybeUnattachedState().filter(unattached -> unattached.votedKey().isEmpty()).isPresent();
    }

    public boolean isUnattachedAndVoted() {
        return this.maybeUnattachedState().flatMap(UnattachedState::votedKey).isPresent();
    }

    public boolean isLeader() {
        return this.state instanceof LeaderState;
    }

    public boolean isResigned() {
        return this.state instanceof ResignedState;
    }

    public boolean isProspective() {
        return this.state instanceof ProspectiveState;
    }

    public boolean isCandidate() {
        return this.state instanceof CandidateState;
    }

    public boolean isNomineeState() {
        return this.state instanceof NomineeState;
    }

    public static boolean unattachedOrProspectiveCanGrantVote(OptionalInt leaderId, Optional<ReplicaKey> votedKey, int epoch, ReplicaKey replicaKey, boolean isLogUpToDate, boolean isPreVote, Logger log) {
        if (isPreVote) {
            if (!isLogUpToDate) {
                log.debug("Rejecting Vote request (preVote=true) from prospective ({}) since prospective's log is not up to date with us", (Object)replicaKey);
            }
            return isLogUpToDate;
        }
        if (votedKey.isPresent()) {
            ReplicaKey votedReplicaKey = votedKey.get();
            if (votedReplicaKey.id() == replicaKey.id()) {
                return votedReplicaKey.directoryId().isEmpty() || votedReplicaKey.directoryId().equals(replicaKey.directoryId());
            }
            log.debug("Rejecting Vote request (preVote=false) from candidate ({}), already have voted for another candidate ({}) in epoch {}", new Object[]{replicaKey, votedKey, epoch});
            return false;
        }
        if (leaderId.isPresent()) {
            log.debug("Rejecting Vote request (preVote=false) from candidate ({}) since we already have a leader {} in epoch {}", new Object[]{replicaKey, leaderId.getAsInt(), epoch});
            return false;
        }
        if (!isLogUpToDate) {
            log.debug("Rejecting Vote request (preVote=false) from candidate ({}) since candidate's log is not up to date with us", (Object)replicaKey);
        }
        return isLogUpToDate;
    }
}

