/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.raft;

import io.confluent.kafka.raft.RaftTracer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.slf4j.Logger;

public final class CompositeRaftTracer
implements RaftTracer {
    private final List<RaftTracer> tracers;
    private final Logger logger;

    public CompositeRaftTracer(List<RaftTracer> tracers, LogContext logContext) {
        this.tracers = new ArrayList<RaftTracer>(tracers);
        this.logger = logContext.logger(this.getClass());
    }

    @Override
    public void leaderChanged(TopicIdPartition tpId, int epoch, OptionalInt nodeId, OptionalLong hwm, long logStartOffset, long logEndOffset, Supplier<Map<Integer, Long>> epochChainSupplier, Set<Integer> yesVoters, Set<Integer> currentVoters) {
        this.tryForEachTracer(tracer -> tracer.leaderChanged(tpId, epoch, nodeId, hwm, logStartOffset, logEndOffset, epochChainSupplier, yesVoters, currentVoters));
    }

    @Override
    public void highWatermarkChanged(TopicIdPartition tpId, int epoch, OptionalInt nodeId, long hwm, long logStartOffset, Map<Integer, OptionalLong> quorumFetchOffsets, Set<Integer> currentVoters) {
        this.tryForEachTracer(tracer -> tracer.highWatermarkChanged(tpId, epoch, nodeId, hwm, logStartOffset, quorumFetchOffsets, currentVoters));
    }

    @Override
    public void logStartOffsetChanged(TopicIdPartition tpId, int epoch, OptionalInt nodeId, OptionalLong hwm, long logStartOffset, long logEndOffset, Optional<OffsetAndEpoch> latestSnapshotId, OptionalInt leaderId, Set<Integer> currentVoters) {
        this.tryForEachTracer(tracer -> tracer.logStartOffsetChanged(tpId, epoch, nodeId, hwm, logStartOffset, logEndOffset, latestSnapshotId, leaderId, currentVoters));
    }

    @Override
    public void snapshotGenerated(TopicIdPartition tpId, int epoch, OptionalInt nodeId, OptionalLong hwm, long logStartOffset, long logEndOffset, OffsetAndEpoch newSnapshotId, OptionalInt leaderId, Set<Integer> currentVoters) {
        this.tryForEachTracer(tracer -> tracer.snapshotGenerated(tpId, epoch, nodeId, hwm, logStartOffset, logEndOffset, newSnapshotId, leaderId, currentVoters));
    }

    @Override
    public void nodeStartedUp(TopicIdPartition tpId, int epoch, OptionalInt nodeId, OptionalLong hwm, long logStartOffset, long logEndOffset, SortedSet<OffsetAndEpoch> snapshotIds, OptionalInt leaderId, Set<Integer> currentVoters) {
        this.tryForEachTracer(tracer -> tracer.nodeStartedUp(tpId, epoch, nodeId, hwm, logStartOffset, logEndOffset, snapshotIds, leaderId, currentVoters));
    }

    private void tryForEachTracer(Consumer<RaftTracer> action) {
        this.tracers.forEach(tracer -> {
            try {
                action.accept((RaftTracer)tracer);
            }
            catch (Exception e) {
                this.logger.error("unhandled exception encounter in {}", (Object)CompositeRaftTracer.tracerName(tracer), (Object)e);
            }
        });
    }

    private static String tracerName(RaftTracer tracer) {
        return String.format("%s@%d", tracer.getClass().getTypeName(), System.identityHashCode(tracer));
    }
}

