/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.replication.push.metrics;

import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import io.confluent.kafka.replication.push.PushSessionEndReason;
import io.confluent.kafka.replication.push.metrics.KafkaMetricHistogram;
import io.confluent.kafka.replication.push.metrics.ReplicationQuotaRecorder;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;

public class PushReplicationManagerMetrics
implements AutoCloseable {
    public static final String METRIC_GROUP_NAME = "io.confluent.kafka.replication";
    public static final String METRIC_TYPE_NAME = "PushReplication";
    private static final String METRIC_TAG_NAME_KEY = "name";
    public static final String EVENT_PROCESSING_FAILURE = "EventProcessingFailure";
    public static final String EVENT_QUEUE_PROCESSING_TIME_MS = "EventQueueProcessingTimeMs";
    public static final String PUSH_MANAGER_MEMORY_BYTES_USED = "PushManagerMemoryBytesUsed";
    public static final String PUSH_SESSION_END_COUNT = "PushSessionEndCount";
    public static final String STOPPING_PUSH_SESSIONS = "StoppingPushSessions";
    public static final String FOLLOWERS_NOT_CATCHING_UP = "FollowersNotCatchingUp";
    private static final KafkaMetricsGroup METRIC_GROUP = new KafkaMetricsGroup(PushReplicationManagerMetrics.class){

        public com.yammer.metrics.core.MetricName metricName(String name, Map<String, String> tags) {
            return KafkaMetricsGroup.explicitMetricName((String)PushReplicationManagerMetrics.METRIC_GROUP_NAME, (String)PushReplicationManagerMetrics.METRIC_TYPE_NAME, (String)name, tags);
        }
    };
    private static final long EVENT_QUEUE_PROCESSING_MAX_TIME_IN_MS = TimeUnit.MINUTES.toMillis(1L);
    public final Metrics metrics;
    private final Meter replicationBytesOutMeter;
    private final ReplicationQuotaRecorder replicationQuotaRecorder;
    private final Counter eventProcessingFailure;
    private final KafkaMetricHistogram eventQueueProcessingTime;
    private final Map<PushSessionEndReason, Counter> pushSessionEndReasonMeterMap;
    private final Counter followersNotCatchingUp;
    private final Set<Supplier<Integer>> stoppingPushSessionsSupplier;

    public PushReplicationManagerMetrics(Metrics metrics, Meter replicationBytesOutMeter, ReplicationQuotaRecorder replicationQuotaRecorder) {
        this.metrics = metrics;
        this.eventQueueProcessingTime = KafkaMetricHistogram.newLatencyHistogram(this::eventQueueProcessingTimeMetricName, EVENT_QUEUE_PROCESSING_MAX_TIME_IN_MS);
        this.metrics.sensor(EVENT_QUEUE_PROCESSING_TIME_MS).add((CompoundStat)this.eventQueueProcessingTime);
        this.replicationBytesOutMeter = replicationBytesOutMeter;
        this.replicationQuotaRecorder = replicationQuotaRecorder;
        this.eventProcessingFailure = METRIC_GROUP.newCounter(EVENT_PROCESSING_FAILURE);
        this.pushSessionEndReasonMeterMap = new EnumMap<PushSessionEndReason, Counter>(PushSessionEndReason.class);
        for (PushSessionEndReason pushSessionEndReason : PushSessionEndReason.values()) {
            this.pushSessionEndReasonMeterMap.put(pushSessionEndReason, METRIC_GROUP.newCounter(PUSH_SESSION_END_COUNT, Collections.singletonMap("reason", pushSessionEndReason.name())));
        }
        this.followersNotCatchingUp = METRIC_GROUP.newCounter(FOLLOWERS_NOT_CATCHING_UP);
        this.stoppingPushSessionsSupplier = ConcurrentHashMap.newKeySet();
        METRIC_GROUP.newGauge(STOPPING_PUSH_SESSIONS, () -> this.stoppingPushSessionsSupplier.stream().mapToInt(Supplier::get).sum());
    }

    public void recordPartitionReplicationBytesOut(Uuid topicId, int partitionIndex, long bytes) {
        this.replicationQuotaRecorder.recordPartitionBytesOut(topicId, partitionIndex, bytes);
    }

    public void recordReplicationBytesOut(long bytes) {
        this.replicationBytesOutMeter.mark(bytes);
    }

    public void updateEventQueueProcessingTime(long queueTimeMs) {
        this.eventQueueProcessingTime.record(null, Math.min(queueTimeMs, EVENT_QUEUE_PROCESSING_MAX_TIME_IN_MS), -1L);
    }

    public void incrementPushSessionEndCount(PushSessionEndReason pushSessionEndReason) {
        this.pushSessionEndReasonMeterMap.get((Object)pushSessionEndReason).inc();
    }

    public void incrementEventProcessingFailureCount() {
        this.eventProcessingFailure.inc();
    }

    public void incrementFollowersNotCatchingUpCount() {
        this.followersNotCatchingUp.inc();
    }

    public void registerMemoryBytesUsedGauge(Gauge<Long> memoryBytesUsedGauge) {
        METRIC_GROUP.newGauge(PUSH_MANAGER_MEMORY_BYTES_USED, () -> memoryBytesUsedGauge.value());
    }

    public void registerStoppingPushSessionSupplier(Supplier<Integer> supplier) {
        this.stoppingPushSessionsSupplier.add(supplier);
    }

    @Override
    public void close() {
        this.metrics.removeSensor(EVENT_QUEUE_PROCESSING_TIME_MS);
        METRIC_GROUP.removeMetric(EVENT_PROCESSING_FAILURE);
        METRIC_GROUP.removeMetric(EVENT_QUEUE_PROCESSING_TIME_MS);
        METRIC_GROUP.removeMetric(PUSH_MANAGER_MEMORY_BYTES_USED);
        this.pushSessionEndReasonMeterMap.forEach((pushSessionEndReason, counter) -> METRIC_GROUP.removeMetric(PUSH_SESSION_END_COUNT, Collections.singletonMap("reason", pushSessionEndReason.name())));
        METRIC_GROUP.removeMetric(STOPPING_PUSH_SESSIONS);
        METRIC_GROUP.removeMetric(FOLLOWERS_NOT_CATCHING_UP);
    }

    public KafkaMetric eventQueueProcessingTimeMetric(String histogramMetricSuffix) {
        return this.metrics.metric(this.eventQueueProcessingTimeMetricName(histogramMetricSuffix));
    }

    private MetricName eventQueueProcessingTimeMetricName(String histogramMetricSuffix) {
        return this.metrics.metricName(histogramMetricSuffix, METRIC_TYPE_NAME, Collections.singletonMap(METRIC_TAG_NAME_KEY, EVENT_QUEUE_PROCESSING_TIME_MS));
    }
}

