/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.replication.push.metrics;

import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import io.confluent.kafka.replication.push.PushSessionEndReason;
import io.confluent.kafka.replication.push.metrics.KafkaMetricHistogram;
import io.confluent.kafka.replication.push.metrics.ReplicationQuotaRecorder;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;

public class PushReplicationManagerMetrics
implements AutoCloseable {
    public static final String METRIC_GROUP_NAME_CCLOUD = "io.confluent.kafka.replication";
    public static final String METRIC_TYPE_NAME_CCLOUD = "PushReplication";
    public static final String METRIC_GROUP_NAME_NON_CCLOUD = "kafka.server";
    public static final String METRIC_TYPE_NAME_NON_CCLOUD = "IntelligentReplication";
    private static final String METRIC_TAG_NAME_KEY = "name";
    public static final String STOPPING_PUSH_SESSIONS_CCLOUD = "StoppingPushSessions";
    public static final String EVENT_QUEUE_PROCESSING_TIME_MS_CCLOUD = "EventQueueProcessingTimeMs";
    public static final String EVENT_PROCESSING_FAILURE_CCLOUD = "EventProcessingFailure";
    public static final String FOLLOWERS_NOT_CATCHING_UP_CCLOUD = "FollowersNotCatchingUp";
    public static final String STOPPING_PUSH_SESSIONS_NON_CCLOUD = "StoppingPushSessionsCount";
    public static final String EVENT_QUEUE_PROCESSING_TIME_MS_NON_CCLOUD = "PushEventQueueProcessingTimeMs";
    public static final String EVENT_PROCESSING_FAILURE_NON_CCLOUD = "PushEventProcessingFailure";
    public static final String FOLLOWERS_NOT_CATCHING_UP_NON_CCLOUD = "FollowersAwaitingPushTransition";
    public static final String PUSH_MANAGER_MEMORY_BYTES_USED = "PushManagerMemoryBytesUsed";
    public static final String PUSH_SESSION_END_COUNT = "PushSessionEndCount";
    private final String metricGroupName;
    private final String metricTypeName;
    private final String pushManagerMemoryBytesUsedMetricName;
    private final String stoppingPushSessionsMetricName;
    private final String eventQueueProcessingTimeMetricName;
    private final String eventProcessingFailureMetricName;
    private final String followersNotCatchingUpMetricName;
    private final KafkaMetricsGroup metricGroup;
    private static final long EVENT_QUEUE_PROCESSING_MAX_TIME_IN_MS = TimeUnit.MINUTES.toMillis(1L);
    public final Metrics metrics;
    private final Meter replicationBytesOutMeter;
    private final ReplicationQuotaRecorder replicationQuotaRecorder;
    private final Counter eventProcessingFailure;
    private final KafkaMetricHistogram eventQueueProcessingTime;
    private final Map<PushSessionEndReason, Counter> pushSessionEndReasonMeterMap;
    private final Counter followersNotCatchingUp;
    private final Set<Supplier<Integer>> stoppingPushSessionsSupplier;

    public PushReplicationManagerMetrics(Metrics metrics, Meter replicationBytesOutMeter, ReplicationQuotaRecorder replicationQuotaRecorder, boolean isCCloud) {
        this.metricGroupName = isCCloud ? METRIC_GROUP_NAME_CCLOUD : METRIC_GROUP_NAME_NON_CCLOUD;
        this.metricTypeName = isCCloud ? METRIC_TYPE_NAME_CCLOUD : METRIC_TYPE_NAME_NON_CCLOUD;
        this.pushManagerMemoryBytesUsedMetricName = PUSH_MANAGER_MEMORY_BYTES_USED;
        this.stoppingPushSessionsMetricName = isCCloud ? STOPPING_PUSH_SESSIONS_CCLOUD : STOPPING_PUSH_SESSIONS_NON_CCLOUD;
        this.eventQueueProcessingTimeMetricName = isCCloud ? EVENT_QUEUE_PROCESSING_TIME_MS_CCLOUD : EVENT_QUEUE_PROCESSING_TIME_MS_NON_CCLOUD;
        this.eventProcessingFailureMetricName = isCCloud ? EVENT_PROCESSING_FAILURE_CCLOUD : EVENT_PROCESSING_FAILURE_NON_CCLOUD;
        this.followersNotCatchingUpMetricName = isCCloud ? FOLLOWERS_NOT_CATCHING_UP_CCLOUD : FOLLOWERS_NOT_CATCHING_UP_NON_CCLOUD;
        this.metricGroup = new KafkaMetricsGroup(PushReplicationManagerMetrics.class){

            public com.yammer.metrics.core.MetricName metricName(String name, Map<String, String> tags) {
                return KafkaMetricsGroup.explicitMetricName((String)PushReplicationManagerMetrics.this.metricGroupName, (String)PushReplicationManagerMetrics.this.metricTypeName, (String)name, tags);
            }
        };
        this.metrics = metrics;
        this.eventQueueProcessingTime = KafkaMetricHistogram.newLatencyHistogram(this::eventQueueProcessingTimeMetricName, EVENT_QUEUE_PROCESSING_MAX_TIME_IN_MS);
        this.metrics.sensor(this.eventQueueProcessingTimeMetricName).add((CompoundStat)this.eventQueueProcessingTime);
        this.replicationBytesOutMeter = replicationBytesOutMeter;
        this.replicationQuotaRecorder = replicationQuotaRecorder;
        this.eventProcessingFailure = this.metricGroup.newCounter(this.eventProcessingFailureMetricName);
        this.pushSessionEndReasonMeterMap = new EnumMap<PushSessionEndReason, Counter>(PushSessionEndReason.class);
        for (PushSessionEndReason pushSessionEndReason : PushSessionEndReason.values()) {
            this.pushSessionEndReasonMeterMap.put(pushSessionEndReason, this.metricGroup.newCounter(PUSH_SESSION_END_COUNT, Collections.singletonMap("reason", pushSessionEndReason.name())));
        }
        this.followersNotCatchingUp = this.metricGroup.newCounter(this.followersNotCatchingUpMetricName);
        this.stoppingPushSessionsSupplier = ConcurrentHashMap.newKeySet();
        this.metricGroup.newGauge(this.stoppingPushSessionsMetricName, () -> this.stoppingPushSessionsSupplier.stream().mapToInt(Supplier::get).sum());
    }

    public void recordPartitionReplicationBytesOut(Uuid topicId, int partitionIndex, long bytes) {
        this.replicationQuotaRecorder.recordPartitionBytesOut(topicId, partitionIndex, bytes);
    }

    public void recordReplicationBytesOut(long bytes) {
        this.replicationBytesOutMeter.mark(bytes);
    }

    public void updateEventQueueProcessingTime(long queueTimeMs) {
        this.eventQueueProcessingTime.record(null, Math.min(queueTimeMs, EVENT_QUEUE_PROCESSING_MAX_TIME_IN_MS), -1L);
    }

    public void incrementPushSessionEndCount(PushSessionEndReason pushSessionEndReason) {
        this.pushSessionEndReasonMeterMap.get((Object)pushSessionEndReason).inc();
    }

    public void incrementEventProcessingFailureCount() {
        this.eventProcessingFailure.inc();
    }

    public void incrementFollowersNotCatchingUpCount() {
        this.followersNotCatchingUp.inc();
    }

    public void registerMemoryBytesUsedGauge(Gauge<Long> memoryBytesUsedGauge) {
        this.metricGroup.newGauge(this.pushManagerMemoryBytesUsedMetricName, () -> memoryBytesUsedGauge.value());
    }

    public void registerStoppingPushSessionSupplier(Supplier<Integer> supplier) {
        this.stoppingPushSessionsSupplier.add(supplier);
    }

    @Override
    public void close() {
        this.metrics.removeSensor(this.eventQueueProcessingTimeMetricName);
        this.metricGroup.removeMetric(this.eventProcessingFailureMetricName);
        this.metricGroup.removeMetric(this.eventQueueProcessingTimeMetricName);
        this.metricGroup.removeMetric(this.pushManagerMemoryBytesUsedMetricName);
        this.pushSessionEndReasonMeterMap.forEach((pushSessionEndReason, counter) -> this.metricGroup.removeMetric(PUSH_SESSION_END_COUNT, Collections.singletonMap("reason", pushSessionEndReason.name())));
        this.metricGroup.removeMetric(this.stoppingPushSessionsMetricName);
        this.metricGroup.removeMetric(this.followersNotCatchingUpMetricName);
    }

    public KafkaMetric eventQueueProcessingTimeMetric(String histogramMetricSuffix) {
        return this.metrics.metric(this.eventQueueProcessingTimeMetricName(histogramMetricSuffix));
    }

    private MetricName eventQueueProcessingTimeMetricName(String histogramMetricSuffix) {
        return this.metrics.metricName(histogramMetricSuffix, this.metricTypeName, Collections.singletonMap(METRIC_TAG_NAME_KEY, this.eventQueueProcessingTimeMetricName));
    }
}

