/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.Collections;
import org.apache.kafka.server.common.Features;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FeaturesTest {
    FeaturesTest() {
    }

    @Test
    public void testKRaftModeFeatures() {
        Features features = new Features(MetadataVersion.MINIMUM_KRAFT_VERSION, Collections.singletonMap("foo", (short)2), 123L, true);
        Assertions.assertEquals((short)MetadataVersion.MINIMUM_KRAFT_VERSION.featureLevel(), (Short)((Short)features.finalizedFeatures().get("metadata.version")));
        Assertions.assertEquals((short)2, (Short)((Short)features.finalizedFeatures().get("foo")));
        Assertions.assertEquals((int)2, (int)features.finalizedFeatures().size());
    }

    @Test
    public void testZkModeFeatures() {
        Features features = new Features(MetadataVersion.MINIMUM_KRAFT_VERSION, Collections.singletonMap("foo", (short)2), 123L, false);
        Assertions.assertNull(features.finalizedFeatures().get("metadata.version"));
        Assertions.assertEquals((short)2, (Short)((Short)features.finalizedFeatures().get("foo")));
        Assertions.assertEquals((int)1, (int)features.finalizedFeatures().size());
    }
}

