/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.timeline;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.timeline.Revertable;
import org.apache.kafka.timeline.Snapshot;
import org.slf4j.Logger;

public class SnapshotRegistry {
    public static final long LATEST_EPOCH = Long.MAX_VALUE;
    private final Logger log;
    private final HashMap<Long, Snapshot> snapshots = new HashMap();
    private final Snapshot head = new Snapshot(Long.MIN_VALUE);
    private List<WeakReference<Revertable>> revertables = new ArrayList<WeakReference<Revertable>>();
    private final int maxRegistrationsSinceScrub;
    private int numRegistrationsSinceScrub = 0;
    private long numScrubs = 0L;

    public SnapshotRegistry(LogContext logContext) {
        this(logContext, 10000);
    }

    public SnapshotRegistry(LogContext logContext, int maxRegistrationsSinceScrub) {
        this.log = logContext.logger(SnapshotRegistry.class);
        this.maxRegistrationsSinceScrub = maxRegistrationsSinceScrub;
    }

    Iterator<Snapshot> iterator() {
        return new SnapshotIterator(this.head.next());
    }

    Iterator<Snapshot> iterator(long epoch) {
        return this.iterator(this.getSnapshot(epoch));
    }

    Iterator<Snapshot> iterator(Snapshot snapshot) {
        return new SnapshotIterator(snapshot);
    }

    Iterator<Snapshot> reverseIterator() {
        return new ReverseSnapshotIterator();
    }

    public List<Long> epochsList() {
        ArrayList<Long> result = new ArrayList<Long>();
        Iterator<Snapshot> iterator = this.iterator();
        while (iterator.hasNext()) {
            result.add(iterator.next().epoch());
        }
        return result;
    }

    public boolean hasSnapshot(long epoch) {
        return this.snapshots.containsKey(epoch);
    }

    private String epochsToString() {
        return this.epochsList().stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    Snapshot getSnapshot(long epoch) {
        Snapshot snapshot = this.snapshots.get(epoch);
        if (snapshot == null) {
            throw new RuntimeException("No in-memory snapshot for epoch " + epoch + ". Snapshot epochs are: " + this.epochsToString());
        }
        return snapshot;
    }

    Snapshot getOrCreateSnapshot(long epoch) {
        Snapshot last = this.head.prev();
        if (last.epoch() > epoch) {
            throw new RuntimeException("Can't create a new in-memory snapshot at epoch " + epoch + " because there is already a snapshot with epoch " + last.epoch() + ". Snapshot epochs are " + this.epochsToString());
        }
        if (last.epoch() == epoch) {
            return last;
        }
        Snapshot snapshot = new Snapshot(epoch);
        last.appendNext(snapshot);
        this.snapshots.put(epoch, snapshot);
        this.log.debug("Creating in-memory snapshot {}", (Object)epoch);
        return snapshot;
    }

    public void idempotentCreateSnapshot(long epoch) {
        this.getOrCreateSnapshot(epoch);
    }

    public void revertToSnapshot(long targetEpoch) {
        this.log.debug("Reverting to in-memory snapshot {}", (Object)targetEpoch);
        Snapshot target = this.getSnapshot(targetEpoch);
        Iterator<Snapshot> iterator = this.iterator(target);
        iterator.next();
        while (iterator.hasNext()) {
            Snapshot snapshot = iterator.next();
            this.log.debug("Deleting in-memory snapshot {} because we are reverting to {}", (Object)snapshot.epoch(), (Object)targetEpoch);
            iterator.remove();
        }
        target.handleRevert();
    }

    public void deleteSnapshot(long targetEpoch) {
        this.deleteSnapshot(this.getSnapshot(targetEpoch));
    }

    void deleteSnapshot(Snapshot snapshot) {
        Snapshot prev = snapshot.prev();
        if (prev != this.head) {
            prev.mergeFrom(snapshot);
        } else {
            snapshot.erase();
        }
        this.log.debug("Deleting in-memory snapshot {}", (Object)snapshot.epoch());
        this.snapshots.remove(snapshot.epoch(), snapshot);
    }

    public void deleteSnapshotsUpTo(long targetEpoch) {
        Iterator<Snapshot> iterator = this.iterator();
        while (iterator.hasNext()) {
            Snapshot snapshot = iterator.next();
            if (snapshot.epoch() >= targetEpoch) {
                return;
            }
            iterator.remove();
        }
    }

    public long latestEpoch() {
        return this.head.prev().epoch();
    }

    public long numScrubs() {
        return this.numScrubs;
    }

    void register(Revertable revertable) {
        ++this.numRegistrationsSinceScrub;
        if (this.numRegistrationsSinceScrub > this.maxRegistrationsSinceScrub) {
            this.scrub();
        }
        this.revertables.add(new WeakReference<Revertable>(revertable));
    }

    void scrub() {
        ArrayList<WeakReference<Revertable>> newRevertables = new ArrayList<WeakReference<Revertable>>(this.revertables.size() / 2);
        for (WeakReference<Revertable> ref : this.revertables) {
            if (ref.get() == null) continue;
            newRevertables.add(ref);
        }
        ++this.numScrubs;
        this.revertables = newRevertables;
        this.numRegistrationsSinceScrub = 0;
    }

    public void reset() {
        this.deleteSnapshotsUpTo(Long.MAX_VALUE);
        ArrayList<WeakReference<Revertable>> newRevertables = new ArrayList<WeakReference<Revertable>>();
        for (WeakReference<Revertable> ref : this.revertables) {
            Revertable revertable = (Revertable)ref.get();
            if (revertable == null) continue;
            try {
                revertable.reset();
            }
            catch (Exception e) {
                this.log.error("Error reverting {}", (Object)revertable, (Object)e);
            }
            newRevertables.add(ref);
        }
        ++this.numScrubs;
        this.revertables = newRevertables;
        this.numRegistrationsSinceScrub = 0;
    }

    class SnapshotIterator
    implements Iterator<Snapshot> {
        Snapshot cur;
        Snapshot result = null;

        SnapshotIterator(Snapshot start) {
            this.cur = start;
        }

        @Override
        public boolean hasNext() {
            return this.cur != SnapshotRegistry.this.head;
        }

        @Override
        public Snapshot next() {
            this.result = this.cur;
            this.cur = this.cur.next();
            return this.result;
        }

        @Override
        public void remove() {
            if (this.result == null) {
                throw new IllegalStateException();
            }
            SnapshotRegistry.this.deleteSnapshot(this.result);
            this.result = null;
        }
    }

    class ReverseSnapshotIterator
    implements Iterator<Snapshot> {
        Snapshot cur;

        ReverseSnapshotIterator() {
            this.cur = SnapshotRegistry.this.head.prev();
        }

        @Override
        public boolean hasNext() {
            return this.cur != SnapshotRegistry.this.head;
        }

        @Override
        public Snapshot next() {
            Snapshot result = this.cur;
            this.cur = this.cur.prev();
            return result;
        }
    }
}

