/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import java.util.Objects;
import java.util.Optional;

public class IdentityMetadata {
    private final String poolId;

    public IdentityMetadata(String poolId) {
        this.poolId = poolId;
    }

    public String poolId() {
        return this.poolId;
    }

    public Optional<String> maybeGetPoolId() {
        return Optional.ofNullable(this.poolId).filter(s -> !s.isEmpty());
    }

    public int hashCode() {
        return Objects.hash(this.poolId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityMetadata that = (IdentityMetadata)o;
        return Objects.equals(this.poolId, that.poolId);
    }

    public String toString() {
        return "IdentityMetadata(poolId='" + this.poolId + "')";
    }

    public static class Builder {
        private String poolId;

        public Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public IdentityMetadata build() {
            return new IdentityMetadata(this.poolId);
        }
    }
}

