/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.IdentityMetadata;
import io.confluent.kafka.multitenant.TenantMetadata;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.security.auth.ConfluentPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class MultiTenantPrincipal
extends ConfluentPrincipal {
    public static final String TENANT_USER_TYPE = "TenantUser";
    public static final String TENANT_WILDCARD_USER_TYPE = "TenantUser*";
    public static final String DELIMITER = "_";
    public static final String USERV2 = "UserV2";
    public static final KafkaPrincipal WILDCARD_USERV2_PRINCIPAL = new KafkaPrincipal("UserV2", "*");
    public static final String TENANT_USERV2_TYPE = "TenantUserV2";
    public static final String TENANT_WILDCARD_USERV2_TYPE = "TenantUserV2*";
    private final String user;
    private final IdentityMetadata identityMetadata;
    private final TenantMetadata tenantMetadata;

    public MultiTenantPrincipal(String user, TenantMetadata tenantMetadata) {
        this(user, user, tenantMetadata);
    }

    public MultiTenantPrincipal(String user, String saslAuthenticationId, TenantMetadata tenantMetadata) {
        this(user, saslAuthenticationId, tenantMetadata, null);
    }

    public MultiTenantPrincipal(String user, TenantMetadata tenantMetadata, IdentityMetadata identityMetadata) {
        this(user, user, tenantMetadata, identityMetadata);
    }

    public MultiTenantPrincipal(String user, String saslAuthenticationId, TenantMetadata tenantMetadata, IdentityMetadata identityMetadata) {
        super(TENANT_USER_TYPE, tenantMetadata.tenantPrefix() + user, saslAuthenticationId);
        this.user = user;
        this.tenantMetadata = tenantMetadata;
        if (identityMetadata == null) {
            identityMetadata = new IdentityMetadata(null);
        }
        this.identityMetadata = identityMetadata;
    }

    public TenantMetadata tenantMetadata() {
        return this.tenantMetadata;
    }

    public String user() {
        return this.user;
    }

    IdentityMetadata identityMetadata() {
        return this.identityMetadata;
    }

    public Optional<IdentityMetadata> maybeGetIdentityMetadata() {
        return Optional.ofNullable(this.identityMetadata);
    }

    public boolean isSuperUser(boolean enableDataplaneRbacForPKC, boolean oauthSuperUserDisable) {
        if (this.tenantMetadata.isServiceAccount) {
            return false;
        }
        if (this.tenantMetadata.isHealthcheckTenant) {
            return true;
        }
        return this.isInternalUser() || this.tenantMetadata.isApiKeyAuthenticated && !enableDataplaneRbacForPKC || !this.tenantMetadata.isApiKeyAuthenticated && !enableDataplaneRbacForPKC && !oauthSuperUserDisable;
    }

    public boolean isInternalUser() {
        return "0".equals(this.user);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultiTenantPrincipal that = (MultiTenantPrincipal)((Object)o);
        return Objects.equals(this.tenantMetadata, that.tenantMetadata) && Objects.equals(this.identityMetadata, that.identityMetadata);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.tenantMetadata != null ? this.tenantMetadata.hashCode() : 0) + (this.identityMetadata != null ? this.identityMetadata.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MultiTenantPrincipal(tenantMetadata=" + this.tenantMetadata + ", identityMetadata=" + this.identityMetadata + ", user=" + this.user + ")";
    }

    public static boolean isTenantPrincipal(KafkaPrincipal principal) {
        return principal.getPrincipalType().startsWith(TENANT_USER_TYPE);
    }
}

