/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import io.confluent.kafka.availability.FilesWrapper;
import io.confluent.kafka.availability.ThreadCountersManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.utils.Utils;

public class CheckpointFile<T> {
    private final int version;
    private final EntryFormatter<T> formatter;
    private final Object lock = new Object();
    private final Path absolutePath;
    private final Path tempPath;

    public CheckpointFile(File file, int version, EntryFormatter<T> formatter) throws IOException {
        this.version = version;
        this.formatter = formatter;
        try {
            FilesWrapper.createFile((Path)file.toPath(), (FileAttribute[])new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        this.absolutePath = file.toPath().toAbsolutePath();
        this.tempPath = Paths.get(this.absolutePath.toString() + ".tmp", new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Collection<T> entries) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            ThreadCountersManager.wrapIOChecked(() -> {
                try (FileOutputStream fileOutputStream = new FileOutputStream(this.tempPath.toFile());
                     BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8));){
                    this.writeToWriter(entries, writer);
                    fileOutputStream.getFD().sync();
                }
            });
            Utils.atomicMoveWithFallback((Path)this.tempPath, (Path)this.absolutePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] writeToByteArray(Collection<T> entries) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.UTF_8));){
            this.writeToWriter(entries, bufferedWriter);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    public void writeToWriter(Collection<T> entries, BufferedWriter writer) throws IOException {
        writer.write(String.valueOf(this.version));
        writer.newLine();
        writer.write(String.valueOf(entries.size()));
        writer.newLine();
        for (T entry : entries) {
            writer.write(this.formatter.toString(entry));
            writer.newLine();
        }
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return (List)ThreadCountersManager.wrapIOChecked(() -> {
                try (BufferedReader reader = Files.newBufferedReader(this.absolutePath);){
                    CheckpointReadBuffer<T> checkpointBuffer = new CheckpointReadBuffer<T>(this.absolutePath.toString(), reader, this.version, this.formatter);
                    List<T> list = checkpointBuffer.read();
                    return list;
                }
            });
        }
    }

    public static interface EntryFormatter<T> {
        public String toString(T var1);

        public Optional<T> fromString(String var1);
    }

    public static class CheckpointReadBuffer<T> {
        private final String location;
        private final BufferedReader reader;
        private final int version;
        private final EntryFormatter<T> formatter;

        public CheckpointReadBuffer(String location, BufferedReader reader, int version, EntryFormatter<T> formatter) {
            this.location = location;
            this.reader = reader;
            this.version = version;
            this.formatter = formatter;
        }

        public List<T> read() throws IOException {
            String line = this.reader.readLine();
            if (line == null) {
                return Collections.emptyList();
            }
            int readVersion = this.toInt(line);
            if (readVersion != this.version) {
                throw new IOException("Unrecognised version:" + readVersion + ", expected version: " + this.version + " in checkpoint file at: " + this.location);
            }
            line = this.reader.readLine();
            if (line == null) {
                return Collections.emptyList();
            }
            int expectedSize = this.toInt(line);
            ArrayList<T> entries = new ArrayList<T>(expectedSize);
            line = this.reader.readLine();
            while (line != null) {
                Optional<T> maybeEntry = this.formatter.fromString(line);
                if (!maybeEntry.isPresent()) {
                    throw this.buildMalformedLineException(line);
                }
                entries.add(maybeEntry.get());
                line = this.reader.readLine();
            }
            if (entries.size() != expectedSize) {
                throw new IOException("Expected [" + expectedSize + "] entries in checkpoint file [" + this.location + "], but found only [" + entries.size() + "]");
            }
            return entries;
        }

        private int toInt(String line) throws IOException {
            try {
                return Integer.parseInt(line);
            }
            catch (NumberFormatException e) {
                throw this.buildMalformedLineException(line);
            }
        }

        private IOException buildMalformedLineException(String line) {
            return new IOException(String.format("Malformed line in checkpoint file [%s]: %s", this.location, line));
        }
    }
}

