/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.kafka.common.record.RecordVersion;

public enum MetadataVersion {
    IBP_0_8_0(-1, -1, "0.8.0", "CP-1.0"),
    IBP_0_8_1(-1, -1, "0.8.1", "CP-1.0"),
    IBP_0_8_2(-1, -1, "0.8.2", "CP-1.0"),
    IBP_0_9_0(-1, -1, "0.9.0", "CP-2.0"),
    IBP_0_10_0_IV0(-1, -1, "0.10.0-IV0", "CP-3.0-IV0"),
    IBP_0_10_0_IV1(-1, -1, "0.10.0-IV1", "CP-3.0-IV1"),
    IBP_0_10_1_IV0(-1, -1, "0.10.1-IV0", "CP-3.1-IV0"),
    IBP_0_10_1_IV1(-1, -1, "0.10.1-IV1", "CP-3.1-IV1"),
    IBP_0_10_1_IV2(-1, -1, "0.10.1-IV2", "CP-3.1-IV2"),
    IBP_0_10_2_IV0(-1, -1, "0.10.2-IV0", "CP-3.2-IV0"),
    IBP_0_11_0_IV0(-1, -1, "0.11.0-IV0", "CP-3.3-IV0"),
    IBP_0_11_0_IV1(-1, -1, "0.11.0-IV1", "CP-3.3-IV1"),
    IBP_0_11_0_IV2(-1, -1, "0.11.0-IV2", "CP-3.3-IV2"),
    IBP_1_0_IV0(-1, -1, "1.0-IV0", "CP-4.0-IV0"),
    IBP_1_1_IV0(-1, -1, "1.1-IV0", "CP-4.1-IV0"),
    IBP_2_0_IV0(-1, -1, "2.0-IV0", "CP-5.0-IV0"),
    IBP_2_0_IV1(-1, -1, "2.0-IV1", "CP-5.0-IV1"),
    IBP_2_1_IV0(-1, -1, "2.1-IV0", "CP-5.1-IV0"),
    IBP_2_1_IV1(-1, -1, "2.1-IV1", "CP-5.1-IV1"),
    IBP_2_1_IV2(-1, -1, "2.1-IV2", "CP-5.1-IV2"),
    IBP_2_2_IV0(-1, -1, "2.2-IV0", "CP-5.2-IV0"),
    IBP_2_2_IV1(-1, -1, "2.2-IV1", "CP-5.2-IV1"),
    IBP_2_3_IV0(-1, -1, "2.3-IV0", "CP-5.3-IV0"),
    IBP_2_3_IV1(-1, -1, "2.3-IV1", "CP-5.3-IV1"),
    IBP_2_4_IV0(-1, -1, "2.4-IV0", "CP-5.4-IV0"),
    IBP_2_4_IV1(-1, -1, "2.4-IV1", "CP-5.4-IV1"),
    IBP_2_5_IV0(-1, -1, "2.5-IV0", "CP-5.5-IV0"),
    IBP_2_6_IV0(-1, -1, "2.6-IV0", "CP-6.0-IV0"),
    IBP_2_7_IV0(-1, -1, "2.7-IV0", "CP-6.1-IV0"),
    IBP_2_7_IV1(-1, -1, "2.7-IV1", "CP-6.1-IV1"),
    IBP_2_7_IV2(-1, -1, "2.7-IV2", "CP-6.1-IV2"),
    IBP_2_8_IV0(-1, -1, "2.8-IV0", "CP-6.2-IV0"),
    IBP_2_8_IV1(-1, -1, "2.8-IV1", "CP-6.2-IV1"),
    IBP_3_0_IV0(-1, -1, "3.0-IV0", "CP-7.0-IV0"),
    IBP_3_0_IV1(1, 101, "3.0-IV1", "CP-7.0-IV1", true),
    IBP_3_1_IV0(2, 102, "3.1-IV0", "CP-7.1-IV0", false),
    IBP_3_2_IV0(3, 103, "3.2-IV0", "CP-7.2-IV0", true),
    IBP_3_3_IV0(4, 104, "3.3-IV0", "CP-7.3-IV0", false),
    IBP_3_3_IV1(5, 105, "3.3-IV1", "CP-7.3-IV1", true),
    IBP_3_3_IV2(6, 106, "3.3-IV2", "CP-7.3-IV2", true),
    IBP_3_3_IV3(7, 107, "3.3-IV3", "CP-7.3-IV3", true);

    public static final String APACHE_FEATURE_NAME = "metadata.version";
    public static final String CONFLUENT_FEATURE_NAME = "confluent.metadata.version";
    public static final String CONFLUENT_RELEASE_PREFIX = "CP-";
    public static final MetadataVersion MINIMUM_KRAFT_VERSION;
    public static final MetadataVersion MINIMUM_BOOTSTRAP_VERSION;
    public static final MetadataVersion[] VERSIONS;
    private final short apacheFeatureLevel;
    private final short confluentFeatureLevel;
    private final String apacheRelease;
    private final String confluentRelease;
    private final String shortApacheRelease;
    private final String shortConfluentRelease;
    private final boolean didMetadataChange;
    private static final Map<String, MetadataVersion> IBP_VERSIONS;
    private static final Map<String, MetadataVersion> CONFLUENT_VERSIONS;

    private MetadataVersion(int apacheFeatureLevel, int confluentFeatureLevel, String apacheRelease, String confluentRelease) {
        this(apacheFeatureLevel, confluentFeatureLevel, apacheRelease, confluentRelease, true);
    }

    static String stripIv(String input) {
        int i = input.lastIndexOf("-IV");
        if (i < 0) {
            throw new RuntimeException("No -IV found in string " + input);
        }
        return input.substring(0, i);
    }

    private MetadataVersion(int apacheFeatureLevel, int confluentFeatureLevel, String apacheRelease, String confluentRelease, boolean didMetadataChange) {
        this.apacheFeatureLevel = (short)apacheFeatureLevel;
        this.confluentFeatureLevel = (short)confluentFeatureLevel;
        this.apacheRelease = apacheRelease;
        if (!confluentRelease.startsWith(CONFLUENT_RELEASE_PREFIX)) {
            throw new RuntimeException("The Confluent release string must start with CP-");
        }
        this.confluentRelease = confluentRelease;
        this.didMetadataChange = didMetadataChange;
        if (apacheRelease.equals("0.8.0") || apacheRelease.equals("0.8.1") || apacheRelease.equals("0.8.2") || apacheRelease.equals("0.9.0")) {
            this.shortApacheRelease = apacheRelease;
            this.shortConfluentRelease = confluentRelease;
        } else {
            this.shortApacheRelease = MetadataVersion.stripIv(apacheRelease);
            this.shortConfluentRelease = MetadataVersion.stripIv(confluentRelease);
        }
    }

    public short apacheFeatureLevel() {
        return this.apacheFeatureLevel;
    }

    public short confluentFeatureLevel() {
        return this.confluentFeatureLevel;
    }

    public boolean isSaslInterBrokerHandshakeRequestEnabled() {
        return this.isAtLeast(IBP_0_10_0_IV1);
    }

    public boolean isOffsetForLeaderEpochSupported() {
        return this.isAtLeast(IBP_0_11_0_IV2);
    }

    public boolean isMinTierFeatureSupported() {
        return this.isAtLeast(IBP_2_4_IV1);
    }

    public boolean isFeatureVersioningSupported() {
        return this.isAtLeast(IBP_2_7_IV0);
    }

    public boolean isTruncationOnFetchSupported() {
        return this.isAtLeast(IBP_2_7_IV1);
    }

    public boolean isAlterPartitionSupported() {
        return this.isAtLeast(IBP_2_7_IV2);
    }

    public boolean isTopicIdsSupported() {
        return this.isAtLeast(IBP_2_8_IV0);
    }

    public boolean isAllocateProducerIdsSupported() {
        return this.isAtLeast(IBP_3_0_IV0);
    }

    public boolean isLeaderRecoverySupported() {
        return this.isAtLeast(IBP_3_2_IV0);
    }

    public boolean isNoOpRecordSupported() {
        return this.isAtLeast(IBP_3_3_IV1);
    }

    public boolean isKRaftSupported() {
        return this.confluentFeatureLevel > 0;
    }

    public RecordVersion highestSupportedRecordVersion() {
        if (this.isLessThan(IBP_0_10_0_IV0)) {
            return RecordVersion.V0;
        }
        if (this.isLessThan(IBP_0_11_0_IV0)) {
            return RecordVersion.V1;
        }
        return RecordVersion.V2;
    }

    public boolean isBrokerRegistrationChangeRecordSupported() {
        return this.isAtLeast(IBP_3_3_IV2);
    }

    public boolean isInControlledShutdownStateSupported() {
        return this.isAtLeast(IBP_3_3_IV3);
    }

    public short registerBrokerRecordVersion() {
        if (this.isInControlledShutdownStateSupported()) {
            return 1;
        }
        return 0;
    }

    public short fetchRequestVersion() {
        if (this.isAtLeast(IBP_3_1_IV0)) {
            return 13;
        }
        if (this.isAtLeast(IBP_2_7_IV1)) {
            return 12;
        }
        if (this.isAtLeast(IBP_2_3_IV1)) {
            return 11;
        }
        if (this.isAtLeast(IBP_2_1_IV2)) {
            return 10;
        }
        if (this.isAtLeast(IBP_2_0_IV1)) {
            return 8;
        }
        if (this.isAtLeast(IBP_1_1_IV0)) {
            return 7;
        }
        if (this.isAtLeast(IBP_0_11_0_IV1)) {
            return 5;
        }
        if (this.isAtLeast(IBP_0_11_0_IV0)) {
            return 4;
        }
        if (this.isAtLeast(IBP_0_10_1_IV1)) {
            return 3;
        }
        if (this.isAtLeast(IBP_0_10_0_IV0)) {
            return 2;
        }
        if (this.isAtLeast(IBP_0_9_0)) {
            return 1;
        }
        return 0;
    }

    public short offsetForLeaderEpochRequestVersion() {
        if (this.isAtLeast(IBP_2_8_IV0)) {
            return 4;
        }
        if (this.isAtLeast(IBP_2_3_IV1)) {
            return 3;
        }
        if (this.isAtLeast(IBP_2_1_IV1)) {
            return 2;
        }
        if (this.isAtLeast(IBP_2_0_IV0)) {
            return 1;
        }
        return 0;
    }

    public short listOffsetRequestVersion() {
        if (this.isAtLeast(IBP_3_0_IV1)) {
            return 7;
        }
        if (this.isAtLeast(IBP_2_8_IV0)) {
            return 6;
        }
        if (this.isAtLeast(IBP_2_2_IV1)) {
            return 5;
        }
        if (this.isAtLeast(IBP_2_1_IV1)) {
            return 4;
        }
        if (this.isAtLeast(IBP_2_0_IV1)) {
            return 3;
        }
        if (this.isAtLeast(IBP_0_11_0_IV0)) {
            return 2;
        }
        if (this.isAtLeast(IBP_0_10_1_IV2)) {
            return 1;
        }
        return 0;
    }

    public String shortVersion() {
        return this.shortApacheRelease;
    }

    public String version() {
        return this.apacheRelease;
    }

    public String shortConfluentRelease() {
        return this.shortConfluentRelease;
    }

    public String confluentRelease() {
        return this.confluentRelease;
    }

    public String apacheRelease() {
        return this.apacheRelease;
    }

    public boolean didMetadataChange() {
        return this.didMetadataChange;
    }

    Optional<MetadataVersion> previous() {
        int idx = this.ordinal();
        if (idx > 0) {
            return Optional.of(VERSIONS[idx - 1]);
        }
        return Optional.empty();
    }

    public static MetadataVersion fromVersionString(String versionString) {
        String[] versionSegments = versionString.split(Pattern.quote("."));
        int numSegments = versionString.startsWith("0.") ? 3 : 2;
        String key = numSegments >= versionSegments.length ? versionString : String.join((CharSequence)".", Arrays.copyOfRange(versionSegments, 0, numSegments));
        MetadataVersion result = IBP_VERSIONS.get(key);
        if (result == null && (result = CONFLUENT_VERSIONS.get(key)) == null) {
            throw new IllegalArgumentException("Version " + versionString + " is not a valid version");
        }
        return result;
    }

    public static MetadataVersion fromConfluentFeatureLevel(short version) {
        for (MetadataVersion metadataVersion : MetadataVersion.values()) {
            if (metadataVersion.confluentFeatureLevel() != version) continue;
            return metadataVersion;
        }
        if (1 <= version && version <= 7) {
            for (MetadataVersion metadataVersion : MetadataVersion.values()) {
                if (metadataVersion.apacheFeatureLevel() != version) continue;
                return metadataVersion;
            }
        }
        throw new IllegalArgumentException("No Confluent MetadataVersion with metadata version " + version);
    }

    public static MetadataVersion fromApacheFeatureLevel(short level) {
        for (MetadataVersion metadataVersion : MetadataVersion.values()) {
            if (metadataVersion.apacheFeatureLevel() != level) continue;
            return metadataVersion;
        }
        throw new IllegalArgumentException("No Apache MetadataVersion with metadata feature level " + level);
    }

    public static MetadataVersion minSupportedFor(RecordVersion recordVersion) {
        switch (recordVersion) {
            case V0: {
                return IBP_0_8_0;
            }
            case V1: {
                return IBP_0_10_0_IV0;
            }
            case V2: {
                return IBP_0_11_0_IV0;
            }
        }
        throw new IllegalArgumentException("Invalid message format version " + recordVersion);
    }

    public static MetadataVersion latest() {
        return VERSIONS[VERSIONS.length - 1];
    }

    public static boolean checkIfMetadataChanged(MetadataVersion sourceVersion, MetadataVersion targetVersion) {
        MetadataVersion lowVersion;
        MetadataVersion highVersion;
        if (sourceVersion == targetVersion) {
            return false;
        }
        if (sourceVersion.compareTo(targetVersion) < 0) {
            highVersion = targetVersion;
            lowVersion = sourceVersion;
        } else {
            highVersion = sourceVersion;
            lowVersion = targetVersion;
        }
        return MetadataVersion.checkIfMetadataChangedOrdered(highVersion, lowVersion);
    }

    private static boolean checkIfMetadataChangedOrdered(MetadataVersion highVersion, MetadataVersion lowVersion) {
        Optional<MetadataVersion> prev;
        MetadataVersion version = highVersion;
        while (!version.didMetadataChange() && version != lowVersion && (prev = version.previous()).isPresent()) {
            version = prev.get();
        }
        return version != lowVersion;
    }

    public boolean isAtLeast(MetadataVersion otherVersion) {
        return this.compareTo(otherVersion) >= 0;
    }

    public boolean isLessThan(MetadataVersion otherVersion) {
        return this.compareTo(otherVersion) < 0;
    }

    public String toString() {
        return this.version();
    }

    static {
        MINIMUM_KRAFT_VERSION = IBP_3_0_IV1;
        MINIMUM_BOOTSTRAP_VERSION = IBP_3_3_IV0;
        MetadataVersion[] enumValues = MetadataVersion.values();
        VERSIONS = Arrays.copyOf(enumValues, enumValues.length);
        IBP_VERSIONS = new HashMap<String, MetadataVersion>();
        CONFLUENT_VERSIONS = new HashMap<String, MetadataVersion>();
        for (MetadataVersion metadataVersion : VERSIONS) {
            IBP_VERSIONS.put(metadataVersion.shortVersion(), metadataVersion);
            IBP_VERSIONS.put(metadataVersion.version(), metadataVersion);
            CONFLUENT_VERSIONS.put(metadataVersion.shortConfluentRelease(), metadataVersion);
            CONFLUENT_VERSIONS.put(metadataVersion.confluentRelease(), metadataVersion);
        }
    }
}

