/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

public class TenantUtils {
    public static final String GROUP = "tenant-metrics";
    public static final String TENANT_TAG = "tenant";
    public static final String USER_TAG = "user";
    public static final String USER_RESOURCE_ID_TAG = "user-resource-id";
    public static final String CLIENT_ID_TAG = "client-id";
    public static final String IP_TAG = "ip";
    public static final String CONSUMER_GROUP_TAG = "consumer-group";
    public static final String MEMBER_TAG = "member";
    public static final String GROUP_INSTANCE_ID_TAG = "group-instance-id";
    public static final String TOPIC_TAG = "topic";
    public static final String PARTITION_TAG = "partition";
    public static final String AUTH_METHOD_TAG = "auth-method";
    public static final String AUTH_CREDENTIAL_TAG = "auth-credential";
    public static final String ZONE_ALIGNMENT_TAG = "zone-alignment";
    public static final String REQUEST_TAG = "request";
    private static final char TENANT_PREFIX_DELIMITER = '_';

    public static Optional<String> extractTenantId(Collection<String> topicNames) {
        return topicNames.stream().map(topicName -> TenantUtils.extractTenantPrefix(topicName, false)).filter(Objects::nonNull).findFirst();
    }

    public static String extractTenantPrefix(String name, boolean includeDelimiter) {
        if (!name.startsWith("lkc-")) {
            return null;
        }
        int delimIndex = name.indexOf(95);
        if (delimIndex == -1) {
            return null;
        }
        return includeDelimiter ? name.substring(0, delimIndex + 1) : name.substring(0, delimIndex);
    }
}

