/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class TenantUtils {
    public static final String GROUP = "tenant-metrics";
    public static final String TENANT_TAG = "tenant";
    public static final String INTERNAL_TENANT_LKC = "lkc-internal-tenant";
    public static final String USER_TAG = "user";
    public static final String USER_RESOURCE_ID_TAG = "user-resource-id";
    public static final String CLIENT_ID_TAG = "client-id";
    public static final String GROUP_PROTOCOL_TAG = "group-protocol";
    public static final String CLIENT_SOFTWARE_NAME_TAG = "client-software-name";
    public static final String CLIENT_SOFTWARE_VERSION_TAG = "client-software-version";
    public static final String IP_TAG = "ip";
    public static final String CONSUMER_GROUP_TAG = "consumer-group";
    public static final String MEMBER_TAG = "member";
    public static final String GROUP_INSTANCE_ID_TAG = "group-instance-id";
    public static final String TOPIC_TAG = "topic";
    public static final String PARTITION_TAG = "partition";
    public static final String AUTH_METHOD_TAG = "auth-method";
    public static final String AUTH_CREDENTIAL_TAG = "auth-credential";
    public static final String ZONE_ALIGNMENT_TAG = "zone-alignment";
    public static final String IS_SUPPORTED_FFF_CLIENT_TAG = "is-supported-fff-client";
    public static final String REQUEST_TAG = "request";
    public static final String APPLICATION_IDENTITY_TAG = "application-identity";
    private static final char TENANT_PREFIX_DELIMITER = '_';
    public static final String CLIENT_ZONE_ID_TAG = "client-zone-id";
    public static final String GATEWAY_ZONE_ID_TAG = "gateway-zone-id";
    public static final String BROKER_ZONE_ID_TAG = "broker-zone-id";
    public static final Function<String, String> NAME_TO_TENANT_CALLBACK = name -> TenantUtils.extractTenantPrefix(name, true);
    private static long tenantPartitionCountThresholdInMs = 300000L;

    public static Optional<String> extractTenantId(Collection<String> topicNames) {
        return topicNames.stream().map(topicName -> TenantUtils.extractTenantPrefix(topicName, false)).filter(Objects::nonNull).findFirst();
    }

    public static Optional<String> extractTenantId(String topic) {
        return TenantUtils.extractTenantId(Collections.singletonList(topic));
    }

    public static String extractTenantPrefix(String name, boolean includeDelimiter) {
        if (!name.startsWith("lkc-")) {
            return null;
        }
        int delimIndex = name.indexOf(95);
        if (delimIndex == -1) {
            return null;
        }
        return includeDelimiter ? name.substring(0, delimIndex + 1) : name.substring(0, delimIndex);
    }

    public static String addTenantPrefix(String prefix, String name) {
        return prefix + name;
    }

    public static String removeTenantPrefix(String name) {
        if (!name.startsWith("lkc-")) {
            return name;
        }
        int delimIndex = name.indexOf(95);
        if (delimIndex == -1) {
            return null;
        }
        return name.substring(delimIndex + 1);
    }

    public static String removeTenantPrefix(String prefix, String name) {
        if (!name.startsWith(prefix)) {
            return name;
        }
        return name.substring(prefix.length());
    }

    public static Function<String, String> tenantPrefixer(String exampleResource) {
        String tenantPrefix = TenantUtils.extractTenantPrefix(exampleResource, true);
        if (tenantPrefix == null) {
            return name -> name;
        }
        return name -> TenantUtils.addTenantPrefix(tenantPrefix, name);
    }

    public static Function<String, String> tenantUnprefixer(String exampleResource) {
        String tenantPrefix = TenantUtils.extractTenantPrefix(exampleResource, true);
        if (tenantPrefix == null) {
            return name -> name;
        }
        return name -> TenantUtils.removeTenantPrefix(tenantPrefix, name);
    }

    public static void setTenantPartitionCountUpdateThresholdInMs(Long minute) {
        tenantPartitionCountThresholdInMs = minute * 60L * 1000L;
    }

    public static Long getTenantPartitionCountUpdateThresholdInMs() {
        return tenantPartitionCountThresholdInMs;
    }
}

