/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.common.utils;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.utils.Utils;

public class ConfluentUtils {
    private static final String LKC_REGEX = "\\b(lkc-[a-zA-Z0-9]+)\\b";
    private static final Pattern LKC_REGEX_PATTERN = Pattern.compile("\\b(lkc-[a-zA-Z0-9]+)\\b");

    public static boolean hasCCloudHostPattern(Map<String, ?> configs, String host) {
        if (host == null) {
            return false;
        }
        List cCloudHostSuffixes = ConfluentConfigs.ccloudHostSuffixes(configs);
        return cCloudHostSuffixes.stream().anyMatch(pattern -> host.toLowerCase(Locale.ROOT).endsWith((String)pattern));
    }

    public static boolean hasCCloudIntranetHostPattern(Map<String, ?> configs, String host) {
        if (host == null) {
            return false;
        }
        List intranetHostSuffixes = ConfluentConfigs.ccloudIntranetHostSuffixes(configs);
        return intranetHostSuffixes.stream().anyMatch(pattern -> host.toLowerCase(Locale.ROOT).endsWith((String)pattern));
    }

    public static Optional<String> maybeParseRemoteClusterIdFromBootstrap(List<String> bootstrapServers) {
        if (bootstrapServers == null || bootstrapServers.isEmpty()) {
            return Optional.empty();
        }
        String firstHost = bootstrapServers.stream().filter(bootstrap -> bootstrap != null && !bootstrap.isEmpty()).map(Utils::getHost).filter(host -> host != null && host.toLowerCase(Locale.ROOT).startsWith("lkc-")).findFirst().orElse(null);
        if (firstHost != null) {
            return Optional.ofNullable(ConfluentUtils.extractClusterIdFromHost(firstHost.toLowerCase(Locale.ROOT)));
        }
        return Optional.empty();
    }

    static String extractClusterIdFromHost(String host) {
        Matcher matcher = LKC_REGEX_PATTERN.matcher(host);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

