/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.Map;
import org.apache.kafka.server.common.FeatureVersion;
import org.apache.kafka.server.common.MetadataVersion;

public enum EligibleLeaderReplicasVersion implements FeatureVersion
{
    ELRV_0(0, MetadataVersion.MINIMUM_VERSION, Map.of()),
    ELRV_1(1, MetadataVersion.IBP_4_1_IV0B, Map.of("confluent.metadata.version", MetadataVersion.IBP_4_0_IV1A.confluentFeatureLevel()));

    public static final String FEATURE_NAME = "eligible.leader.replicas.version";
    public static final EligibleLeaderReplicasVersion LATEST_PRODUCTION;
    private final short featureLevel;
    private final MetadataVersion bootstrapMetadataVersion;
    private final Map<String, Short> dependencies;

    private EligibleLeaderReplicasVersion(int featureLevel, MetadataVersion bootstrapMetadataVersion, Map<String, Short> dependencies) {
        this.featureLevel = (short)featureLevel;
        this.bootstrapMetadataVersion = bootstrapMetadataVersion;
        this.dependencies = dependencies;
    }

    @Override
    public short featureLevel() {
        return this.featureLevel;
    }

    @Override
    public String featureName() {
        return FEATURE_NAME;
    }

    @Override
    public MetadataVersion bootstrapMetadataVersion() {
        return this.bootstrapMetadataVersion;
    }

    @Override
    public Map<String, Short> dependencies() {
        return this.dependencies;
    }

    public static EligibleLeaderReplicasVersion fromFeatureLevel(short version) {
        switch (version) {
            case 0: {
                return ELRV_0;
            }
            case 1: {
                return ELRV_1;
            }
        }
        throw new RuntimeException("Unknown eligible leader replicas feature level: " + version);
    }

    static {
        LATEST_PRODUCTION = ELRV_1;
    }
}

