/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.purgatory;

import java.util.Objects;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.purgatory.DelayedOperationKey;

public class TierFetchOperationKey
implements DelayedOperationKey {
    private final String topic;
    private final int partition;
    private final Uuid id;

    public TierFetchOperationKey(TopicPartition topicPartition, Uuid id) {
        this.topic = topicPartition.topic();
        this.partition = topicPartition.partition();
        this.id = id;
    }

    @Override
    public String keyLabel() {
        return this.topic + "-" + this.partition + "-" + String.valueOf(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TierFetchOperationKey that = (TierFetchOperationKey)o;
        return Objects.equals(this.topic, that.topic) && Objects.equals(this.partition, that.partition) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.partition, this.id);
    }
}

