/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.server.common.AlterReplicaExclusionOp;
import org.apache.kafka.server.common.AlterReplicaExclusionsReply;
import org.apache.kafka.server.common.BrokerReplicaExclusionModificationResult;
import org.apache.kafka.server.common.BrokerReplicaExclusionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerReplicaExclusionUtils {
    private static final Logger log = LoggerFactory.getLogger(BrokerReplicaExclusionUtils.class);

    public static BrokerReplicaExclusionModificationResult prepareReplicaExclusions(Map<Integer, String> exclusionsToModify, Set<AlterReplicaExclusionOp> requestedExclusions) {
        HashMap<Integer, String> exclusions = new HashMap<Integer, String>(exclusionsToModify);
        boolean shouldApply = true;
        HashSet<BrokerReplicaExclusionResult> responseResults = new HashSet<BrokerReplicaExclusionResult>(requestedExclusions.size());
        for (AlterReplicaExclusionOp requestedExclusion : requestedExclusions) {
            Optional<ApiError> errorOpt;
            int brokerId = requestedExclusion.brokerId();
            String reason = requestedExclusion.reason();
            ExclusionOp.OpType opType = requestedExclusion.opType();
            if (opType == ExclusionOp.OpType.SET) {
                exclusions.put(brokerId, reason);
                errorOpt = Optional.empty();
            } else if (opType == ExclusionOp.OpType.DELETE) {
                if (exclusions.containsKey(brokerId)) {
                    exclusions.remove(brokerId);
                    errorOpt = Optional.empty();
                } else {
                    errorOpt = Optional.of(new ApiError(Errors.BROKER_REPLICA_PLACEMENT_EXCLUSION_NOT_FOUND, String.format("No replica exclusion for broker %d was present", brokerId)));
                }
            } else {
                errorOpt = Optional.of(new ApiError(Errors.INVALID_REPLICA_EXCLUSION, String.format("The operation type %s is not recognized", opType)));
            }
            if (errorOpt.isPresent()) {
                log.info("Replica exclusion operation {} for broker {} is invalid due to {}", new Object[]{opType, brokerId, errorOpt.get()});
                shouldApply = false;
            }
            responseResults.add(new BrokerReplicaExclusionResult(brokerId, errorOpt, opType, reason));
        }
        HashMap<Integer, String> exclusionsAfterModification = shouldApply ? exclusions : new HashMap<Integer, String>(exclusionsToModify);
        return new BrokerReplicaExclusionModificationResult(new AlterReplicaExclusionsReply(shouldApply, false, responseResults), exclusionsAfterModification);
    }

    public static boolean exclusionExists(Map<Integer, String> existingExclusions, int givenBrokerId, String givenReason) {
        if (!BrokerReplicaExclusionUtils.exclusionExists(existingExclusions, givenBrokerId)) {
            return false;
        }
        String reason = existingExclusions.get(givenBrokerId);
        if (reason == null) {
            return givenReason == null;
        }
        return reason.equals(givenReason);
    }

    public static boolean exclusionExists(Map<Integer, String> existingExclusions, int givenBrokerId) {
        return existingExclusions.containsKey(givenBrokerId);
    }

    public static boolean exclusionsMatchCurrentState(Map<Integer, String> currentBrokerReplicaExclusions, Set<AlterReplicaExclusionOp> requestedExclusions) {
        return requestedExclusions.stream().allMatch(requestedExclusionOp -> {
            int brokerId = requestedExclusionOp.brokerId();
            ExclusionOp.OpType opType = requestedExclusionOp.opType();
            String givenReason = requestedExclusionOp.reason();
            if (opType == ExclusionOp.OpType.SET) {
                return BrokerReplicaExclusionUtils.exclusionExists(currentBrokerReplicaExclusions, brokerId, givenReason);
            }
            if (opType == ExclusionOp.OpType.DELETE) {
                return !BrokerReplicaExclusionUtils.exclusionExists(currentBrokerReplicaExclusions, brokerId);
            }
            log.warn("Could not recognize operation type {} while validating whether the requested exclusion state matches the current one", (Object)opType);
            return false;
        });
    }
}

